/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.roots.InheritedJdkOrderEntry;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderEnumerator;
import com.intellij.openapi.roots.RootPolicy;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.roots.impl.ModuleOrderEnumerator;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;

public abstract class RootModelBase
implements ModuleRootModel {
    @NotNull
    public VirtualFile[] getContentRoots() {
        ArrayList<VirtualFile> result2 = new ArrayList<VirtualFile>();
        for (ContentEntry contentEntry : this.getContent()) {
            VirtualFile file2 = contentEntry.getFile();
            if (file2 == null) continue;
            result2.add(file2);
        }
        VirtualFile[] virtualFileArray = VfsUtilCore.toVirtualFileArray(result2);
        if (virtualFileArray == null) {
            RootModelBase.$$$reportNull$$$0(0);
        }
        return virtualFileArray;
    }

    @NotNull
    public String[] getContentRootUrls() {
        if (this.getContent().isEmpty()) {
            if (ArrayUtil.EMPTY_STRING_ARRAY == null) {
                RootModelBase.$$$reportNull$$$0(1);
            }
            return ArrayUtil.EMPTY_STRING_ARRAY;
        }
        ArrayList<String> result2 = new ArrayList<String>(this.getContent().size());
        for (ContentEntry contentEntry : this.getContent()) {
            result2.add(contentEntry.getUrl());
        }
        String[] stringArray = ArrayUtil.toStringArray(result2);
        if (stringArray == null) {
            RootModelBase.$$$reportNull$$$0(2);
        }
        return stringArray;
    }

    @NotNull
    public String[] getExcludeRootUrls() {
        SmartList result2 = new SmartList();
        for (ContentEntry contentEntry : this.getContent()) {
            result2.addAll(contentEntry.getExcludeFolderUrls());
        }
        String[] stringArray = ArrayUtil.toStringArray((Collection)result2);
        if (stringArray == null) {
            RootModelBase.$$$reportNull$$$0(3);
        }
        return stringArray;
    }

    @NotNull
    public VirtualFile[] getExcludeRoots() {
        SmartList result2 = new SmartList();
        for (ContentEntry contentEntry : this.getContent()) {
            Collections.addAll(result2, contentEntry.getExcludeFolderFiles());
        }
        VirtualFile[] virtualFileArray = VfsUtilCore.toVirtualFileArray((Collection)result2);
        if (virtualFileArray == null) {
            RootModelBase.$$$reportNull$$$0(4);
        }
        return virtualFileArray;
    }

    @NotNull
    public String[] getSourceRootUrls() {
        String[] stringArray = this.getSourceRootUrls(true);
        if (stringArray == null) {
            RootModelBase.$$$reportNull$$$0(5);
        }
        return stringArray;
    }

    @NotNull
    public String[] getSourceRootUrls(boolean includingTests) {
        SmartList result2 = new SmartList();
        for (ContentEntry contentEntry : this.getContent()) {
            SourceFolder[] sourceFolders;
            for (SourceFolder sourceFolder : sourceFolders = contentEntry.getSourceFolders()) {
                if (!includingTests && sourceFolder.isTestSource()) continue;
                result2.add(sourceFolder.getUrl());
            }
        }
        String[] stringArray = ArrayUtil.toStringArray((Collection)result2);
        if (stringArray == null) {
            RootModelBase.$$$reportNull$$$0(6);
        }
        return stringArray;
    }

    @NotNull
    public VirtualFile[] getSourceRoots() {
        VirtualFile[] virtualFileArray = this.getSourceRoots(true);
        if (virtualFileArray == null) {
            RootModelBase.$$$reportNull$$$0(7);
        }
        return virtualFileArray;
    }

    @NotNull
    public VirtualFile[] getSourceRoots(boolean includingTests) {
        SmartList result2 = new SmartList();
        for (ContentEntry contentEntry : this.getContent()) {
            SourceFolder[] sourceFolders;
            for (SourceFolder sourceFolder : sourceFolders = contentEntry.getSourceFolders()) {
                VirtualFile file2 = sourceFolder.getFile();
                if (file2 == null || !includingTests && sourceFolder.isTestSource()) continue;
                result2.add(file2);
            }
        }
        VirtualFile[] virtualFileArray = VfsUtilCore.toVirtualFileArray((Collection)result2);
        if (virtualFileArray == null) {
            RootModelBase.$$$reportNull$$$0(8);
        }
        return virtualFileArray;
    }

    @NotNull
    public List<VirtualFile> getSourceRoots(@NotNull JpsModuleSourceRootType<?> rootType) {
        if (rootType == null) {
            RootModelBase.$$$reportNull$$$0(9);
        }
        List<VirtualFile> list2 = this.getSourceRoots(Collections.singleton(rootType));
        if (list2 == null) {
            RootModelBase.$$$reportNull$$$0(10);
        }
        return list2;
    }

    @NotNull
    public List<VirtualFile> getSourceRoots(@NotNull Set<? extends JpsModuleSourceRootType<?>> rootTypes) {
        if (rootTypes == null) {
            RootModelBase.$$$reportNull$$$0(11);
        }
        SmartList result2 = new SmartList();
        for (ContentEntry contentEntry : this.getContent()) {
            List sourceFolders = contentEntry.getSourceFolders(rootTypes);
            for (SourceFolder sourceFolder : sourceFolders) {
                VirtualFile file2 = sourceFolder.getFile();
                if (file2 == null) continue;
                result2.add(file2);
            }
        }
        SmartList smartList = result2;
        if (smartList == null) {
            RootModelBase.$$$reportNull$$$0(12);
        }
        return smartList;
    }

    @NotNull
    public ContentEntry[] getContentEntries() {
        Collection<ContentEntry> content = this.getContent();
        ContentEntry[] contentEntryArray = content.toArray(new ContentEntry[content.size()]);
        if (contentEntryArray == null) {
            RootModelBase.$$$reportNull$$$0(13);
        }
        return contentEntryArray;
    }

    protected abstract Collection<ContentEntry> getContent();

    public Sdk getSdk() {
        for (OrderEntry orderEntry : this.getOrderEntries()) {
            if (!(orderEntry instanceof JdkOrderEntry)) continue;
            return ((JdkOrderEntry)orderEntry).getJdk();
        }
        return null;
    }

    public boolean isSdkInherited() {
        for (OrderEntry orderEntry : this.getOrderEntries()) {
            if (!(orderEntry instanceof InheritedJdkOrderEntry)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public OrderEnumerator orderEntries() {
        ModuleOrderEnumerator moduleOrderEnumerator = new ModuleOrderEnumerator(this, null);
        if (moduleOrderEnumerator == null) {
            RootModelBase.$$$reportNull$$$0(14);
        }
        return moduleOrderEnumerator;
    }

    public <R> R processOrder(RootPolicy<R> policy, R initialValue) {
        Object result2 = initialValue;
        for (OrderEntry orderEntry : this.getOrderEntries()) {
            result2 = orderEntry.accept(policy, result2);
        }
        return result2;
    }

    @NotNull
    public String[] getDependencyModuleNames() {
        List result2 = (List)this.orderEntries().withoutSdk().withoutLibraries().withoutModuleSourceEntries().process((RootPolicy)new CollectDependentModules(), new ArrayList());
        String[] stringArray = ArrayUtil.toStringArray((Collection)result2);
        if (stringArray == null) {
            RootModelBase.$$$reportNull$$$0(15);
        }
        return stringArray;
    }

    @NotNull
    public Module[] getModuleDependencies() {
        Module[] moduleArray = this.getModuleDependencies(true);
        if (moduleArray == null) {
            RootModelBase.$$$reportNull$$$0(16);
        }
        return moduleArray;
    }

    @NotNull
    public Module[] getModuleDependencies(boolean includeTests) {
        OrderEntry[] entries = this.getOrderEntries();
        List result2 = null;
        for (OrderEntry entry : entries) {
            Module module;
            if (!(entry instanceof ModuleOrderEntry)) continue;
            DependencyScope scope = ((ModuleOrderEntry)entry).getScope();
            if (!includeTests && !scope.isForProductionCompile() && !scope.isForProductionRuntime() || (module = ((ModuleOrderEntry)entry).getModule()) == null) continue;
            if (result2 == null) {
                result2 = new SmartList();
            }
            result2.add(module);
        }
        Module[] moduleArray = result2 == null ? Module.EMPTY_ARRAY : (Module[])ContainerUtil.toArray((List)result2, (Object[])new Module[result2.size()]);
        if (moduleArray == null) {
            RootModelBase.$$$reportNull$$$0(17);
        }
        return moduleArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 9: 
            case 11: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 9: 
            case 11: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/roots/impl/RootModelBase";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootType";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootTypes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getContentRoots";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getContentRootUrls";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getExcludeRootUrls";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getExcludeRoots";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getSourceRootUrls";
                break;
            }
            case 7: 
            case 8: 
            case 10: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getSourceRoots";
                break;
            }
            case 9: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/roots/impl/RootModelBase";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getContentEntries";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "orderEntries";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getDependencyModuleNames";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleDependencies";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 9: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getSourceRoots";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 9: 
            case 11: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class CollectDependentModules
    extends RootPolicy<List<String>> {
        private CollectDependentModules() {
        }

        @NotNull
        public List<String> visitModuleOrderEntry(@NotNull ModuleOrderEntry moduleOrderEntry, @NotNull List<String> arrayList) {
            if (moduleOrderEntry == null) {
                CollectDependentModules.$$$reportNull$$$0(0);
            }
            if (arrayList == null) {
                CollectDependentModules.$$$reportNull$$$0(1);
            }
            arrayList.add(moduleOrderEntry.getModuleName());
            List<String> list2 = arrayList;
            if (list2 == null) {
                CollectDependentModules.$$$reportNull$$$0(2);
            }
            return list2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "moduleOrderEntry";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "arrayList";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/roots/impl/RootModelBase$CollectDependentModules";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/roots/impl/RootModelBase$CollectDependentModules";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "visitModuleOrderEntry";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "visitModuleOrderEntry";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

