/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.patch.tool;

import com.intellij.diff.DiffContentFactory;
import com.intellij.diff.DiffContext;
import com.intellij.diff.DiffDialogHints;
import com.intellij.diff.DiffManager;
import com.intellij.diff.actions.ProxyUndoRedoAction;
import com.intellij.diff.actions.impl.FocusOppositePaneAction;
import com.intellij.diff.actions.impl.SetEditorSettingsAction;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.contents.DocumentContent;
import com.intellij.diff.merge.MergeModelBase;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.requests.SimpleDiffRequest;
import com.intellij.diff.tools.fragmented.LineNumberConvertor;
import com.intellij.diff.tools.holders.TextEditorHolder;
import com.intellij.diff.tools.util.DiffDataKeys;
import com.intellij.diff.tools.util.DiffSplitter;
import com.intellij.diff.tools.util.FocusTrackerSupport;
import com.intellij.diff.tools.util.FoldingModelSupport;
import com.intellij.diff.tools.util.PrevNextDifferenceIterableBase;
import com.intellij.diff.tools.util.SimpleDiffPanel;
import com.intellij.diff.tools.util.StatusPanel;
import com.intellij.diff.tools.util.SyncScrollSupport;
import com.intellij.diff.tools.util.base.TextDiffSettingsHolder;
import com.intellij.diff.tools.util.base.TextDiffViewerUtil;
import com.intellij.diff.tools.util.side.TwosideContentPanel;
import com.intellij.diff.util.DiffDividerDrawUtil;
import com.intellij.diff.util.DiffDrawUtil;
import com.intellij.diff.util.DiffUserDataKeys;
import com.intellij.diff.util.DiffUtil;
import com.intellij.diff.util.LineRange;
import com.intellij.diff.util.Side;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.CompositeShortcutSet;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.command.UndoConfirmationPolicy;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.event.VisibleAreaListener;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.EditorMarkupModel;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.BooleanGetter;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.changes.patch.AppliedTextPatch;
import com.intellij.openapi.vcs.changes.patch.tool.ApplyPatchChange;
import com.intellij.openapi.vcs.changes.patch.tool.ApplyPatchRequest;
import com.intellij.openapi.vcs.changes.patch.tool.PatchChangeBuilder;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.TIntArrayList;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ApplyPatchViewer
implements DataProvider,
Disposable {
    private static final Logger LOG = Logger.getInstance(ApplyPatchViewer.class);
    @Nullable
    private final Project myProject;
    @NotNull
    private final DiffContext myContext;
    @NotNull
    private final ApplyPatchRequest myPatchRequest;
    @NotNull
    private final TextEditorHolder myResultHolder;
    @NotNull
    private final TextEditorHolder myPatchHolder;
    @NotNull
    private final EditorEx myResultEditor;
    @NotNull
    private final EditorEx myPatchEditor;
    @NotNull
    private final SimpleDiffPanel myPanel;
    @NotNull
    private final TwosideContentPanel myContentPanel;
    @NotNull
    private final MyModel myModel;
    @NotNull
    private final FocusTrackerSupport<Side> myFocusTrackerSupport;
    @NotNull
    private final MyPrevNextDifferenceIterable myPrevNextDifferenceIterable;
    @NotNull
    private final StatusPanel myStatusPanel;
    @NotNull
    private final MyFoldingModel myFoldingModel;
    @NotNull
    private final SetEditorSettingsAction myEditorSettingsAction;
    @NotNull
    private final List<ApplyPatchChange> myResultChanges;
    @NotNull
    private final List<ApplyPatchChange> myPatchChanges;
    @NotNull
    private final List<ApplyPatchChange> myModelChanges;
    private boolean myDisposed;

    public ApplyPatchViewer(@NotNull DiffContext context, @NotNull ApplyPatchRequest request) {
        if (context == null) {
            ApplyPatchViewer.$$$reportNull$$$0(0);
        }
        if (request == null) {
            ApplyPatchViewer.$$$reportNull$$$0(1);
        }
        this.myResultChanges = new ArrayList<ApplyPatchChange>();
        this.myPatchChanges = new ArrayList<ApplyPatchChange>();
        this.myModelChanges = new ArrayList<ApplyPatchChange>();
        this.myProject = context.getProject();
        this.myContext = context;
        this.myPatchRequest = request;
        DocumentContent resultContent = request.getResultContent();
        DocumentContent patchContent = DiffContentFactory.getInstance().create(EditorFactory.getInstance().createDocument((CharSequence)""), resultContent);
        this.myResultHolder = TextEditorHolder.create(this.myProject, resultContent);
        this.myPatchHolder = TextEditorHolder.create(this.myProject, patchContent);
        this.myResultEditor = this.myResultHolder.getEditor();
        this.myPatchEditor = this.myPatchHolder.getEditor();
        if (this.isReadOnly()) {
            this.myResultEditor.setViewer(true);
        }
        this.myPatchEditor.setViewer(true);
        DiffUtil.disableBlitting(this.myResultEditor);
        DiffUtil.disableBlitting(this.myPatchEditor);
        ((EditorMarkupModel)((Object)this.myResultEditor.getMarkupModel())).setErrorStripeVisible(false);
        this.myResultEditor.setVerticalScrollbarOrientation(0);
        this.myPatchEditor.getGutterComponentEx().setForceShowRightFreePaintersArea(true);
        ((EditorMarkupModel)((Object)this.myPatchEditor.getMarkupModel())).setErrorStripeVisible(false);
        List holders = ContainerUtil.list((Object[])new TextEditorHolder[]{this.myResultHolder, this.myPatchHolder});
        List editors = ContainerUtil.list((Object[])new EditorEx[]{this.myResultEditor, this.myPatchEditor});
        JComponent resultTitle = DiffUtil.createTitle(this.myPatchRequest.getResultTitle());
        JComponent patchTitle = DiffUtil.createTitle(this.myPatchRequest.getPatchTitle());
        List<JComponent> titleComponents = DiffUtil.createSyncHeightComponents(ContainerUtil.list((Object[])new JComponent[]{resultTitle, patchTitle}));
        this.myContentPanel = new TwosideContentPanel(holders, titleComponents);
        this.myPanel = new SimpleDiffPanel(this.myContentPanel, (DataProvider)this, this.myContext);
        this.myModel = new MyModel(this.myProject, this.myResultEditor.getDocument());
        this.myFocusTrackerSupport = new FocusTrackerSupport.Twoside(holders);
        this.myFocusTrackerSupport.setCurrentSide(Side.LEFT);
        this.myPrevNextDifferenceIterable = new MyPrevNextDifferenceIterable();
        this.myStatusPanel = new MyStatusPanel();
        this.myFoldingModel = new MyFoldingModel(this.myResultEditor, (Disposable)this);
        DiffUtil.installLineConvertor(this.myResultEditor, this.myFoldingModel);
        new MyFocusOppositePaneAction().install(this.myPanel);
        new TextDiffViewerUtil.EditorActionsPopup(this.createEditorPopupActions()).install(editors);
        new TextDiffViewerUtil.EditorFontSizeSynchronizer(editors).install(this);
        this.myEditorSettingsAction = new SetEditorSettingsAction(this.getTextSettings(), editors);
        this.myEditorSettingsAction.applyDefaults();
        if (!this.isReadOnly()) {
            DiffUtil.registerAction((AnAction)new ApplySelectedChangesAction(true), this.myPanel);
            DiffUtil.registerAction((AnAction)new IgnoreSelectedChangesAction(true), this.myPanel);
        }
        ProxyUndoRedoAction.register(this.myProject, this.myResultEditor, this.myContentPanel);
    }

    @NotNull
    protected List<AnAction> createToolbarActions() {
        ArrayList<AnAction> group = new ArrayList<AnAction>();
        if (!this.isReadOnly()) {
            group.add((AnAction)new MyToggleExpandByDefaultAction());
            group.add((AnAction)this.myEditorSettingsAction);
            group.add((AnAction)Separator.getInstance());
            group.add((AnAction)new ShowDiffWithLocalAction());
            group.add((AnAction)new ApplyNonConflictsAction());
        }
        ArrayList<AnAction> arrayList = group;
        if (arrayList == null) {
            ApplyPatchViewer.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    @NotNull
    private List<AnAction> createEditorPopupActions() {
        ArrayList<AnAction> group = new ArrayList<AnAction>();
        if (!this.isReadOnly()) {
            group.add((AnAction)new ApplySelectedChangesAction(false));
            group.add((AnAction)new IgnoreSelectedChangesAction(false));
        }
        group.add((AnAction)Separator.getInstance());
        group.addAll(TextDiffViewerUtil.createEditorPopupActions());
        ArrayList<AnAction> arrayList = group;
        if (arrayList == null) {
            ApplyPatchViewer.$$$reportNull$$$0(3);
        }
        return arrayList;
    }

    public void dispose() {
        if (this.myDisposed) {
            return;
        }
        this.myDisposed = true;
        this.myFoldingModel.destroy();
        Disposer.dispose((Disposable)this.myModel);
        Disposer.dispose((Disposable)this.myResultHolder);
        Disposer.dispose((Disposable)this.myPatchHolder);
    }

    public boolean isReadOnly() {
        return !DiffUtil.canMakeWritable(this.myResultEditor.getDocument());
    }

    @NotNull
    public MyModel getModel() {
        MyModel myModel = this.myModel;
        if (myModel == null) {
            ApplyPatchViewer.$$$reportNull$$$0(4);
        }
        return myModel;
    }

    @NotNull
    public List<ApplyPatchChange> getModelChanges() {
        List<ApplyPatchChange> list2 = this.myModelChanges;
        if (list2 == null) {
            ApplyPatchViewer.$$$reportNull$$$0(5);
        }
        return list2;
    }

    public boolean isDisposed() {
        return this.myDisposed;
    }

    @NotNull
    public StatusPanel getStatusPanel() {
        StatusPanel statusPanel = this.myStatusPanel;
        if (statusPanel == null) {
            ApplyPatchViewer.$$$reportNull$$$0(6);
        }
        return statusPanel;
    }

    @NotNull
    public JComponent getComponent() {
        SimpleDiffPanel simpleDiffPanel = this.myPanel;
        if (simpleDiffPanel == null) {
            ApplyPatchViewer.$$$reportNull$$$0(7);
        }
        return simpleDiffPanel;
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.myResultEditor.getContentComponent();
    }

    @NotNull
    public EditorEx getResultEditor() {
        EditorEx editorEx = this.myResultEditor;
        if (editorEx == null) {
            ApplyPatchViewer.$$$reportNull$$$0(8);
        }
        return editorEx;
    }

    @NotNull
    public EditorEx getPatchEditor() {
        EditorEx editorEx = this.myPatchEditor;
        if (editorEx == null) {
            ApplyPatchViewer.$$$reportNull$$$0(9);
        }
        return editorEx;
    }

    @NotNull
    public Side getCurrentSide() {
        Side side = this.myFocusTrackerSupport.getCurrentSide();
        if (side == null) {
            ApplyPatchViewer.$$$reportNull$$$0(10);
        }
        return side;
    }

    @NotNull
    public List<ApplyPatchChange> getPatchChanges() {
        List<ApplyPatchChange> list2 = this.myPatchChanges;
        if (list2 == null) {
            ApplyPatchViewer.$$$reportNull$$$0(11);
        }
        return list2;
    }

    @Nullable
    public Object getData(@NonNls String dataId) {
        if (CommonDataKeys.PROJECT.is(dataId)) {
            return this.myProject;
        }
        if (DiffDataKeys.PREV_NEXT_DIFFERENCE_ITERABLE.is(dataId)) {
            return this.myPrevNextDifferenceIterable;
        }
        return null;
    }

    @NotNull
    public TextDiffSettingsHolder.TextDiffSettings getTextSettings() {
        TextDiffSettingsHolder.TextDiffSettings textDiffSettings = TextDiffSettingsHolder.TextDiffSettings.getSettings("ApplyPatch");
        if (textDiffSettings == null) {
            ApplyPatchViewer.$$$reportNull$$$0(12);
        }
        return textDiffSettings;
    }

    @NotNull
    public FoldingModelSupport.Settings getFoldingModelSettings() {
        TextDiffSettingsHolder.TextDiffSettings settings = this.getTextSettings();
        FoldingModelSupport.Settings settings2 = new FoldingModelSupport.Settings(settings.getContextRange(), settings.isExpandByDefault());
        if (settings2 == null) {
            ApplyPatchViewer.$$$reportNull$$$0(13);
        }
        return settings2;
    }

    protected void initPatchViewer() {
        this.myPanel.setPersistentNotifications(DiffUtil.getCustomNotifications((UserDataHolder)this.myContext, this.myPatchRequest));
        DocumentEx outputDocument = this.myResultEditor.getDocument();
        boolean success2 = DiffUtil.executeWriteCommand(outputDocument, this.myProject, "Init merge content", () -> {
            outputDocument.setText(this.myPatchRequest.getLocalContent());
            if (!this.isReadOnly()) {
                DiffUtil.putNonundoableOperation(this.myProject, outputDocument);
            }
        });
        if (!success2 && !StringUtil.equals((CharSequence)outputDocument.getText(), (CharSequence)this.myPatchRequest.getLocalContent())) {
            this.myPanel.setErrorContent("Failed to display patch applier - local content was modified");
            return;
        }
        PatchChangeBuilder builder = new PatchChangeBuilder();
        builder.exec(this.myPatchRequest.getPatch().getHunks());
        DocumentEx patchDocument = this.myPatchEditor.getDocument();
        WriteAction.run(() -> patchDocument.setText(builder.getPatchContent()));
        LineNumberConvertor convertor1 = builder.getLineConvertor1();
        LineNumberConvertor convertor2 = builder.getLineConvertor2();
        this.myPatchEditor.getGutterComponentEx().setLineNumberConvertor(convertor1.createConvertor(), convertor2.createConvertor());
        TIntArrayList lines2 = builder.getSeparatorLines();
        for (int i = 0; i < lines2.size(); ++i) {
            int offset = patchDocument.getLineStartOffset(lines2.get(i));
            DiffDrawUtil.createLineSeparatorHighlighter(this.myPatchEditor, offset, offset, BooleanGetter.TRUE);
        }
        List<PatchChangeBuilder.Hunk> hunks = builder.getHunks();
        int[] modelToPatchIndexes = DiffUtil.getSortedIndexes(hunks, (h1, h2) -> {
            LineRange lines1 = h1.getAppliedToLines();
            LineRange lines2 = h2.getAppliedToLines();
            if (lines1 == null && lines2 == null) {
                return 0;
            }
            if (lines1 == null) {
                return -1;
            }
            if (lines2 == null) {
                return 1;
            }
            return lines1.start - lines2.start;
        });
        int[] patchToModelIndexes = DiffUtil.invertIndexes(modelToPatchIndexes);
        ArrayList<LineRange> modelRanges = new ArrayList<LineRange>();
        for (int modelIndex = 0; modelIndex < hunks.size(); ++modelIndex) {
            int patchIndex = modelToPatchIndexes[modelIndex];
            PatchChangeBuilder.Hunk hunk = hunks.get(patchIndex);
            LineRange resultRange = hunk.getAppliedToLines();
            ApplyPatchChange change = new ApplyPatchChange(hunk, modelIndex, this);
            this.myModelChanges.add(change);
            if (resultRange != null) {
                this.myResultChanges.add(change);
            }
            modelRanges.add(resultRange != null ? resultRange : new LineRange(-1, -1));
        }
        this.myModel.setChanges(modelRanges);
        for (int index : patchToModelIndexes) {
            this.myPatchChanges.add(this.myModelChanges.get(index));
        }
        this.myFoldingModel.install(this.myResultChanges, this.getFoldingModelSettings());
        Object modelIndex = this.myModelChanges.iterator();
        while (modelIndex.hasNext()) {
            ApplyPatchChange change = (ApplyPatchChange)modelIndex.next();
            change.reinstallHighlighters();
        }
        this.myStatusPanel.update();
        this.myContentPanel.setPainter(new MyDividerPainter());
        VisibleAreaListener areaListener = e -> this.myContentPanel.repaint();
        this.myResultEditor.getScrollingModel().addVisibleAreaListener(areaListener);
        this.myPatchEditor.getScrollingModel().addVisibleAreaListener(areaListener);
        this.myPatchEditor.getGutterComponentEx().revalidateMarkup();
        if (this.myResultChanges.size() > 0) {
            this.scrollToChange(this.myResultChanges.get(0), Side.LEFT, true);
        }
    }

    public void scrollToChange(@NotNull ApplyPatchChange change, @NotNull Side masterSide, boolean forceScroll) {
        if (change == null) {
            ApplyPatchViewer.$$$reportNull$$$0(14);
        }
        if (masterSide == null) {
            ApplyPatchViewer.$$$reportNull$$$0(15);
        }
        if (change.getResultRange() == null) {
            DiffUtil.moveCaret(this.myPatchEditor, change.getPatchRange().start);
            this.myPatchEditor.getScrollingModel().scrollToCaret(forceScroll ? ScrollType.CENTER : ScrollType.MAKE_VISIBLE);
        } else {
            LineRange resultRange = change.getResultRange();
            LineRange patchRange = change.getPatchAffectedRange();
            int topShift = -1;
            if (!forceScroll) {
                int masterLine = masterSide.select(resultRange.start, patchRange.start);
                EditorEx masterEditor = (EditorEx)masterSide.select((Object)this.myResultEditor, (Object)this.myPatchEditor);
                int targetY = masterEditor.logicalPositionToXY((LogicalPosition)new LogicalPosition((int)masterLine, (int)0)).y;
                int scrollOffset = masterEditor.getScrollingModel().getVerticalScrollOffset();
                topShift = targetY - scrollOffset;
            }
            int[] offsets = SyncScrollSupport.getTargetOffsets(this.myResultEditor, this.myPatchEditor, resultRange.start, resultRange.end, patchRange.start, patchRange.end, topShift);
            DiffUtil.moveCaret(this.myResultEditor, resultRange.start);
            DiffUtil.moveCaret(this.myPatchEditor, patchRange.start);
            DiffUtil.scrollToPoint(this.myResultEditor, new Point(0, offsets[0]), false);
            DiffUtil.scrollToPoint(this.myPatchEditor, new Point(0, offsets[1]), false);
        }
    }

    public void repaintDivider() {
        this.myContentPanel.repaintDivider();
    }

    public boolean executeCommand(@Nullable String commandName, @NotNull Runnable task) {
        if (task == null) {
            ApplyPatchViewer.$$$reportNull$$$0(16);
        }
        return this.myModel.executeMergeCommand(commandName, null, UndoConfirmationPolicy.DEFAULT, false, null, task);
    }

    protected void onChangeResolved() {
        if (this.isDisposed()) {
            return;
        }
        this.myStatusPanel.update();
    }

    public void markChangeResolved(@NotNull ApplyPatchChange change) {
        if (change == null) {
            ApplyPatchViewer.$$$reportNull$$$0(17);
        }
        if (change.isResolved()) {
            return;
        }
        change.setResolved(true);
        this.myModel.invalidateHighlighters(change.getIndex());
        this.onChangeResolved();
    }

    public void replaceChange(@NotNull ApplyPatchChange change) {
        if (change == null) {
            ApplyPatchViewer.$$$reportNull$$$0(18);
        }
        LineRange resultRange = change.getResultRange();
        LineRange patchRange = change.getPatchInsertionRange();
        if (resultRange == null || change.isResolved()) {
            return;
        }
        if (change.getStatus() != AppliedTextPatch.HunkStatus.EXACTLY_APPLIED) {
            return;
        }
        List<String> newContent = DiffUtil.getLines(this.myPatchEditor.getDocument(), patchRange.start, patchRange.end);
        this.myModel.replaceChange(change.getIndex(), newContent);
        this.markChangeResolved(change);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/changes/patch/tool/ApplyPatchViewer";
                break;
            }
            case 14: 
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "change";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "masterSide";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/changes/patch/tool/ApplyPatchViewer";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createToolbarActions";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditorPopupActions";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getModel";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getModelChanges";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getStatusPanel";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getResultEditor";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getPatchEditor";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrentSide";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getPatchChanges";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getTextSettings";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getFoldingModelSettings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "scrollToChange";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "executeCommand";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "markChangeResolved";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "replaceChange";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class MyStatusPanel
    extends StatusPanel {
        private MyStatusPanel() {
        }

        @Override
        @Nullable
        protected String getMessage() {
            int totalUnresolved = 0;
            int alreadyApplied = 0;
            int notApplied = 0;
            for (ApplyPatchChange change : ApplyPatchViewer.this.myPatchChanges) {
                if (change.isResolved()) continue;
                ++totalUnresolved;
                switch (change.getStatus()) {
                    case ALREADY_APPLIED: {
                        ++alreadyApplied;
                        break;
                    }
                    case NOT_APPLIED: {
                        ++notApplied;
                        break;
                    }
                }
            }
            if (totalUnresolved == 0) {
                return DiffBundle.message((String)"apply.somehow.status.message.all.applied", (Object[])new Object[]{notApplied});
            }
            if (totalUnresolved == notApplied) {
                return DiffBundle.message((String)"apply.somehow.status.message.cant.apply", (Object[])new Object[]{notApplied});
            }
            String message = DiffBundle.message((String)"apply.somehow.status.message.cant.apply.some", (Object[])new Object[]{notApplied, totalUnresolved});
            if (alreadyApplied == 0) {
                return message;
            }
            return message + ". " + DiffBundle.message((String)"apply.somehow.status.message.already.applied", (Object[])new Object[]{alreadyApplied});
        }
    }

    private static class MyFoldingModel
    extends FoldingModelSupport {
        public MyFoldingModel(@NotNull EditorEx editor, @NotNull Disposable disposable) {
            if (editor == null) {
                MyFoldingModel.$$$reportNull$$$0(0);
            }
            if (disposable == null) {
                MyFoldingModel.$$$reportNull$$$0(1);
            }
            super(new EditorEx[]{editor}, disposable);
        }

        /*
         * Exception decompiling
         */
        public void install(@Nullable List<ApplyPatchChange> changes, @NotNull FoldingModelSupport.Settings settings) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * java.lang.UnsupportedOperationException
             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.applyExpressionRewriterToArgs(StaticFunctionInvokation.java:103)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.applyExpressionRewriter(StaticFunctionInvokation.java:90)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
             *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredAssignment.rewriteExpressions(StructuredAssignment.java:146)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "disposable";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "settings";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/vcs/changes/patch/tool/ApplyPatchViewer$MyFoldingModel";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "install";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class MyDividerPainter
    implements DiffSplitter.Painter,
    DiffDividerDrawUtil.DividerPaintable {
        private MyDividerPainter() {
        }

        @Override
        public void paint(@NotNull Graphics g, @NotNull JComponent divider) {
            if (g == null) {
                MyDividerPainter.$$$reportNull$$$0(0);
            }
            if (divider == null) {
                MyDividerPainter.$$$reportNull$$$0(1);
            }
            Graphics2D gg = DiffDividerDrawUtil.getDividerGraphics(g, divider, ApplyPatchViewer.this.myPatchEditor.getComponent());
            gg.setColor(DiffDrawUtil.getDividerColor(ApplyPatchViewer.this.myPatchEditor));
            gg.fill(gg.getClipBounds());
            DiffDividerDrawUtil.paintPolygons(gg, divider.getWidth(), ApplyPatchViewer.this.myResultEditor, ApplyPatchViewer.this.myPatchEditor, this);
            gg.dispose();
        }

        @Override
        public void process(@NotNull DiffDividerDrawUtil.DividerPaintable.Handler handler2) {
            if (handler2 == null) {
                MyDividerPainter.$$$reportNull$$$0(2);
            }
            for (ApplyPatchChange change : ApplyPatchViewer.this.myResultChanges) {
                LineRange resultRange = change.getResultRange();
                LineRange patchRange = change.getPatchRange();
                assert (resultRange != null);
                Color color = change.getDiffType().getColor(ApplyPatchViewer.this.myPatchEditor);
                handler2.process(resultRange.start, resultRange.end, patchRange.start, patchRange.end, color, change.isResolved());
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "g";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "divider";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "handler";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/vcs/changes/patch/tool/ApplyPatchViewer$MyDividerPainter";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "paint";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "process";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class MyPrevNextDifferenceIterable
    extends PrevNextDifferenceIterableBase<ApplyPatchChange> {
        private MyPrevNextDifferenceIterable() {
        }

        @Override
        @NotNull
        protected List<ApplyPatchChange> getChanges() {
            List list2 = (List)ApplyPatchViewer.this.getCurrentSide().select((Object)ApplyPatchViewer.this.myResultChanges, (Object)ApplyPatchViewer.this.myPatchChanges);
            if (list2 == null) {
                MyPrevNextDifferenceIterable.$$$reportNull$$$0(0);
            }
            return list2;
        }

        @Override
        @NotNull
        protected EditorEx getEditor() {
            EditorEx editorEx = (EditorEx)ApplyPatchViewer.this.getCurrentSide().select((Object)ApplyPatchViewer.this.myResultEditor, (Object)ApplyPatchViewer.this.myPatchEditor);
            if (editorEx == null) {
                MyPrevNextDifferenceIterable.$$$reportNull$$$0(1);
            }
            return editorEx;
        }

        @Override
        protected int getStartLine(@NotNull ApplyPatchChange change) {
            if (change == null) {
                MyPrevNextDifferenceIterable.$$$reportNull$$$0(2);
            }
            return ((LineRange)ApplyPatchViewer.this.getCurrentSide().select((Object)change.getResultRange(), (Object)change.getPatchAffectedRange())).start;
        }

        @Override
        protected int getEndLine(@NotNull ApplyPatchChange change) {
            if (change == null) {
                MyPrevNextDifferenceIterable.$$$reportNull$$$0(3);
            }
            return ((LineRange)ApplyPatchViewer.this.getCurrentSide().select((Object)change.getResultRange(), (Object)change.getPatchAffectedRange())).end;
        }

        @Override
        protected void scrollToChange(@NotNull ApplyPatchChange change) {
            if (change == null) {
                MyPrevNextDifferenceIterable.$$$reportNull$$$0(4);
            }
            ApplyPatchViewer.this.scrollToChange(change, ApplyPatchViewer.this.getCurrentSide(), true);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vcs/changes/patch/tool/ApplyPatchViewer$MyPrevNextDifferenceIterable";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "change";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChanges";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getEditor";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vcs/changes/patch/tool/ApplyPatchViewer$MyPrevNextDifferenceIterable";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getStartLine";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getEndLine";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "scrollToChange";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private class ShowDiffWithLocalAction
    extends DumbAwareAction {
        public ShowDiffWithLocalAction() {
            super("Compare with local content", null, AllIcons.Actions.Diff);
        }

        public void actionPerformed(AnActionEvent e) {
            DocumentContent resultContent = ApplyPatchViewer.this.myPatchRequest.getResultContent();
            DocumentContent localContent = DiffContentFactory.getInstance().create(ApplyPatchViewer.this.myProject, ApplyPatchViewer.this.myPatchRequest.getLocalContent(), resultContent);
            SimpleDiffRequest request = new SimpleDiffRequest(ApplyPatchViewer.this.myPatchRequest.getTitle(), (DiffContent)localContent, (DiffContent)resultContent, ApplyPatchViewer.this.myPatchRequest.getLocalTitle(), ApplyPatchViewer.this.myPatchRequest.getResultTitle());
            LogicalPosition currentPosition = DiffUtil.getCaretPosition(ApplyPatchViewer.this.myResultEditor);
            request.putUserData(DiffUserDataKeys.SCROLL_TO_LINE, (Object)Pair.create((Object)Side.RIGHT, (Object)currentPosition.line));
            DiffManager.getInstance().showDiff(ApplyPatchViewer.this.myProject, (DiffRequest)request, new DiffDialogHints(null, (Component)ApplyPatchViewer.this.myPanel));
        }
    }

    private class MyToggleExpandByDefaultAction
    extends TextDiffViewerUtil.ToggleExpandByDefaultAction {
        public MyToggleExpandByDefaultAction() {
            super(ApplyPatchViewer.this.getTextSettings());
        }

        @Override
        protected void expandAll(boolean expand) {
            ApplyPatchViewer.this.myFoldingModel.expandAll(expand);
        }
    }

    private class MyFocusOppositePaneAction
    extends FocusOppositePaneAction {
        public MyFocusOppositePaneAction() {
            super(false);
        }

        @Override
        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                MyFocusOppositePaneAction.$$$reportNull$$$0(0);
            }
            EditorEx targetEditor = (EditorEx)ApplyPatchViewer.this.getCurrentSide().other().select((Object)ApplyPatchViewer.this.myResultEditor, (Object)ApplyPatchViewer.this.myPatchEditor);
            DiffUtil.requestFocus(ApplyPatchViewer.this.myProject, targetEditor.getContentComponent());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/vcs/changes/patch/tool/ApplyPatchViewer$MyFocusOppositePaneAction", "actionPerformed"));
        }
    }

    private class ApplyNonConflictsAction
    extends DumbAwareAction {
        public ApplyNonConflictsAction() {
            ActionUtil.copyFrom((AnAction)this, (String)"Diff.ApplyNonConflicts");
        }

        public void update(AnActionEvent e) {
            boolean enabled = ContainerUtil.exists((Iterable)ApplyPatchViewer.this.myModelChanges, c -> {
                if (c.isResolved()) {
                    return false;
                }
                return c.getStatus() != AppliedTextPatch.HunkStatus.NOT_APPLIED;
            });
            e.getPresentation().setEnabled(enabled);
        }

        public void actionPerformed(AnActionEvent e) {
            List changes = ApplyPatchViewer.this.myModelChanges;
            if (changes.isEmpty()) {
                return;
            }
            ApplyPatchViewer.this.executeCommand("Apply Non Conflicted Changes", () -> {
                block4: for (int i = changes.size() - 1; i >= 0; --i) {
                    ApplyPatchChange change = (ApplyPatchChange)changes.get(i);
                    switch (change.getStatus()) {
                        case ALREADY_APPLIED: {
                            ApplyPatchViewer.this.markChangeResolved(change);
                            continue block4;
                        }
                        case EXACTLY_APPLIED: {
                            ApplyPatchViewer.this.replaceChange(change);
                            continue block4;
                        }
                    }
                }
            });
        }
    }

    private abstract class ApplySelectedChangesActionBase
    extends DumbAwareAction {
        private final boolean myShortcut;

        public ApplySelectedChangesActionBase(boolean shortcut) {
            this.myShortcut = shortcut;
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                ApplySelectedChangesActionBase.$$$reportNull$$$0(0);
            }
            if (this.myShortcut) {
                e.getPresentation().setEnabledAndVisible(true);
                return;
            }
            Presentation presentation = e.getPresentation();
            Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
            Side side = Side.fromValue((List)ContainerUtil.list((Object[])new EditorEx[]{ApplyPatchViewer.this.myResultEditor, ApplyPatchViewer.this.myPatchEditor}), (Object)editor);
            if (side == null) {
                presentation.setEnabledAndVisible(false);
                return;
            }
            presentation.setVisible(true);
            presentation.setEnabled(this.isSomeChangeSelected(side));
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                ApplySelectedChangesActionBase.$$$reportNull$$$0(1);
            }
            Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
            Side side = Side.fromValue((List)ContainerUtil.list((Object[])new EditorEx[]{ApplyPatchViewer.this.myResultEditor, ApplyPatchViewer.this.myPatchEditor}), (Object)editor);
            if (editor == null || side == null) {
                return;
            }
            List<ApplyPatchChange> selectedChanges = this.getSelectedChanges(side);
            if (selectedChanges.isEmpty()) {
                return;
            }
            String title = e.getPresentation().getText() + " in patch resolve";
            ApplyPatchViewer.this.executeCommand(title, () -> this.apply(selectedChanges));
        }

        private boolean isSomeChangeSelected(@NotNull Side side) {
            EditorEx editor;
            List carets;
            if (side == null) {
                ApplySelectedChangesActionBase.$$$reportNull$$$0(2);
            }
            if ((carets = (editor = (EditorEx)side.select((Object)ApplyPatchViewer.this.myResultEditor, (Object)ApplyPatchViewer.this.myPatchEditor)).getCaretModel().getAllCarets()).size() != 1) {
                return true;
            }
            Caret caret = (Caret)carets.get(0);
            if (caret.hasSelection()) {
                return true;
            }
            int line = editor.getDocument().getLineNumber(editor.getExpectedCaretOffset());
            List changes = ApplyPatchViewer.this.myModelChanges;
            for (ApplyPatchChange change : changes) {
                LineRange range2;
                if (!this.isEnabled(change) || (range2 = (LineRange)side.select((Object)change.getResultRange(), (Object)change.getPatchRange())) == null || !DiffUtil.isSelectedByLine(line, range2.start, range2.end)) continue;
                return true;
            }
            return false;
        }

        @NotNull
        private List<ApplyPatchChange> getSelectedChanges(@NotNull Side side) {
            if (side == null) {
                ApplySelectedChangesActionBase.$$$reportNull$$$0(3);
            }
            BitSet lines2 = DiffUtil.getSelectedLines((Editor)side.select((Object)ApplyPatchViewer.this.myResultEditor, (Object)ApplyPatchViewer.this.myPatchEditor));
            ArrayList<ApplyPatchChange> affectedChanges = new ArrayList<ApplyPatchChange>();
            for (ApplyPatchChange change : ApplyPatchViewer.this.myModelChanges) {
                LineRange range2;
                if (!this.isEnabled(change) || (range2 = (LineRange)side.select((Object)change.getResultRange(), (Object)change.getPatchRange())) == null || !DiffUtil.isSelectedByLine(lines2, range2.start, range2.end)) continue;
                affectedChanges.add(change);
            }
            ArrayList<ApplyPatchChange> arrayList = affectedChanges;
            if (arrayList == null) {
                ApplySelectedChangesActionBase.$$$reportNull$$$0(4);
            }
            return arrayList;
        }

        protected abstract boolean isEnabled(@NotNull ApplyPatchChange var1);

        protected abstract void apply(@NotNull List<ApplyPatchChange> var1);

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "side";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vcs/changes/patch/tool/ApplyPatchViewer$ApplySelectedChangesActionBase";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vcs/changes/patch/tool/ApplyPatchViewer$ApplySelectedChangesActionBase";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSelectedChanges";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "isSomeChangeSelected";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getSelectedChanges";
                    break;
                }
                case 4: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private class IgnoreSelectedChangesAction
    extends ApplySelectedChangesActionBase {
        private IgnoreSelectedChangesAction(boolean shortcut) {
            super(shortcut);
            this.getTemplatePresentation().setText("Ignore");
            this.getTemplatePresentation().setIcon(AllIcons.Diff.Remove);
            this.setShortcutSet((ShortcutSet)new CompositeShortcutSet(new ShortcutSet[]{ActionManager.getInstance().getAction("Diff.IgnoreRightSide").getShortcutSet(), ActionManager.getInstance().getAction("Diff.ApplyLeftSide").getShortcutSet()}));
        }

        @Override
        protected boolean isEnabled(@NotNull ApplyPatchChange change) {
            if (change == null) {
                IgnoreSelectedChangesAction.$$$reportNull$$$0(0);
            }
            return !change.isResolved();
        }

        @Override
        protected void apply(@NotNull List<ApplyPatchChange> changes) {
            if (changes == null) {
                IgnoreSelectedChangesAction.$$$reportNull$$$0(1);
            }
            for (ApplyPatchChange change : changes) {
                ApplyPatchViewer.this.markChangeResolved(change);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "change";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "changes";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/vcs/changes/patch/tool/ApplyPatchViewer$IgnoreSelectedChangesAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isEnabled";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "apply";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class ApplySelectedChangesAction
    extends ApplySelectedChangesActionBase {
        private ApplySelectedChangesAction(boolean shortcut) {
            super(shortcut);
            this.getTemplatePresentation().setText("Accept");
            this.getTemplatePresentation().setIcon(AllIcons.Actions.Checked);
            this.copyShortcutFrom(ActionManager.getInstance().getAction("Diff.ApplyRightSide"));
        }

        @Override
        protected boolean isEnabled(@NotNull ApplyPatchChange change) {
            if (change == null) {
                ApplySelectedChangesAction.$$$reportNull$$$0(0);
            }
            return !change.isResolved() && change.getStatus() == AppliedTextPatch.HunkStatus.EXACTLY_APPLIED;
        }

        @Override
        protected void apply(@NotNull List<ApplyPatchChange> changes) {
            if (changes == null) {
                ApplySelectedChangesAction.$$$reportNull$$$0(1);
            }
            for (int i = changes.size() - 1; i >= 0; --i) {
                ApplyPatchViewer.this.replaceChange(changes.get(i));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "change";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "changes";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/vcs/changes/patch/tool/ApplyPatchViewer$ApplySelectedChangesAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isEnabled";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "apply";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    class MyModel
    extends MergeModelBase<ApplyPatchChange.State> {
        public MyModel(@NotNull Project project, Document document) {
            if (document == null) {
                MyModel.$$$reportNull$$$0(0);
            }
            super(project, document);
        }

        @Override
        protected void reinstallHighlighters(int index) {
            ApplyPatchChange change = (ApplyPatchChange)ApplyPatchViewer.this.myModelChanges.get(index);
            change.reinstallHighlighters();
        }

        @Override
        @NotNull
        protected ApplyPatchChange.State storeChangeState(int index) {
            ApplyPatchChange change = (ApplyPatchChange)ApplyPatchViewer.this.myModelChanges.get(index);
            ApplyPatchChange.State state = change.storeState();
            if (state == null) {
                MyModel.$$$reportNull$$$0(1);
            }
            return state;
        }

        @Override
        protected void restoreChangeState(@NotNull ApplyPatchChange.State state) {
            if (state == null) {
                MyModel.$$$reportNull$$$0(2);
            }
            super.restoreChangeState(state);
            ApplyPatchChange change = (ApplyPatchChange)ApplyPatchViewer.this.myModelChanges.get(state.myIndex);
            boolean wasResolved = change.isResolved();
            change.restoreState(state);
            if (wasResolved != change.isResolved()) {
                ApplyPatchViewer.this.onChangeResolved();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "document";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vcs/changes/patch/tool/ApplyPatchViewer$MyModel";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "state";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vcs/changes/patch/tool/ApplyPatchViewer$MyModel";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "storeChangeState";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "restoreChangeState";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

