/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.ex;

import com.intellij.diff.comparison.TrimUtil;
import com.intellij.diff.tools.util.text.LineOffsets;
import com.intellij.diff.util.DiffUtil;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vcs.ex.DocumentTracker;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0002J=\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\n0\u000f2'\u0010\u0010\u001a#\u0012\u0019\u0012\u0017\u0012\u0004\u0012\u00020\n0\u000f\u00a2\u0006\f\b\u0012\u0012\b\b\u0013\u0012\u0004\b\b(\u0014\u0012\u0004\u0012\u00020\r0\u0011R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/intellij/openapi/vcs/ex/BlockGroupsProcessor;", "", "text1", "", "lineOffsets1", "Lcom/intellij/diff/tools/util/text/LineOffsets;", "(Ljava/lang/CharSequence;Lcom/intellij/diff/tools/util/text/LineOffsets;)V", "isWhitespaceOnlySeparated", "", "block1", "Lcom/intellij/openapi/vcs/ex/DocumentTracker$Block;", "block2", "processMergeableGroups", "", "blocks", "", "processGroup", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "group", "diff-impl"})
final class BlockGroupsProcessor {
    private final CharSequence text1;
    private final LineOffsets lineOffsets1;

    public final void processMergeableGroups(@NotNull List<DocumentTracker.Block> blocks, @NotNull Function1<? super List<DocumentTracker.Block>, Unit> processGroup) {
        int i;
        Intrinsics.checkParameterIsNotNull(blocks, (String)"blocks");
        Intrinsics.checkParameterIsNotNull(processGroup, (String)"processGroup");
        if (blocks.isEmpty()) {
            return;
        }
        int blockStart = 0;
        for (i = 0; i < blocks.size() - 1; ++i) {
            if (this.isWhitespaceOnlySeparated(blocks.get(i), blocks.get(i + 1))) continue;
            processGroup.invoke(blocks.subList(blockStart, i + 1));
            blockStart = i + 1;
        }
        processGroup.invoke(blocks.subList(blockStart, i + 1));
    }

    private final boolean isWhitespaceOnlySeparated(DocumentTracker.Block block1, DocumentTracker.Block block2) {
        int end;
        TextRange range1 = DiffUtil.getLinesRange(this.lineOffsets1, block1.getRange().start1, block1.getRange().end1, false);
        TextRange range2 = DiffUtil.getLinesRange(this.lineOffsets1, block2.getRange().start1, block2.getRange().end1, false);
        int start = range1.getEndOffset();
        return TrimUtil.trimStart(this.text1, start, end = range2.getStartOffset()) == end;
    }

    public BlockGroupsProcessor(@NotNull CharSequence text1, @NotNull LineOffsets lineOffsets1) {
        Intrinsics.checkParameterIsNotNull((Object)text1, (String)"text1");
        Intrinsics.checkParameterIsNotNull((Object)lineOffsets1, (String)"lineOffsets1");
        this.text1 = text1;
        this.lineOffsets1 = lineOffsets1;
    }
}

