/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packageDependencies.ui;

import com.intellij.CommonBundle;
import com.intellij.analysis.AnalysisScope;
import com.intellij.analysis.AnalysisScopeBundle;
import com.intellij.analysis.PerformAnalysisInBackgroundOption;
import com.intellij.codeInsight.hint.HintUtil;
import com.intellij.icons.AllIcons;
import com.intellij.ide.CommonActionsManager;
import com.intellij.ide.ExporterToTextFile;
import com.intellij.ide.impl.FlattenModulesToggleAction;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.actionSystem.ex.ComboBoxAction;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.PathMacroManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.packageDependencies.BackwardDependenciesBuilder;
import com.intellij.packageDependencies.DependenciesBuilder;
import com.intellij.packageDependencies.DependenciesToolWindow;
import com.intellij.packageDependencies.DependencyRule;
import com.intellij.packageDependencies.DependencyUISettings;
import com.intellij.packageDependencies.DependencyValidationManager;
import com.intellij.packageDependencies.ForwardDependenciesBuilder;
import com.intellij.packageDependencies.actions.AnalyzeDependenciesHandler;
import com.intellij.packageDependencies.actions.BackwardDependenciesHandler;
import com.intellij.packageDependencies.ui.DependenciesUsagesPanel;
import com.intellij.packageDependencies.ui.DependencyConfigurable;
import com.intellij.packageDependencies.ui.FileNode;
import com.intellij.packageDependencies.ui.FileTreeModelBuilder;
import com.intellij.packageDependencies.ui.Marker;
import com.intellij.packageDependencies.ui.PackageDependenciesNode;
import com.intellij.packageDependencies.ui.PackageTreeExpansionMonitor;
import com.intellij.packageDependencies.ui.PatternDialectProvider;
import com.intellij.packageDependencies.ui.TreeExpansionMonitor;
import com.intellij.packageDependencies.ui.TreeModel;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.scope.packageSet.NamedScope;
import com.intellij.psi.search.scope.packageSet.PackageSet;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.JBColor;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.SmartExpander;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.content.Content;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.usageView.UsageViewBundle;
import com.intellij.util.EditSourceOnDoubleClickHandler;
import com.intellij.util.PlatformIcons;
import com.intellij.util.Processor;
import com.intellij.util.SystemProperties;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.TreeUtil;
import com.intellij.xml.util.XmlStringUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jdom.Document;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DependenciesPanel
extends JPanel
implements Disposable,
DataProvider {
    private final Map<PsiFile, Set<PsiFile>> myDependencies;
    private Map<VirtualFile, Map<DependencyRule, Set<PsiFile>>> myIllegalDependencies;
    private final MyTree myLeftTree = new MyTree();
    private final MyTree myRightTree = new MyTree();
    private final DependenciesUsagesPanel myUsagesPanel;
    private static final HashSet<PsiFile> EMPTY_FILE_SET = new HashSet(0);
    private final TreeExpansionMonitor myRightTreeExpansionMonitor;
    private final TreeExpansionMonitor myLeftTreeExpansionMonitor;
    private final Marker myRightTreeMarker;
    private final Marker myLeftTreeMarker;
    private Set<VirtualFile> myIllegalsInRightTree = new HashSet<VirtualFile>();
    private final Project myProject;
    private final List<DependenciesBuilder> myBuilders;
    private final Set<PsiFile> myExcluded;
    private Content myContent;
    private final DependencyPanelSettings mySettings = new DependencyPanelSettings();
    private static final Logger LOG = Logger.getInstance(DependenciesPanel.class);
    private final boolean myForward;
    private final AnalysisScope myScopeOfInterest;
    private final int myTransitiveBorder;

    public DependenciesPanel(Project project, DependenciesBuilder builder) {
        this(project, Collections.singletonList(builder), new HashSet<PsiFile>());
    }

    public DependenciesPanel(Project project, List<DependenciesBuilder> builders, Set<PsiFile> excluded) {
        super(new BorderLayout());
        Set<PsiFile> oneFileSet;
        AnalysisScope scope;
        this.myBuilders = builders;
        this.myExcluded = excluded;
        DependenciesBuilder main = this.myBuilders.get(0);
        this.myForward = !main.isBackward();
        this.myScopeOfInterest = main.getScopeOfInterest();
        this.myTransitiveBorder = main.getTransitiveBorder();
        this.myDependencies = new HashMap<PsiFile, Set<PsiFile>>();
        this.myIllegalDependencies = new HashMap<VirtualFile, Map<DependencyRule, Set<PsiFile>>>();
        for (DependenciesBuilder builder : builders) {
            this.myDependencies.putAll(builder.getDependencies());
            this.putAllDependencies(builder);
        }
        this.exclude(excluded);
        this.myProject = project;
        this.myUsagesPanel = new DependenciesUsagesPanel(this.myProject, this.myBuilders);
        Disposer.register((Disposable)this, (Disposable)this.myUsagesPanel);
        final Splitter treeSplitter = new Splitter();
        Disposer.register((Disposable)this, (Disposable)new Disposable(){

            public void dispose() {
                treeSplitter.dispose();
            }
        });
        treeSplitter.setFirstComponent((JComponent)ScrollPaneFactory.createScrollPane((Component)((Object)this.myLeftTree)));
        treeSplitter.setSecondComponent((JComponent)ScrollPaneFactory.createScrollPane((Component)((Object)this.myRightTree)));
        final Splitter splitter = new Splitter(true);
        Disposer.register((Disposable)this, (Disposable)new Disposable(){

            public void dispose() {
                splitter.dispose();
            }
        });
        splitter.setFirstComponent((JComponent)treeSplitter);
        splitter.setSecondComponent((JComponent)this.myUsagesPanel);
        this.add((Component)splitter, "Center");
        this.add((Component)this.createToolbar(), "North");
        this.myRightTreeExpansionMonitor = PackageTreeExpansionMonitor.install((JTree)((Object)this.myRightTree), this.myProject);
        this.myLeftTreeExpansionMonitor = PackageTreeExpansionMonitor.install((JTree)((Object)this.myLeftTree), this.myProject);
        this.myRightTreeMarker = new Marker(){

            @Override
            public boolean isMarked(VirtualFile file2) {
                return DependenciesPanel.this.myIllegalsInRightTree.contains(file2);
            }
        };
        this.myLeftTreeMarker = new Marker(){

            @Override
            public boolean isMarked(VirtualFile file2) {
                return DependenciesPanel.this.myIllegalDependencies.containsKey(file2);
            }
        };
        this.updateLeftTreeModel();
        this.updateRightTreeModel();
        this.myLeftTree.getSelectionModel().addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                DependenciesPanel.this.updateRightTreeModel();
                StringBuffer denyRules = new StringBuffer();
                StringBuffer allowRules = new StringBuffer();
                TreePath[] paths = DependenciesPanel.this.myLeftTree.getSelectionPaths();
                if (paths == null) {
                    return;
                }
                for (TreePath path : paths) {
                    PackageDependenciesNode selectedNode = (PackageDependenciesNode)path.getLastPathComponent();
                    DependenciesPanel.this.traverseToLeaves(selectedNode, denyRules, allowRules);
                }
                if (denyRules.length() + allowRules.length() > 0) {
                    StatusBar.Info.set((String)AnalysisScopeBundle.message((String)"status.bar.rule.violation.message", (Object[])new Object[]{denyRules.length() == 0 || allowRules.length() == 0 ? 1 : 2, (denyRules.length() > 0 ? denyRules.toString() + (allowRules.length() > 0 ? "; " : "") : " ") + (allowRules.length() > 0 ? allowRules.toString() : " ")}), (Project)DependenciesPanel.this.myProject);
                } else {
                    StatusBar.Info.set((String)AnalysisScopeBundle.message((String)"status.bar.no.rule.violation.message", (Object[])new Object[0]), (Project)DependenciesPanel.this.myProject);
                }
            }
        });
        this.myRightTree.getSelectionModel().addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                SwingUtilities.invokeLater(() -> {
                    Set searchIn = DependenciesPanel.this.getSelectedScope(DependenciesPanel.this.myLeftTree);
                    Set searchFor = DependenciesPanel.this.getSelectedScope(DependenciesPanel.this.myRightTree);
                    if (searchIn.isEmpty() || searchFor.isEmpty()) {
                        DependenciesPanel.this.myUsagesPanel.setToInitialPosition();
                        DependenciesPanel.this.processDependencies(searchIn, searchFor, (Processor<List<PsiFile>>)path -> {
                            searchFor.add(path.get(1));
                            return true;
                        });
                    } else {
                        DependenciesPanel.this.myUsagesPanel.findUsages(searchIn, searchFor);
                    }
                });
            }
        });
        this.initTree(this.myLeftTree, false);
        this.initTree(this.myRightTree, true);
        this.setEmptyText(this.mySettings.UI_FILTER_LEGALS);
        if (builders.size() == 1 && (scope = builders.get(0).getScope()).getScopeType() == 3 && (oneFileSet = this.myDependencies.keySet()).size() == 1) {
            this.selectElementInLeftTree((PsiElement)oneFileSet.iterator().next());
            return;
        }
        TreeUtil.selectFirstNode((JTree)((Object)this.myLeftTree));
    }

    private void putAllDependencies(DependenciesBuilder builder) {
        Map<PsiFile, Map<DependencyRule, Set<PsiFile>>> dependencies = builder.getIllegalDependencies();
        for (Map.Entry<PsiFile, Map<DependencyRule, Set<PsiFile>>> entry : dependencies.entrySet()) {
            this.myIllegalDependencies.put(entry.getKey().getVirtualFile(), entry.getValue());
        }
    }

    private void processDependencies(Set<PsiFile> searchIn, Set<PsiFile> searchFor, Processor<List<PsiFile>> processor2) {
        if (this.myTransitiveBorder == 0) {
            return;
        }
        HashSet<PsiFile> initialSearchFor = new HashSet<PsiFile>(searchFor);
        for (DependenciesBuilder builder : this.myBuilders) {
            for (PsiFile from : searchIn) {
                for (PsiFile to : initialSearchFor) {
                    List<List<PsiFile>> paths = builder.findPaths(from, to);
                    Collections.sort(paths, (p1, p2) -> p1.size() - p2.size());
                    for (List<PsiFile> path : paths) {
                        if (path.isEmpty()) continue;
                        path.add(0, from);
                        path.add(to);
                        if (processor2.process(path)) continue;
                        return;
                    }
                }
            }
        }
    }

    private void exclude(Set<PsiFile> excluded) {
        for (PsiFile psiFile : excluded) {
            this.myDependencies.remove(psiFile);
            this.myIllegalDependencies.remove(psiFile);
        }
    }

    private void traverseToLeaves(PackageDependenciesNode treeNode, StringBuffer denyRules, StringBuffer allowRules) {
        Enumeration<TreeNode> enumeration = treeNode.breadthFirstEnumeration();
        while (enumeration.hasMoreElements()) {
            PsiElement childPsiElement = ((PackageDependenciesNode)enumeration.nextElement()).getPsiElement();
            if (!this.myIllegalDependencies.containsKey(childPsiElement)) continue;
            Map<DependencyRule, Set<PsiFile>> illegalDeps = this.myIllegalDependencies.get(childPsiElement);
            for (DependencyRule rule : illegalDeps.keySet()) {
                if (rule.isDenyRule()) {
                    if (denyRules.indexOf(rule.getDisplayText()) != -1) continue;
                    denyRules.append(rule.getDisplayText());
                    denyRules.append("\n");
                    continue;
                }
                if (allowRules.indexOf(rule.getDisplayText()) != -1) continue;
                allowRules.append(rule.getDisplayText());
                allowRules.append("\n");
            }
        }
    }

    private JComponent createToolbar() {
        DefaultActionGroup group = new DefaultActionGroup();
        group.add((AnAction)new CloseAction());
        group.add((AnAction)new RerunAction(this));
        group.add((AnAction)new FlattenPackagesAction());
        group.add((AnAction)new ShowFilesAction());
        if (ModuleManager.getInstance((Project)this.myProject).getModules().length > 1) {
            group.add((AnAction)new ShowModulesAction());
            group.add((AnAction)this.createFlattenModulesAction());
            if (ModuleManager.getInstance((Project)this.myProject).hasModuleGroups()) {
                group.add((AnAction)new ShowModuleGroupsAction());
            }
        }
        group.add((AnAction)new GroupByScopeTypeAction());
        group.add((AnAction)new FilterLegalsAction());
        group.add((AnAction)new MarkAsIllegalAction());
        group.add((AnAction)new ChooseScopeTypeAction());
        group.add((AnAction)new EditDependencyRulesAction());
        group.add(CommonActionsManager.getInstance().createExportToTextFileAction((ExporterToTextFile)new DependenciesExporterToTextFile()));
        ActionToolbar toolbar = ActionManager.getInstance().createActionToolbar("PackageDependencies", (ActionGroup)group, true);
        return toolbar.getComponent();
    }

    @NotNull
    private FlattenModulesToggleAction createFlattenModulesAction() {
        FlattenModulesToggleAction flattenModulesToggleAction = new FlattenModulesToggleAction(this.myProject, () -> this.mySettings.UI_SHOW_MODULES, () -> !this.mySettings.UI_SHOW_MODULE_GROUPS, value -> {
            DependencyUISettings.getInstance().UI_SHOW_MODULE_GROUPS = value == false;
            this.mySettings.UI_SHOW_MODULE_GROUPS = value == false;
            this.rebuild();
        });
        if (flattenModulesToggleAction == null) {
            DependenciesPanel.$$$reportNull$$$0(0);
        }
        return flattenModulesToggleAction;
    }

    private void rebuild() {
        this.myIllegalDependencies = new HashMap<VirtualFile, Map<DependencyRule, Set<PsiFile>>>();
        for (DependenciesBuilder builder : this.myBuilders) {
            this.putAllDependencies(builder);
        }
        this.updateLeftTreeModel();
        this.updateRightTreeModel();
    }

    private void initTree(MyTree tree, boolean isRightTree) {
        tree.setCellRenderer((TreeCellRenderer)((Object)new MyTreeCellRenderer()));
        tree.setRootVisible(false);
        tree.setShowsRootHandles(true);
        UIUtil.setLineStyleAngled((JTree)((Object)tree));
        TreeUtil.installActions((JTree)((Object)tree));
        SmartExpander.installOn((JTree)((Object)tree));
        EditSourceOnDoubleClickHandler.install((JTree)((Object)tree));
        new TreeSpeedSearch((JTree)((Object)tree));
        PopupHandler.installUnknownPopupHandler((JComponent)((Object)tree), (ActionGroup)this.createTreePopupActions(isRightTree), (ActionManager)ActionManager.getInstance());
    }

    private void updateRightTreeModel() {
        HashSet<PsiFile> deps = new HashSet<PsiFile>();
        Set<PsiFile> scope = this.getSelectedScope(this.myLeftTree);
        this.myIllegalsInRightTree = new HashSet<VirtualFile>();
        for (PsiFile psiFile : scope) {
            Set<PsiFile> psiFiles;
            Map<DependencyRule, Set<PsiFile>> illegalDeps = this.myIllegalDependencies.get(psiFile.getVirtualFile());
            if (illegalDeps != null) {
                for (DependencyRule rule : illegalDeps.keySet()) {
                    Set<PsiFile> files = illegalDeps.get(rule);
                    for (PsiFile file2 : files) {
                        this.myIllegalsInRightTree.add(file2.getVirtualFile());
                    }
                }
            }
            if ((psiFiles = this.myDependencies.get(psiFile)) == null) continue;
            for (PsiFile file3 : psiFiles) {
                if (file3 == null || !file3.isValid()) continue;
                deps.add(file3);
            }
        }
        deps.removeAll(scope);
        this.myRightTreeExpansionMonitor.freeze();
        this.myRightTree.setModel(this.buildTreeModel(deps, this.myRightTreeMarker));
        this.myRightTreeExpansionMonitor.restore();
        DependenciesPanel.expandFirstLevel(this.myRightTree);
    }

    private ActionGroup createTreePopupActions(boolean isRightTree) {
        DefaultActionGroup group = new DefaultActionGroup();
        ActionManager actionManager = ActionManager.getInstance();
        group.add(actionManager.getAction("EditSource"));
        group.add(actionManager.getAction("VersionControlsGroup"));
        if (isRightTree) {
            group.add(actionManager.getAction("AnalyzeMenu"));
            group.add((AnAction)new AddToScopeAction());
            group.add((AnAction)new SelectInLeftTreeAction());
            group.add((AnAction)new ShowDetailedInformationAction());
        } else {
            group.add((AnAction)new RemoveFromScopeAction());
        }
        return group;
    }

    private TreeModel buildTreeModel(Set<PsiFile> deps, Marker marker) {
        return PatternDialectProvider.getInstance(this.mySettings.SCOPE_TYPE).createTreeModel(this.myProject, deps, marker, this.mySettings);
    }

    private void updateLeftTreeModel() {
        Set<PsiFile> psiFiles = this.myDependencies.keySet();
        this.myLeftTreeExpansionMonitor.freeze();
        this.myLeftTree.setModel(this.buildTreeModel(psiFiles, this.myLeftTreeMarker));
        this.myLeftTreeExpansionMonitor.restore();
        DependenciesPanel.expandFirstLevel(this.myLeftTree);
    }

    private static void expandFirstLevel(Tree tree) {
        PackageDependenciesNode root = (PackageDependenciesNode)tree.getModel().getRoot();
        int count = root.getChildCount();
        if (count < 10) {
            for (int i = 0; i < count; ++i) {
                PackageDependenciesNode child = (PackageDependenciesNode)root.getChildAt(i);
                DependenciesPanel.expandNodeIfNotTooWide(tree, child);
            }
        }
    }

    private static void expandNodeIfNotTooWide(Tree tree, PackageDependenciesNode node) {
        int count = node.getChildCount();
        if (count > 5) {
            return;
        }
        if (count == 1 && node.getChildAt(0).getChildCount() > 5) {
            return;
        }
        tree.expandPath(new TreePath(node.getPath()));
    }

    private Set<PsiFile> getSelectedScope(Tree tree) {
        TreePath[] paths = tree.getSelectionPaths();
        if (paths == null) {
            return EMPTY_FILE_SET;
        }
        HashSet<PsiFile> result2 = new HashSet<PsiFile>();
        for (TreePath path : paths) {
            PackageDependenciesNode node = (PackageDependenciesNode)path.getLastPathComponent();
            node.fillFiles(result2, !this.mySettings.UI_FLATTEN_PACKAGES);
        }
        return result2;
    }

    public void setContent(Content content) {
        this.myContent = content;
    }

    public JTree getLeftTree() {
        return this.myLeftTree;
    }

    public JTree getRightTree() {
        return this.myRightTree;
    }

    public void dispose() {
        FileTreeModelBuilder.clearCaches(this.myProject);
    }

    @Nullable
    @NonNls
    public Object getData(@NonNls String dataId) {
        PackageDependenciesNode selectedNode;
        if (CommonDataKeys.PSI_ELEMENT.is(dataId) && (selectedNode = this.myRightTree.getSelectedNode()) != null) {
            PsiElement element = selectedNode.getPsiElement();
            return element != null && element.isValid() ? element : null;
        }
        if (PlatformDataKeys.HELP_ID.is(dataId)) {
            return "dependency.viewer.tool.window";
        }
        return null;
    }

    private void setEmptyText(boolean flag) {
        String emptyText = flag ? "No illegal dependencies found" : "Nothing to show";
        this.myLeftTree.getEmptyText().setText(emptyText);
        this.myRightTree.getEmptyText().setText(emptyText);
    }

    private void selectElementInLeftTree(PsiElement elt) {
        PsiManager manager = PsiManager.getInstance((Project)this.myProject);
        PackageDependenciesNode root = (PackageDependenciesNode)this.myLeftTree.getModel().getRoot();
        Enumeration<TreeNode> enumeration = root.breadthFirstEnumeration();
        while (enumeration.hasMoreElements()) {
            PackageDependenciesNode child = (PackageDependenciesNode)enumeration.nextElement();
            if (!manager.areElementsEquivalent(child.getPsiElement(), elt)) continue;
            this.myLeftTree.setSelectionPath(new TreePath(((DefaultTreeModel)this.myLeftTree.getModel()).getPathToRoot(child)));
            break;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/packageDependencies/ui/DependenciesPanel", "createFlattenModulesAction"));
    }

    public static class DependencyPanelSettings {
        public boolean UI_FLATTEN_PACKAGES = true;
        public boolean UI_SHOW_FILES = false;
        public boolean UI_SHOW_MODULES = true;
        public boolean UI_SHOW_MODULE_GROUPS = true;
        public boolean UI_FILTER_LEGALS = false;
        public boolean UI_GROUP_BY_SCOPE_TYPE = true;
        public String SCOPE_TYPE;
        public boolean UI_COMPACT_EMPTY_MIDDLE_PACKAGES = true;
        public boolean UI_FILTER_OUT_OF_CYCLE_PACKAGES = true;

        public DependencyPanelSettings() {
            DependencyUISettings settings = DependencyUISettings.getInstance();
            this.UI_FLATTEN_PACKAGES = settings.UI_FLATTEN_PACKAGES;
            this.UI_SHOW_FILES = settings.UI_SHOW_FILES;
            this.UI_SHOW_MODULES = settings.UI_SHOW_MODULES;
            this.UI_SHOW_MODULE_GROUPS = settings.UI_SHOW_MODULE_GROUPS;
            this.UI_FILTER_LEGALS = settings.UI_FILTER_LEGALS;
            this.UI_GROUP_BY_SCOPE_TYPE = settings.UI_GROUP_BY_SCOPE_TYPE;
            this.SCOPE_TYPE = settings.SCOPE_TYPE;
            this.UI_COMPACT_EMPTY_MIDDLE_PACKAGES = settings.UI_COMPACT_EMPTY_MIDDLE_PACKAGES;
            this.UI_FILTER_OUT_OF_CYCLE_PACKAGES = settings.UI_FILTER_OUT_OF_CYCLE_PACKAGES;
        }

        public void copyToApplicationDependencySettings() {
            DependencyUISettings settings = DependencyUISettings.getInstance();
            settings.UI_FLATTEN_PACKAGES = this.UI_FLATTEN_PACKAGES;
            settings.UI_SHOW_FILES = this.UI_SHOW_FILES;
            settings.UI_SHOW_MODULES = this.UI_SHOW_MODULES;
            settings.UI_SHOW_MODULE_GROUPS = this.UI_SHOW_MODULE_GROUPS;
            settings.UI_FILTER_LEGALS = this.UI_FILTER_LEGALS;
            settings.UI_GROUP_BY_SCOPE_TYPE = this.UI_GROUP_BY_SCOPE_TYPE;
            settings.SCOPE_TYPE = this.SCOPE_TYPE;
            settings.UI_COMPACT_EMPTY_MIDDLE_PACKAGES = this.UI_COMPACT_EMPTY_MIDDLE_PACKAGES;
            settings.UI_FILTER_OUT_OF_CYCLE_PACKAGES = this.UI_FILTER_OUT_OF_CYCLE_PACKAGES;
        }
    }

    private final class ChooseScopeTypeAction
    extends ComboBoxAction {
        private ChooseScopeTypeAction() {
        }

        @NotNull
        protected DefaultActionGroup createPopupActionGroup(JComponent button) {
            DefaultActionGroup group = new DefaultActionGroup();
            for (final PatternDialectProvider provider : (PatternDialectProvider[])Extensions.getExtensions(PatternDialectProvider.EP_NAME)) {
                group.add(new AnAction(provider.getDisplayName()){

                    public void actionPerformed(AnActionEvent e) {
                        ((DependenciesPanel)DependenciesPanel.this).mySettings.SCOPE_TYPE = provider.getShortName();
                        DependencyUISettings.getInstance().SCOPE_TYPE = provider.getShortName();
                        DependenciesPanel.this.rebuild();
                    }
                });
            }
            DefaultActionGroup defaultActionGroup = group;
            if (defaultActionGroup == null) {
                ChooseScopeTypeAction.$$$reportNull$$$0(0);
            }
            return defaultActionGroup;
        }

        public void update(AnActionEvent e) {
            super.update(e);
            PatternDialectProvider provider = PatternDialectProvider.getInstance(((DependenciesPanel)DependenciesPanel.this).mySettings.SCOPE_TYPE);
            e.getPresentation().setText(provider.getDisplayName());
            e.getPresentation().setIcon(provider.getIcon());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/packageDependencies/ui/DependenciesPanel$ChooseScopeTypeAction", "createPopupActionGroup"));
        }
    }

    private class MarkAsIllegalAction
    extends AnAction {
        public MarkAsIllegalAction() {
            super(AnalysisScopeBundle.message((String)"mark.dependency.illegal.text", (Object[])new Object[0]), AnalysisScopeBundle.message((String)"mark.dependency.illegal.text", (Object[])new Object[0]), AllIcons.Actions.Lightning);
        }

        public void actionPerformed(AnActionEvent e) {
            PackageDependenciesNode leftNode = DependenciesPanel.this.myLeftTree.getSelectedNode();
            PackageDependenciesNode rightNode = DependenciesPanel.this.myRightTree.getSelectedNode();
            if (leftNode != null && rightNode != null) {
                PatternDialectProvider provider;
                PackageSet leftPackageSet;
                boolean hasDirectDependencies;
                boolean bl = hasDirectDependencies = DependenciesPanel.this.myTransitiveBorder == 0;
                if (DependenciesPanel.this.myTransitiveBorder > 0) {
                    Set searchIn = DependenciesPanel.this.getSelectedScope(DependenciesPanel.this.myLeftTree);
                    Set searchFor = DependenciesPanel.this.getSelectedScope(DependenciesPanel.this.myRightTree);
                    block0: for (DependenciesBuilder builder : DependenciesPanel.this.myBuilders) {
                        if (hasDirectDependencies) break;
                        block1: for (PsiFile from : searchIn) {
                            if (hasDirectDependencies) continue block0;
                            block2: for (PsiFile to : searchFor) {
                                if (hasDirectDependencies) continue block1;
                                List<List<PsiFile>> paths = builder.findPaths(from, to);
                                for (List<PsiFile> path : paths) {
                                    if (!path.isEmpty()) continue;
                                    hasDirectDependencies = true;
                                    continue block2;
                                }
                            }
                        }
                    }
                }
                if ((leftPackageSet = (provider = PatternDialectProvider.getInstance(((DependenciesPanel)DependenciesPanel.this).mySettings.SCOPE_TYPE)).createPackageSet(leftNode, true)) == null) {
                    leftPackageSet = provider.createPackageSet(leftNode, false);
                }
                LOG.assertTrue(leftPackageSet != null);
                PackageSet rightPackageSet = provider.createPackageSet(rightNode, true);
                if (rightPackageSet == null) {
                    rightPackageSet = provider.createPackageSet(rightNode, false);
                }
                LOG.assertTrue(rightPackageSet != null);
                if (hasDirectDependencies) {
                    DependencyValidationManager.getInstance((Project)DependenciesPanel.this.myProject).addRule(new DependencyRule((NamedScope)new NamedScope.UnnamedScope(leftPackageSet), (NamedScope)new NamedScope.UnnamedScope(rightPackageSet), true));
                    DependenciesPanel.this.rebuild();
                } else {
                    Messages.showErrorDialog((Component)DependenciesPanel.this, (String)("Rule was not added.\n There is no direct dependency between '" + leftPackageSet.getText() + "' and '" + rightPackageSet.getText() + "'"), (String)AnalysisScopeBundle.message((String)"mark.dependency.illegal.text", (Object[])new Object[0]));
                }
            }
        }

        public void update(AnActionEvent e) {
            Presentation presentation = e.getPresentation();
            presentation.setEnabled(false);
            PackageDependenciesNode leftNode = DependenciesPanel.this.myLeftTree.getSelectedNode();
            PackageDependenciesNode rightNode = DependenciesPanel.this.myRightTree.getSelectedNode();
            if (leftNode != null && rightNode != null) {
                PatternDialectProvider provider = PatternDialectProvider.getInstance(((DependenciesPanel)DependenciesPanel.this).mySettings.SCOPE_TYPE);
                presentation.setEnabled(!(provider.createPackageSet(leftNode, true) == null && provider.createPackageSet(leftNode, false) == null || provider.createPackageSet(rightNode, true) == null && provider.createPackageSet(rightNode, false) == null));
            }
        }
    }

    private class SelectInLeftTreeAction
    extends AnAction {
        public SelectInLeftTreeAction() {
            super(AnalysisScopeBundle.message((String)"action.select.in.left.tree", (Object[])new Object[0]), AnalysisScopeBundle.message((String)"action.select.in.left.tree.description", (Object[])new Object[0]), null);
        }

        public void update(AnActionEvent e) {
            PackageDependenciesNode node = DependenciesPanel.this.myRightTree.getSelectedNode();
            e.getPresentation().setEnabled(node != null && node.canSelectInLeftTree(DependenciesPanel.this.myDependencies));
        }

        public void actionPerformed(AnActionEvent e) {
            PsiElement elt;
            PackageDependenciesNode node = DependenciesPanel.this.myRightTree.getSelectedNode();
            if (node != null && (elt = node.getPsiElement()) != null) {
                DependencyUISettings.getInstance().UI_FILTER_LEGALS = false;
                ((DependenciesPanel)DependenciesPanel.this).mySettings.UI_FILTER_LEGALS = false;
                DependenciesPanel.this.selectElementInLeftTree(elt);
            }
        }
    }

    private class AddToScopeAction
    extends AnAction {
        private AddToScopeAction() {
            super("Add to scope");
        }

        public void update(AnActionEvent e) {
            super.update(e);
            e.getPresentation().setEnabled(this.getScope() != null);
        }

        public void actionPerformed(AnActionEvent e) {
            AnalysisScope scope = this.getScope();
            LOG.assertTrue(scope != null);
            DependenciesBuilder builder = !DependenciesPanel.this.myForward ? new BackwardDependenciesBuilder(DependenciesPanel.this.myProject, scope, DependenciesPanel.this.myScopeOfInterest) : new ForwardDependenciesBuilder(DependenciesPanel.this.myProject, scope, DependenciesPanel.this.myTransitiveBorder);
            ProgressManager.getInstance().runProcessWithProgressAsynchronously(DependenciesPanel.this.myProject, AnalysisScopeBundle.message((String)"package.dependencies.progress.title", (Object[])new Object[0]), () -> builder.analyze(), () -> {
                DependenciesPanel.this.myBuilders.add(builder);
                DependenciesPanel.this.myDependencies.putAll(builder.getDependencies());
                DependenciesPanel.this.putAllDependencies(builder);
                DependenciesPanel.this.exclude(DependenciesPanel.this.myExcluded);
                DependenciesPanel.this.rebuild();
            }, null, (PerformInBackgroundOption)new PerformAnalysisInBackgroundOption(DependenciesPanel.this.myProject));
        }

        @Nullable
        private AnalysisScope getScope() {
            Set selectedScope = DependenciesPanel.this.getSelectedScope(DependenciesPanel.this.myRightTree);
            HashSet<PsiFile> result2 = new HashSet<PsiFile>();
            ((PackageDependenciesNode)DependenciesPanel.this.myLeftTree.getModel().getRoot()).fillFiles(result2, !((DependenciesPanel)DependenciesPanel.this).mySettings.UI_FLATTEN_PACKAGES);
            selectedScope.removeAll(result2);
            if (selectedScope.isEmpty()) {
                return null;
            }
            ArrayList<VirtualFile> files = new ArrayList<VirtualFile>();
            ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)DependenciesPanel.this.myProject).getFileIndex();
            for (PsiFile psiFile : selectedScope) {
                VirtualFile file2 = psiFile.getVirtualFile();
                LOG.assertTrue(file2 != null);
                if (!fileIndex.isInContent(file2)) continue;
                files.add(file2);
            }
            if (!files.isEmpty()) {
                return new AnalysisScope(DependenciesPanel.this.myProject, files);
            }
            return null;
        }
    }

    private class RemoveFromScopeAction
    extends AnAction {
        private RemoveFromScopeAction() {
            super("Remove from scope");
        }

        public void update(AnActionEvent e) {
            super.update(e);
            e.getPresentation().setEnabled(!DependenciesPanel.this.getSelectedScope(DependenciesPanel.this.myLeftTree).isEmpty());
        }

        public void actionPerformed(AnActionEvent e) {
            TreePath[] paths;
            Set selectedScope = DependenciesPanel.this.getSelectedScope(DependenciesPanel.this.myLeftTree);
            DependenciesPanel.this.exclude(selectedScope);
            DependenciesPanel.this.myExcluded.addAll(selectedScope);
            for (TreePath path : paths = DependenciesPanel.this.myLeftTree.getSelectionPaths()) {
                TreeUtil.removeLastPathComponent((JTree)((Object)DependenciesPanel.this.myLeftTree), (TreePath)path);
            }
        }
    }

    private class ShowDetailedInformationAction
    extends AnAction {
        private ShowDetailedInformationAction() {
            super("Show indirect dependencies");
        }

        public void actionPerformed(AnActionEvent e) {
            String delim = "&nbsp;-&gt;&nbsp;";
            StringBuffer buf = new StringBuffer();
            DependenciesPanel.this.processDependencies(DependenciesPanel.this.getSelectedScope(DependenciesPanel.this.myLeftTree), DependenciesPanel.this.getSelectedScope(DependenciesPanel.this.myRightTree), (Processor<List<PsiFile>>)path -> {
                if (buf.length() > 0) {
                    buf.append("<br>");
                }
                buf.append(StringUtil.join((Collection)path, psiFile -> psiFile.getName(), (String)"&nbsp;-&gt;&nbsp;"));
                return true;
            });
            JEditorPane pane = new JEditorPane("text/html", XmlStringUtil.wrapInHtml((CharSequence)buf));
            pane.setForeground(JBColor.foreground());
            pane.setBackground(HintUtil.getInformationColor());
            pane.setOpaque(true);
            JScrollPane scrollPane = ScrollPaneFactory.createScrollPane((Component)pane);
            Dimension dimension = pane.getPreferredSize();
            scrollPane.setMinimumSize(new Dimension(dimension.width, dimension.height + 20));
            scrollPane.setPreferredSize(new Dimension(dimension.width, dimension.height + 20));
            JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)scrollPane, (JComponent)pane).setTitle("Dependencies").setMovable(true).createPopup().showInBestPositionFor(e.getDataContext());
        }

        public void update(AnActionEvent e) {
            boolean[] direct = new boolean[]{true};
            DependenciesPanel.this.processDependencies(DependenciesPanel.this.getSelectedScope(DependenciesPanel.this.myLeftTree), DependenciesPanel.this.getSelectedScope(DependenciesPanel.this.myRightTree), (Processor<List<PsiFile>>)path -> {
                direct[0] = false;
                return false;
            });
            e.getPresentation().setEnabled(!direct[0]);
        }
    }

    private static class MyTree
    extends Tree
    implements DataProvider {
        private MyTree() {
        }

        public Object getData(String dataId) {
            PackageDependenciesNode node = this.getSelectedNode();
            if (CommonDataKeys.NAVIGATABLE.is(dataId)) {
                return node;
            }
            if (CommonDataKeys.PSI_ELEMENT.is(dataId) && node != null) {
                PsiElement element = node.getPsiElement();
                return element != null && element.isValid() ? element : null;
            }
            return null;
        }

        @Nullable
        public PackageDependenciesNode getSelectedNode() {
            TreePath[] paths = this.getSelectionPaths();
            if (paths == null || paths.length != 1) {
                return null;
            }
            return (PackageDependenciesNode)paths[0].getLastPathComponent();
        }
    }

    private class RerunAction
    extends AnAction {
        public RerunAction(JComponent comp) {
            super(CommonBundle.message((String)"action.rerun", (Object[])new Object[0]), AnalysisScopeBundle.message((String)"action.rerun.dependency", (Object[])new Object[0]), AllIcons.Actions.Rerun);
            this.registerCustomShortcutSet(CommonShortcuts.getRerun(), comp);
        }

        public void update(AnActionEvent e) {
            boolean enabled = true;
            for (DependenciesBuilder builder : DependenciesPanel.this.myBuilders) {
                enabled &= builder.getScope().isValid();
            }
            e.getPresentation().setEnabled(enabled);
        }

        public void actionPerformed(AnActionEvent e) {
            DependenciesToolWindow.getInstance(DependenciesPanel.this.myProject).closeContent(DependenciesPanel.this.myContent);
            DependenciesPanel.this.mySettings.copyToApplicationDependencySettings();
            SwingUtilities.invokeLater(() -> {
                ArrayList<AnalysisScope> scopes = new ArrayList<AnalysisScope>();
                for (DependenciesBuilder builder : DependenciesPanel.this.myBuilders) {
                    AnalysisScope scope = builder.getScope();
                    scope.invalidate();
                    scopes.add(scope);
                }
                if (!DependenciesPanel.this.myForward) {
                    new BackwardDependenciesHandler(DependenciesPanel.this.myProject, scopes, DependenciesPanel.this.myScopeOfInterest, DependenciesPanel.this.myExcluded).analyze();
                } else {
                    new AnalyzeDependenciesHandler(DependenciesPanel.this.myProject, scopes, DependenciesPanel.this.myTransitiveBorder, DependenciesPanel.this.myExcluded).analyze();
                }
            });
        }
    }

    private class DependenciesExporterToTextFile
    implements ExporterToTextFile {
        private DependenciesExporterToTextFile() {
        }

        @NotNull
        public String getReportText() {
            Element rootElement = new Element("root");
            rootElement.setAttribute("isBackward", String.valueOf(!DependenciesPanel.this.myForward));
            ArrayList files = new ArrayList(DependenciesPanel.this.myDependencies.keySet());
            Collections.sort(files, (f1, f2) -> {
                VirtualFile virtualFile1 = f1.getVirtualFile();
                VirtualFile virtualFile2 = f2.getVirtualFile();
                if (virtualFile1 != null && virtualFile2 != null) {
                    return virtualFile1.getPath().compareToIgnoreCase(virtualFile2.getPath());
                }
                return 0;
            });
            for (PsiFile file2 : files) {
                Element fileElement = new Element("file");
                fileElement.setAttribute("path", file2.getVirtualFile().getPath());
                for (PsiFile dep : (Set)DependenciesPanel.this.myDependencies.get(file2)) {
                    Element depElement = new Element("dependency");
                    depElement.setAttribute("path", dep.getVirtualFile().getPath());
                    fileElement.addContent(depElement);
                }
                rootElement.addContent(fileElement);
            }
            PathMacroManager.getInstance((ComponentManager)DependenciesPanel.this.myProject).collapsePaths(rootElement);
            String string = JDOMUtil.writeDocument((Document)new Document(rootElement), (String)SystemProperties.getLineSeparator());
            if (string == null) {
                DependenciesExporterToTextFile.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        public String getDefaultFilePath() {
            if ("" == null) {
                DependenciesExporterToTextFile.$$$reportNull$$$0(1);
            }
            return "";
        }

        public boolean canExport() {
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/packageDependencies/ui/DependenciesPanel$DependenciesExporterToTextFile";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getReportText";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDefaultFilePath";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }

    private final class EditDependencyRulesAction
    extends AnAction {
        public EditDependencyRulesAction() {
            super(AnalysisScopeBundle.message((String)"action.edit.rules", (Object[])new Object[0]), AnalysisScopeBundle.message((String)"action.edit.rules.description", (Object[])new Object[0]), AllIcons.General.Settings);
        }

        public void actionPerformed(AnActionEvent e) {
            boolean applied = ShowSettingsUtil.getInstance().editConfigurable((Component)DependenciesPanel.this, (Configurable)new DependencyConfigurable(DependenciesPanel.this.myProject));
            if (applied) {
                DependenciesPanel.this.rebuild();
            }
        }
    }

    private final class FilterLegalsAction
    extends ToggleAction {
        FilterLegalsAction() {
            super(AnalysisScopeBundle.message((String)"action.show.illegals.only", (Object[])new Object[0]), AnalysisScopeBundle.message((String)"action.show.illegals.only.description", (Object[])new Object[0]), AllIcons.General.Filter);
        }

        public boolean isSelected(AnActionEvent event) {
            return ((DependenciesPanel)DependenciesPanel.this).mySettings.UI_FILTER_LEGALS;
        }

        public void setSelected(AnActionEvent event, boolean flag) {
            DependencyUISettings.getInstance().UI_FILTER_LEGALS = flag;
            ((DependenciesPanel)DependenciesPanel.this).mySettings.UI_FILTER_LEGALS = flag;
            DependenciesPanel.this.setEmptyText(flag);
            DependenciesPanel.this.rebuild();
        }
    }

    private final class GroupByScopeTypeAction
    extends ToggleAction {
        GroupByScopeTypeAction() {
            super(AnalysisScopeBundle.message((String)"action.group.by.scope.type", (Object[])new Object[0]), AnalysisScopeBundle.message((String)"action.group.by.scope.type.description", (Object[])new Object[0]), AllIcons.Actions.GroupByTestProduction);
        }

        public boolean isSelected(AnActionEvent event) {
            return ((DependenciesPanel)DependenciesPanel.this).mySettings.UI_GROUP_BY_SCOPE_TYPE;
        }

        public void setSelected(AnActionEvent event, boolean flag) {
            DependencyUISettings.getInstance().UI_GROUP_BY_SCOPE_TYPE = flag;
            ((DependenciesPanel)DependenciesPanel.this).mySettings.UI_GROUP_BY_SCOPE_TYPE = flag;
            DependenciesPanel.this.rebuild();
        }

        public void update(AnActionEvent e) {
            super.update(e);
        }
    }

    private final class ShowModuleGroupsAction
    extends ToggleAction {
        ShowModuleGroupsAction() {
            super("Show module groups", "Show module groups", AllIcons.Actions.GroupByModuleGroup);
        }

        public boolean isSelected(AnActionEvent event) {
            return ((DependenciesPanel)DependenciesPanel.this).mySettings.UI_SHOW_MODULE_GROUPS;
        }

        public void setSelected(AnActionEvent event, boolean flag) {
            DependencyUISettings.getInstance().UI_SHOW_MODULE_GROUPS = flag;
            ((DependenciesPanel)DependenciesPanel.this).mySettings.UI_SHOW_MODULE_GROUPS = flag;
            DependenciesPanel.this.rebuild();
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                ShowModuleGroupsAction.$$$reportNull$$$0(0);
            }
            super.update(e);
            e.getPresentation().setVisible(ModuleManager.getInstance((Project)DependenciesPanel.this.myProject).hasModuleGroups());
            e.getPresentation().setEnabled(((DependenciesPanel)DependenciesPanel.this).mySettings.UI_SHOW_MODULES);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/packageDependencies/ui/DependenciesPanel$ShowModuleGroupsAction", "update"));
        }
    }

    private final class ShowModulesAction
    extends ToggleAction {
        ShowModulesAction() {
            super(AnalysisScopeBundle.message((String)"action.show.modules", (Object[])new Object[0]), AnalysisScopeBundle.message((String)"action.show.modules.description", (Object[])new Object[0]), AllIcons.Actions.GroupByModule);
        }

        public boolean isSelected(AnActionEvent event) {
            return ((DependenciesPanel)DependenciesPanel.this).mySettings.UI_SHOW_MODULES;
        }

        public void setSelected(AnActionEvent event, boolean flag) {
            DependencyUISettings.getInstance().UI_SHOW_MODULES = flag;
            ((DependenciesPanel)DependenciesPanel.this).mySettings.UI_SHOW_MODULES = flag;
            DependenciesPanel.this.rebuild();
        }
    }

    private final class ShowFilesAction
    extends ToggleAction {
        ShowFilesAction() {
            super(AnalysisScopeBundle.message((String)"action.show.files", (Object[])new Object[0]), AnalysisScopeBundle.message((String)"action.show.files.description", (Object[])new Object[0]), AllIcons.FileTypes.Unknown);
        }

        public boolean isSelected(AnActionEvent event) {
            return ((DependenciesPanel)DependenciesPanel.this).mySettings.UI_SHOW_FILES;
        }

        public void setSelected(AnActionEvent event, boolean flag) {
            DependencyUISettings.getInstance().UI_SHOW_FILES = flag;
            ((DependenciesPanel)DependenciesPanel.this).mySettings.UI_SHOW_FILES = flag;
            if (!flag && DependenciesPanel.this.myLeftTree.getSelectionPath() != null && DependenciesPanel.this.myLeftTree.getSelectionPath().getLastPathComponent() instanceof FileNode) {
                TreeUtil.selectPath((JTree)((Object)DependenciesPanel.this.myLeftTree), (TreePath)DependenciesPanel.this.myLeftTree.getSelectionPath().getParentPath());
            }
            DependenciesPanel.this.rebuild();
        }
    }

    private final class FlattenPackagesAction
    extends ToggleAction {
        FlattenPackagesAction() {
            super(AnalysisScopeBundle.message((String)"action.flatten.packages", (Object[])new Object[0]), AnalysisScopeBundle.message((String)"action.flatten.packages", (Object[])new Object[0]), PlatformIcons.FLATTEN_PACKAGES_ICON);
        }

        public boolean isSelected(AnActionEvent event) {
            return ((DependenciesPanel)DependenciesPanel.this).mySettings.UI_FLATTEN_PACKAGES;
        }

        public void setSelected(AnActionEvent event, boolean flag) {
            DependencyUISettings.getInstance().UI_FLATTEN_PACKAGES = flag;
            ((DependenciesPanel)DependenciesPanel.this).mySettings.UI_FLATTEN_PACKAGES = flag;
            DependenciesPanel.this.rebuild();
        }
    }

    private final class CloseAction
    extends AnAction
    implements DumbAware {
        public CloseAction() {
            super(CommonBundle.message((String)"action.close", (Object[])new Object[0]), AnalysisScopeBundle.message((String)"action.close.dependency.description", (Object[])new Object[0]), AllIcons.Actions.Cancel);
        }

        public void actionPerformed(AnActionEvent e) {
            Disposer.dispose((Disposable)DependenciesPanel.this.myUsagesPanel);
            DependenciesToolWindow.getInstance(DependenciesPanel.this.myProject).closeContent(DependenciesPanel.this.myContent);
            DependenciesPanel.this.mySettings.copyToApplicationDependencySettings();
        }
    }

    private static class MyTreeCellRenderer
    extends ColoredTreeCellRenderer {
        private MyTreeCellRenderer() {
        }

        public void customizeCellRenderer(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            PackageDependenciesNode node = (PackageDependenciesNode)value;
            if (node.isValid()) {
                this.setIcon(node.getIcon());
            } else {
                this.append(UsageViewBundle.message((String)"node.invalid", (Object[])new Object[0]) + " ", SimpleTextAttributes.ERROR_ATTRIBUTES);
            }
            this.append(node.toString(), node.hasMarked() && !selected ? SimpleTextAttributes.ERROR_ATTRIBUTES : SimpleTextAttributes.REGULAR_ATTRIBUTES);
            this.append(node.getPresentableFilesCount(), SimpleTextAttributes.GRAYED_ATTRIBUTES);
        }
    }
}

