/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform;

import com.intellij.ide.GeneralSettings;
import com.intellij.ide.IdeEventQueue;
import com.intellij.ide.impl.ProjectUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.DumbAwareRunnable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ex.ProjectManagerEx;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModuleRootModificationUtil;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.impl.welcomeScreen.WelcomeFrame;
import com.intellij.platform.DirectoryProjectConfigurator;
import com.intellij.platform.OpenOrAttachDialog;
import com.intellij.platform.ProjectBaseDirectory;
import com.intellij.projectImport.ProjectAttachProcessor;
import com.intellij.projectImport.ProjectOpenProcessor;
import com.intellij.projectImport.ProjectOpenedCallback;
import com.intellij.util.io.PathKt;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.EnumSet;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlatformProjectOpenProcessor
extends ProjectOpenProcessor {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.platform.PlatformProjectOpenProcessor");

    public static PlatformProjectOpenProcessor getInstance() {
        PlatformProjectOpenProcessor projectOpenProcessor = PlatformProjectOpenProcessor.getInstanceIfItExists();
        assert (projectOpenProcessor != null);
        return projectOpenProcessor;
    }

    @Nullable
    public static PlatformProjectOpenProcessor getInstanceIfItExists() {
        ProjectOpenProcessor[] processors;
        for (ProjectOpenProcessor processor2 : processors = (ProjectOpenProcessor[])Extensions.getExtensions((ExtensionPointName)EXTENSION_POINT_NAME)) {
            if (!(processor2 instanceof PlatformProjectOpenProcessor)) continue;
            return (PlatformProjectOpenProcessor)processor2;
        }
        return null;
    }

    public boolean canOpenProject(VirtualFile file2) {
        return file2.isDirectory();
    }

    public boolean isProjectFile(VirtualFile file2) {
        return false;
    }

    public boolean lookForProjectsInDirectory() {
        return false;
    }

    @Nullable
    public Project doOpenProject(@NotNull VirtualFile virtualFile, @Nullable Project projectToClose, boolean forceOpenInNewFrame) {
        if (virtualFile == null) {
            PlatformProjectOpenProcessor.$$$reportNull$$$0(0);
        }
        EnumSet<Option> options = EnumSet.noneOf(Option.class);
        if (forceOpenInNewFrame) {
            options.add(Option.FORCE_NEW_FRAME);
        }
        return PlatformProjectOpenProcessor.doOpenProject(virtualFile, projectToClose, -1, null, options);
    }

    @Nullable
    public Project doOpenProject(@NotNull VirtualFile file2, @Nullable Project projectToClose, int line, @NotNull EnumSet<Option> options) {
        if (file2 == null) {
            PlatformProjectOpenProcessor.$$$reportNull$$$0(1);
        }
        if (options == null) {
            PlatformProjectOpenProcessor.$$$reportNull$$$0(2);
        }
        return PlatformProjectOpenProcessor.doOpenProject(file2, projectToClose, line, null, options);
    }

    public static Project doOpenProject(@NotNull VirtualFile virtualFile, Project projectToClose, boolean forceOpenInNewFrame, int line, @Nullable ProjectOpenedCallback callback, boolean isReopen) {
        if (virtualFile == null) {
            PlatformProjectOpenProcessor.$$$reportNull$$$0(3);
        }
        EnumSet<Option> options = EnumSet.noneOf(Option.class);
        if (forceOpenInNewFrame) {
            options.add(Option.FORCE_NEW_FRAME);
        }
        if (isReopen) {
            options.add(Option.REOPEN);
        }
        return PlatformProjectOpenProcessor.doOpenProject(virtualFile, projectToClose, line, callback, options);
    }

    @Nullable
    public static Project doOpenProject(@NotNull VirtualFile virtualFile, @Nullable Project projectToClose, int line, @Nullable ProjectOpenedCallback callback, @NotNull EnumSet<Option> options) {
        Module module;
        if (virtualFile == null) {
            PlatformProjectOpenProcessor.$$$reportNull$$$0(4);
        }
        if (options == null) {
            PlatformProjectOpenProcessor.$$$reportNull$$$0(5);
        }
        VirtualFile baseDir = virtualFile;
        boolean dummyProject = false;
        String dummyProjectName = null;
        boolean forceOpenInNewFrame = options.contains((Object)Option.FORCE_NEW_FRAME);
        boolean isReopen = options.contains((Object)Option.REOPEN);
        boolean tempProject = options.contains((Object)Option.TEMP_PROJECT);
        if (!baseDir.isDirectory()) {
            if (tempProject) {
                baseDir = null;
            } else {
                for (baseDir = virtualFile.getParent(); baseDir != null && !com.intellij.openapi.project.ProjectUtil.isProjectDirectoryExistsUsingIo((VirtualFile)baseDir); baseDir = baseDir.getParent()) {
                }
            }
            if (baseDir == null) {
                if (tempProject || Registry.is((String)"ide.open.file.in.temp.project.dir")) {
                    try {
                        dummyProjectName = virtualFile.getName();
                        File directory = FileUtil.createTempDirectory((String)dummyProjectName, null, (boolean)true);
                        baseDir = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(directory);
                        dummyProject = true;
                    }
                    catch (IOException ex) {
                        LOG.error((Throwable)ex);
                    }
                }
                if (baseDir == null) {
                    baseDir = virtualFile.getParent();
                }
            }
        }
        Path projectDir = Paths.get(FileUtil.toSystemDependentName((String)baseDir.getPath()), ".idea");
        Project[] openProjects = ProjectManager.getInstance().getOpenProjects();
        if (!forceOpenInNewFrame && openProjects.length > 0) {
            if (projectToClose == null) {
                projectToClose = openProjects[openProjects.length - 1];
            }
            if (ProjectAttachProcessor.canAttachToProject() && GeneralSettings.getInstance().getConfirmOpenNewProject() == -1) {
                OpenOrAttachDialog dialog2 = new OpenOrAttachDialog(projectToClose, isReopen, isReopen ? "Reopen Project" : "Open Project");
                if (!dialog2.showAndGet()) {
                    return null;
                }
                if (dialog2.isReplace() ? !ProjectUtil.closeAndDispose(projectToClose) : dialog2.isAttach() && PlatformProjectOpenProcessor.attachToProject(projectToClose, Paths.get(FileUtil.toSystemDependentName((String)baseDir.getPath()), new String[0]), callback)) {
                    return null;
                }
                IdeEventQueue.getInstance().flushQueue();
            } else {
                int exitCode = ProjectUtil.confirmOpenNewProject(false);
                if (exitCode == 1 ? !ProjectUtil.closeAndDispose(projectToClose) : exitCode != 0) {
                    return null;
                }
            }
        }
        boolean runConfigurators = true;
        boolean newProject = false;
        ProjectManagerEx projectManager = ProjectManagerEx.getInstanceEx();
        Project project = null;
        if (PathKt.exists((Path)projectDir)) {
            try {
                Module[] modules;
                File baseDirIo = VfsUtilCore.virtualToIoFile((VirtualFile)baseDir);
                for (ProjectOpenProcessor processor2 : (ProjectOpenProcessor[])ProjectOpenProcessor.EXTENSION_POINT_NAME.getExtensions()) {
                    processor2.refreshProjectFiles(baseDirIo);
                }
                project = projectManager.convertAndLoadProject(baseDir.getPath());
                if (project != null && (modules = ModuleManager.getInstance((Project)project).getModules()).length > 0) {
                    runConfigurators = false;
                }
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
            }
        } else {
            PathKt.createDirectories((Path)projectDir);
            project = projectManager.newProject(dummyProject ? dummyProjectName : baseDir.getName(), baseDir.getPath(), true, dummyProject);
            newProject = true;
        }
        if (project == null) {
            WelcomeFrame.showIfNoProjectOpened();
            return null;
        }
        ProjectBaseDirectory.getInstance(project).setBaseDir(baseDir);
        Module module2 = module = runConfigurators ? PlatformProjectOpenProcessor.runDirectoryProjectConfigurators(baseDir, project) : ModuleManager.getInstance((Project)project).getModules()[0];
        if (runConfigurators && dummyProject) {
            ModuleRootModificationUtil.updateModel((Module)module, model -> {
                ContentEntry[] entries;
                if (virtualFile == null) {
                    PlatformProjectOpenProcessor.$$$reportNull$$$0(7);
                }
                if ((entries = model.getContentEntries()).length == 1) {
                    model.removeContentEntry(entries[0]);
                }
                model.addContentEntry(virtualFile);
            });
        }
        if (newProject) {
            project.save();
        }
        if (!virtualFile.isDirectory()) {
            PlatformProjectOpenProcessor.openFileFromCommandLine(project, virtualFile, line);
        }
        if (!projectManager.openProject(project)) {
            WelcomeFrame.showIfNoProjectOpened();
            return null;
        }
        if (callback != null) {
            callback.projectOpened(project, module);
        }
        return project;
    }

    public static Module runDirectoryProjectConfigurators(VirtualFile baseDir, Project project) {
        Ref moduleRef = new Ref();
        for (DirectoryProjectConfigurator configurator : (DirectoryProjectConfigurator[])Extensions.getExtensions(DirectoryProjectConfigurator.EP_NAME)) {
            try {
                configurator.configureProject(project, baseDir, (Ref<Module>)moduleRef);
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
            }
        }
        return (Module)moduleRef.get();
    }

    public static boolean attachToProject(Project project, @NotNull Path projectDir, ProjectOpenedCallback callback) {
        if (projectDir == null) {
            PlatformProjectOpenProcessor.$$$reportNull$$$0(6);
        }
        for (ProjectAttachProcessor processor2 : (ProjectAttachProcessor[])Extensions.getExtensions((ExtensionPointName)ProjectAttachProcessor.EP_NAME)) {
            if (!processor2.attachToProject(project, projectDir, callback)) continue;
            return true;
        }
        return false;
    }

    private static void openFileFromCommandLine(Project project, VirtualFile file2, int line) {
        StartupManager.getInstance((Project)project).registerPostStartupActivity((Runnable)((DumbAwareRunnable)() -> ApplicationManager.getApplication().invokeLater(() -> {
            if (!project.isDisposed() && file2.isValid()) {
                (line > 0 ? new OpenFileDescriptor(project, file2, line - 1, 0) : new OpenFileDescriptor(project, file2)).navigate(true);
            }
        }, ModalityState.NON_MODAL)));
    }

    @Nullable
    public Icon getIcon() {
        return null;
    }

    public String getName() {
        return "text editor";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectDir";
                break;
            }
        }
        objectArray2[1] = "com/intellij/platform/PlatformProjectOpenProcessor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "doOpenProject";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "attachToProject";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$doOpenProject$0";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static enum Option {
        FORCE_NEW_FRAME,
        REOPEN,
        TEMP_PROJECT;

    }
}

