/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.file;

import com.intellij.icons.AllIcons;
import com.intellij.ide.IconProvider;
import com.intellij.ide.projectView.impl.ProjectRootsUtil;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.roots.ui.configuration.SourceRootPresentation;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.util.PlatformIcons;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DirectoryIconProvider
extends IconProvider
implements DumbAware {
    public Icon getIcon(@NotNull PsiElement element, int flags) {
        if (element == null) {
            DirectoryIconProvider.$$$reportNull$$$0(0);
        }
        if (element instanceof PsiDirectory) {
            PsiDirectory psiDirectory = (PsiDirectory)element;
            return DirectoryIconProvider.getDirectoryIcon(psiDirectory.getVirtualFile(), psiDirectory.getProject());
        }
        return null;
    }

    public static Icon getDirectoryIcon(VirtualFile vFile, Project project) {
        SourceFolder sourceFolder = ProjectRootsUtil.getModuleSourceRoot(vFile, project);
        if (sourceFolder != null) {
            return SourceRootPresentation.getSourceRootIcon(sourceFolder);
        }
        Icon excludedIcon = DirectoryIconProvider.getIconIfExcluded(project, vFile);
        return excludedIcon != null ? excludedIcon : PlatformIcons.DIRECTORY_CLOSED_ICON;
    }

    @Nullable
    public static Icon getIconIfExcluded(@NotNull Project project, @NotNull VirtualFile vFile) {
        boolean ignored;
        if (project == null) {
            DirectoryIconProvider.$$$reportNull$$$0(1);
        }
        if (vFile == null) {
            DirectoryIconProvider.$$$reportNull$$$0(2);
        }
        if (!Registry.is((String)"ide.hide.excluded.files") && (ignored = ProjectRootManager.getInstance((Project)project).getFileIndex().isExcluded(vFile))) {
            return AllIcons.Modules.ExcludeRoot;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vFile";
                break;
            }
        }
        objectArray2[1] = "com/intellij/psi/impl/file/DirectoryIconProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getIcon";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getIconIfExcluded";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

