/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.codeStyle.lineIndent;

import com.intellij.application.options.CodeStyle;
import com.intellij.formatting.Indent;
import com.intellij.formatting.IndentInfo;
import com.intellij.lang.Language;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.impl.source.codeStyle.SemanticEditorPosition;
import com.intellij.util.text.CharArrayUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IndentCalculator {
    @NotNull
    private final Project myProject;
    @NotNull
    private final Editor myEditor;
    @NotNull
    private BaseLineOffsetCalculator myBaseLineOffsetCalculator;
    @NotNull
    private final Indent.Type myIndentType;
    public static final BaseLineOffsetCalculator LINE_BEFORE = new BaseLineOffsetCalculator(){

        @Override
        public int getOffsetInBaseIndentLine(@NotNull SemanticEditorPosition currPosition) {
            if (currPosition == null) {
                1.$$$reportNull$$$0(0);
            }
            return CharArrayUtil.shiftBackward((CharSequence)currPosition.getChars(), (int)currPosition.getStartOffset(), (String)" \t\n\r");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "currPosition", "com/intellij/psi/impl/source/codeStyle/lineIndent/IndentCalculator$1", "getOffsetInBaseIndentLine"));
        }
    };
    public static final BaseLineOffsetCalculator LINE_AFTER = new BaseLineOffsetCalculator(){

        @Override
        public int getOffsetInBaseIndentLine(@NotNull SemanticEditorPosition currPosition) {
            if (currPosition == null) {
                2.$$$reportNull$$$0(0);
            }
            return CharArrayUtil.shiftForward((CharSequence)currPosition.getChars(), (int)currPosition.getStartOffset(), (String)" \t\n\r");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "currPosition", "com/intellij/psi/impl/source/codeStyle/lineIndent/IndentCalculator$2", "getOffsetInBaseIndentLine"));
        }
    };

    public IndentCalculator(@NotNull Project project, @NotNull Editor editor, @NotNull BaseLineOffsetCalculator baseLineOffsetCalculator, @NotNull Indent.Type type) {
        if (project == null) {
            IndentCalculator.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            IndentCalculator.$$$reportNull$$$0(1);
        }
        if (baseLineOffsetCalculator == null) {
            IndentCalculator.$$$reportNull$$$0(2);
        }
        if (type == null) {
            IndentCalculator.$$$reportNull$$$0(3);
        }
        this.myProject = project;
        this.myEditor = editor;
        this.myBaseLineOffsetCalculator = baseLineOffsetCalculator;
        this.myIndentType = type;
    }

    @Nullable
    String getIndentString(@Nullable Language language, @NotNull SemanticEditorPosition currPosition) {
        if (currPosition == null) {
            IndentCalculator.$$$reportNull$$$0(4);
        }
        String baseIndent = this.getBaseIndent(currPosition);
        Document document = this.myEditor.getDocument();
        PsiFile file2 = PsiDocumentManager.getInstance((Project)this.myProject).getPsiFile(document);
        if (file2 != null) {
            CommonCodeStyleSettings.IndentOptions fileOptions = CodeStyle.getIndentOptions((PsiFile)file2);
            CommonCodeStyleSettings.IndentOptions options = !fileOptions.isOverrideLanguageOptions() && language != null && !language.is(file2.getLanguage()) && !language.is(Language.ANY) ? CodeStyle.getLanguageSettings((PsiFile)file2, (Language)language).getIndentOptions() : fileOptions;
            return baseIndent + new IndentInfo(0, IndentCalculator.indentTypeToSize(this.myIndentType, options), 0, false).generateNewWhiteSpace(options);
        }
        return null;
    }

    @NotNull
    private String getBaseIndent(@NotNull SemanticEditorPosition currPosition) {
        int indentEnd;
        int indentStart;
        int indentLineOffset;
        if (currPosition == null) {
            IndentCalculator.$$$reportNull$$$0(5);
        }
        CharSequence docChars = this.myEditor.getDocument().getCharsSequence();
        int offset = currPosition.getStartOffset();
        if (offset > 0 && (indentLineOffset = this.myBaseLineOffsetCalculator.getOffsetInBaseIndentLine(currPosition)) > 0 && (indentStart = CharArrayUtil.shiftBackwardUntil((CharSequence)docChars, (int)indentLineOffset, (String)"\n") + 1) >= 0 && (indentEnd = CharArrayUtil.shiftForward((CharSequence)docChars, (int)indentStart, (String)" \t")) > indentStart) {
            String string = docChars.subSequence(indentStart, indentEnd).toString();
            if (string == null) {
                IndentCalculator.$$$reportNull$$$0(6);
            }
            return string;
        }
        if ("" == null) {
            IndentCalculator.$$$reportNull$$$0(7);
        }
        return "";
    }

    private static int indentTypeToSize(@NotNull Indent.Type indentType, @NotNull CommonCodeStyleSettings.IndentOptions options) {
        if (indentType == null) {
            IndentCalculator.$$$reportNull$$$0(8);
        }
        if (options == null) {
            IndentCalculator.$$$reportNull$$$0(9);
        }
        if (indentType == Indent.Type.NORMAL) {
            return options.INDENT_SIZE;
        }
        if (indentType == Indent.Type.CONTINUATION) {
            return options.CONTINUATION_INDENT_SIZE;
        }
        return 0;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseLineOffsetCalculator";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currPosition";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/codeStyle/lineIndent/IndentCalculator";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indentType";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/codeStyle/lineIndent/IndentCalculator";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getBaseIndent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getIndentString";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getBaseIndent";
                break;
            }
            case 6: 
            case 7: {
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "indentTypeToSize";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface BaseLineOffsetCalculator {
        public int getOffsetInBaseIndentLine(@NotNull SemanticEditorPosition var1);
    }
}

