/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree.injected;

import com.intellij.codeInsight.daemon.impl.DaemonProgressIndicator;
import com.intellij.injected.editor.DocumentWindow;
import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.lang.ASTNode;
import com.intellij.lang.FileASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.lang.injection.MultiHostRegistrar;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.fileEditor.impl.FileDocumentManagerImpl;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighterFactory;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.ProperTextRange;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.util.UnfairTextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.LanguageSubstitutors;
import com.intellij.psi.LiteralTextEscaper;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiManager;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.impl.BooleanRunnable;
import com.intellij.psi.impl.DebugUtil;
import com.intellij.psi.impl.DocumentCommitThread;
import com.intellij.psi.impl.PsiDocumentManagerBase;
import com.intellij.psi.impl.smartPointers.Identikit;
import com.intellij.psi.impl.smartPointers.SelfElementInfo;
import com.intellij.psi.impl.smartPointers.SmartPointerManagerImpl;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.impl.source.resolve.FileContextUtil;
import com.intellij.psi.impl.source.text.BlockSupportImpl;
import com.intellij.psi.impl.source.text.DiffLog;
import com.intellij.psi.impl.source.tree.FileElement;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.impl.source.tree.injected.DocumentWindowImpl;
import com.intellij.psi.impl.source.tree.injected.InjectedFileViewProvider;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageManagerImpl;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.impl.source.tree.injected.InjectionResult;
import com.intellij.psi.impl.source.tree.injected.LeafPatcher;
import com.intellij.psi.impl.source.tree.injected.MultiHostRegistrarImpl;
import com.intellij.psi.impl.source.tree.injected.Place;
import com.intellij.psi.impl.source.tree.injected.PlaceInfo;
import com.intellij.psi.impl.source.tree.injected.ShredImpl;
import com.intellij.psi.impl.source.tree.injected.VirtualFileWindowImpl;
import com.intellij.psi.injection.ReferenceInjector;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PathUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ConcurrentList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class InjectionRegistrarImpl
extends MultiHostRegistrarImpl
implements MultiHostRegistrar {
    private List<PsiFile> resultFiles;
    private List<Pair<ReferenceInjector, Place>> resultReferences;
    private Language myLanguage;
    private List<PlaceInfo> placeInfos;
    private boolean cleared;
    private String fileExtension;
    private final Project myProject;
    private final DocumentEx myHostDocument;
    private final VirtualFile myHostVirtualFile;
    private final PsiElement myContextElement;
    private final PsiFile myHostPsiFile;
    private Thread currentThread;
    private static final Key<ASTNode> TREE_HARD_REF = Key.create((String)"TREE_HARD_REF");

    InjectionRegistrarImpl(@NotNull Project project, @NotNull PsiFile hostPsiFile, @NotNull PsiElement contextElement) {
        if (project == null) {
            InjectionRegistrarImpl.$$$reportNull$$$0(0);
        }
        if (hostPsiFile == null) {
            InjectionRegistrarImpl.$$$reportNull$$$0(1);
        }
        if (contextElement == null) {
            InjectionRegistrarImpl.$$$reportNull$$$0(2);
        }
        this.cleared = true;
        this.myProject = project;
        this.myContextElement = contextElement;
        this.myHostPsiFile = PsiUtilCore.getTemplateLanguageFile((PsiElement)hostPsiFile);
        FileViewProvider viewProvider = this.myHostPsiFile.getViewProvider();
        this.myHostVirtualFile = viewProvider.getVirtualFile();
        this.myHostDocument = (DocumentEx)viewProvider.getDocument();
    }

    @Override
    @Deprecated
    @Nullable(value="null means nobody cared to call .doneInjecting()")
    public List<Pair<Place, PsiFile>> getResult() {
        return this.resultFiles == null ? null : this.resultFiles.stream().map(file2 -> Pair.create((Object)((Object)InjectedLanguageUtil.getShreds(file2)), (Object)file2)).collect(Collectors.toList());
    }

    @Nullable
    InjectionResult getInjectedResult() {
        return this.resultFiles == null && this.resultReferences == null ? null : new InjectionResult(this.resultFiles, this.resultReferences);
    }

    @Override
    @NotNull
    public MultiHostRegistrar startInjecting(@NotNull Language language) {
        if (language == null) {
            InjectionRegistrarImpl.$$$reportNull$$$0(3);
        }
        MultiHostRegistrar multiHostRegistrar = this.startInjecting(language, null);
        if (multiHostRegistrar == null) {
            InjectionRegistrarImpl.$$$reportNull$$$0(4);
        }
        return multiHostRegistrar;
    }

    @NotNull
    public MultiHostRegistrar startInjecting(@NotNull Language language, @Nullable String extension) {
        if (language == null) {
            InjectionRegistrarImpl.$$$reportNull$$$0(5);
        }
        this.fileExtension = extension;
        this.placeInfos = new SmartList();
        if (!this.cleared) {
            this.clear();
            throw new IllegalStateException("Seems you haven't called doneInjecting()");
        }
        this.currentThread = Thread.currentThread();
        if (LanguageParserDefinitions.INSTANCE.forLanguage(language) == null) {
            throw new UnsupportedOperationException("Cannot inject language '" + language + "' because it has no ParserDefinition");
        }
        this.myLanguage = language;
        InjectionRegistrarImpl injectionRegistrarImpl = this;
        if (injectionRegistrarImpl == null) {
            InjectionRegistrarImpl.$$$reportNull$$$0(6);
        }
        return injectionRegistrarImpl;
    }

    private void clear() {
        this.fileExtension = null;
        this.myLanguage = null;
        this.cleared = true;
        this.placeInfos = null;
        this.currentThread = null;
    }

    @NotNull
    public MultiHostRegistrar addPlace(@NonNls @Nullable String prefix, @NonNls @Nullable String suffix, @NotNull PsiLanguageInjectionHost host, @NotNull TextRange rangeInsideHost) {
        if (host == null) {
            InjectionRegistrarImpl.$$$reportNull$$$0(7);
        }
        if (rangeInsideHost == null) {
            InjectionRegistrarImpl.$$$reportNull$$$0(8);
        }
        this.checkThreading();
        if (this.myLanguage == null) {
            this.clear();
            throw new IllegalStateException("Seems you haven't called startInjecting()");
        }
        PsiFile containingFile = PsiUtilCore.getTemplateLanguageFile((PsiElement)host);
        assert (containingFile == this.myHostPsiFile) : InjectionRegistrarImpl.exceptionContext("Trying to inject into foreign file: " + containingFile, this.myLanguage, this.myHostPsiFile, this.myHostVirtualFile, this.myHostDocument, this.placeInfos);
        TextRange hostTextRange = host.getTextRange();
        if (!hostTextRange.contains(rangeInsideHost.shiftRight(hostTextRange.getStartOffset()))) {
            this.clear();
            throw new IllegalArgumentException("rangeInsideHost must lie within host text range. rangeInsideHost:" + rangeInsideHost + "; host textRange:" + hostTextRange);
        }
        this.cleared = false;
        String nnPrefix = StringUtil.isEmpty((String)prefix) ? "" : prefix;
        String nnSuffix = StringUtil.isEmpty((String)suffix) ? "" : suffix;
        PlaceInfo info = new PlaceInfo(nnPrefix, nnSuffix, host, rangeInsideHost);
        this.placeInfos.add(info);
        InjectionRegistrarImpl injectionRegistrarImpl = this;
        if (injectionRegistrarImpl == null) {
            InjectionRegistrarImpl.$$$reportNull$$$0(9);
        }
        return injectionRegistrarImpl;
    }

    private void checkThreading() {
        if (this.currentThread != Thread.currentThread()) {
            throw new IllegalStateException("Wow, you must not start injecting in one thread (" + this.currentThread + ") but finish the other");
        }
    }

    private static void decode(@NotNull PlaceInfo info, @NotNull StringBuilder outChars) {
        if (info == null) {
            InjectionRegistrarImpl.$$$reportNull$$$0(10);
        }
        if (outChars == null) {
            InjectionRegistrarImpl.$$$reportNull$$$0(11);
        }
        int startOffset = outChars.length();
        outChars.append(info.prefix);
        LiteralTextEscaper<? extends PsiLanguageInjectionHost> textEscaper = info.myEscaper;
        TextRange relevantRange = info.getRelevantRangeInsideHost();
        if (relevantRange == null) {
            relevantRange = TextRange.from((int)textEscaper.getRelevantTextRange().getStartOffset(), (int)0);
        } else {
            int before = outChars.length();
            boolean decodeSuccessful = textEscaper.decode(relevantRange, outChars);
            int after = outChars.length();
            assert (after >= before) : "Escaper " + textEscaper + "(" + textEscaper.getClass() + ") must not mangle char buffer";
            if (!decodeSuccessful) {
                int offsetInHost = textEscaper.getOffsetInHost(outChars.length() - before, info.registeredRangeInsideHost);
                relevantRange = relevantRange.intersection((TextRange)new ProperTextRange(0, offsetInHost));
            }
        }
        outChars.append(info.suffix);
        int endOffset = outChars.length();
        info.rangeInDecodedPSI = new ProperTextRange(startOffset, endOffset);
        info.rangeInHostElement = relevantRange;
    }

    @NotNull
    private static ShredImpl createShred(@NotNull PlaceInfo info, @NotNull StringBuilder outChars, @NotNull PsiFile hostPsiFile) {
        if (info == null) {
            InjectionRegistrarImpl.$$$reportNull$$$0(12);
        }
        if (outChars == null) {
            InjectionRegistrarImpl.$$$reportNull$$$0(13);
        }
        if (hostPsiFile == null) {
            InjectionRegistrarImpl.$$$reportNull$$$0(14);
        }
        InjectionRegistrarImpl.decode(info, outChars);
        TextRange relevantRange = info.rangeInHostElement;
        TextRange hostTextRange = info.host.getTextRange();
        TextRange relevantRangeInHostFile = relevantRange.shiftRight(hostTextRange.getStartOffset());
        SmartPointerManagerImpl manager = (SmartPointerManagerImpl)SmartPointerManager.getInstance((Project)hostPsiFile.getProject());
        ShredImpl shredImpl = new ShredImpl(manager.createSmartPsiFileRangePointer(hostPsiFile, relevantRangeInHostFile, true), manager.createSmartPsiElementPointer(info.host, hostPsiFile, true), info.prefix, info.suffix, (TextRange)info.rangeInDecodedPSI, false, info.myEscaper.isOneLine());
        if (shredImpl == null) {
            InjectionRegistrarImpl.$$$reportNull$$$0(15);
        }
        return shredImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doneInjecting() {
        this.checkThreading();
        try {
            if (this.myLanguage == null) {
                throw new IllegalStateException("Seems you haven't called startInjecting()");
            }
            if (this.placeInfos.isEmpty()) {
                throw new IllegalStateException("Seems you haven't called addPlace()");
            }
            Language forcedLanguage = (Language)this.myContextElement.getUserData(InjectedFileViewProvider.LANGUAGE_FOR_INJECTED_COPY_KEY);
            InjectionRegistrarImpl.checkForCorrectContextElement(this.placeInfos, this.myContextElement, this.myLanguage, this.myHostPsiFile, this.myHostVirtualFile, this.myHostDocument);
            Object object = InjectedLanguageManagerImpl.ourInjectionPsiLock;
            synchronized (object) {
                PsiFile psiFile = InjectionRegistrarImpl.createInjectedFile(this.myLanguage, forcedLanguage, this.myHostDocument, this.myHostVirtualFile, this.myHostPsiFile, this.fileExtension, this.placeInfos);
                this.addFileToResults(psiFile);
                PsiDocumentManagerBase documentManager = (PsiDocumentManagerBase)PsiDocumentManager.getInstance((Project)this.myProject);
                DocumentWindowImpl documentWindow = (DocumentWindowImpl)documentManager.getDocument(psiFile);
                InjectionRegistrarImpl.assertEverythingIsAllright(documentManager, documentWindow, psiFile);
            }
        }
        finally {
            this.clear();
        }
    }

    private static void checkForCorrectContextElement(@NotNull List<PlaceInfo> placeInfos, @NotNull PsiElement contextElement, @NotNull Language language, @NotNull PsiFile hostPsiFile, @NotNull VirtualFile hostVirtualFile, @NotNull DocumentEx hostDocument) {
        if (placeInfos == null) {
            InjectionRegistrarImpl.$$$reportNull$$$0(16);
        }
        if (contextElement == null) {
            InjectionRegistrarImpl.$$$reportNull$$$0(17);
        }
        if (language == null) {
            InjectionRegistrarImpl.$$$reportNull$$$0(18);
        }
        if (hostPsiFile == null) {
            InjectionRegistrarImpl.$$$reportNull$$$0(19);
        }
        if (hostVirtualFile == null) {
            InjectionRegistrarImpl.$$$reportNull$$$0(20);
        }
        if (hostDocument == null) {
            InjectionRegistrarImpl.$$$reportNull$$$0(21);
        }
        boolean isAncestor = false;
        for (PlaceInfo info : placeInfos) {
            isAncestor |= PsiTreeUtil.isAncestor((PsiElement)contextElement, (PsiElement)info.host, (boolean)false);
        }
        assert (isAncestor) : InjectionRegistrarImpl.exceptionContext("Context element " + contextElement.getTextRange() + ": '" + contextElement + "';  must be the parent of at least one of injection hosts", language, hostPsiFile, hostVirtualFile, hostDocument, placeInfos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    private static PsiFile createInjectedFile(@NotNull Language language, @Nullable Language forcedLanguage, @NotNull DocumentEx hostDocument, @NotNull VirtualFile hostVirtualFile, @NotNull PsiFile hostPsiFile, @Nullable String injectedFileExtension, @NotNull List<PlaceInfo> placeInfos) {
        if (language == null) {
            InjectionRegistrarImpl.$$$reportNull$$$0(22);
        }
        if (hostDocument == null) {
            InjectionRegistrarImpl.$$$reportNull$$$0(23);
        }
        if (hostVirtualFile == null) {
            InjectionRegistrarImpl.$$$reportNull$$$0(24);
        }
        if (hostPsiFile == null) {
            InjectionRegistrarImpl.$$$reportNull$$$0(25);
        }
        if (placeInfos == null) {
            InjectionRegistrarImpl.$$$reportNull$$$0(26);
        }
        Project project = hostPsiFile.getProject();
        PsiDocumentManagerBase documentManager = (PsiDocumentManagerBase)PsiDocumentManager.getInstance((Project)project);
        StringBuilder decodedChars = new StringBuilder();
        Place place = new Place();
        for (PlaceInfo info : placeInfos) {
            ShredImpl shred = InjectionRegistrarImpl.createShred(info, decodedChars, hostPsiFile);
            place.add(shred);
            info.hostSmartPointer = shred.getSmartPointer();
        }
        Object object = InjectedLanguageManagerImpl.ourInjectionPsiLock;
        // MONITORENTER : object
        DocumentWindowImpl documentWindow = new DocumentWindowImpl(hostDocument, place);
        String fileName = PathUtil.makeFileName((String)hostVirtualFile.getName(), (String)injectedFileExtension);
        ASTNode parsedNode = InjectionRegistrarImpl.parseFile(language, forcedLanguage, documentWindow, hostVirtualFile, hostDocument, hostPsiFile, project, documentWindow.getText(), placeInfos, decodedChars, fileName);
        PsiFile psiFile2 = (PsiFile)parsedNode.getPsi();
        InjectedFileViewProvider viewProvider = (InjectedFileViewProvider)psiFile2.getViewProvider();
        SmartPsiElementPointer<PsiLanguageInjectionHost> pointer = ((ShredImpl)place.get(0)).getSmartPointer();
        InjectionRegistrarImpl.cacheEverything(place, documentWindow, viewProvider, psiFile2, pointer, documentManager);
        PsiFile cachedPsiFile = documentManager.getCachedPsiFile(documentWindow);
        assert (cachedPsiFile == psiFile2) : "Cached psi :" + cachedPsiFile + " instead of " + psiFile2;
        assert (place.isValid());
        assert (viewProvider.isValid());
        PsiFile newFile = InjectionRegistrarImpl.registerDocument(documentWindow, psiFile2, place, hostPsiFile, documentManager);
        boolean mergeHappened = newFile != psiFile2;
        Place mergedPlace = place;
        if (mergeHappened) {
            boolean shredsReused;
            InjectedLanguageUtil.clearCaches(psiFile2, documentWindow);
            psiFile2 = newFile;
            viewProvider = (InjectedFileViewProvider)psiFile2.getViewProvider();
            documentWindow = (DocumentWindowImpl)viewProvider.getDocument();
            boolean bl = shredsReused = !InjectionRegistrarImpl.cacheEverything(place, documentWindow, viewProvider, psiFile2, pointer, documentManager);
            if (shredsReused) {
                place.dispose();
                mergedPlace = documentWindow.getShreds();
            }
        }
        assert (psiFile2.isValid());
        assert (mergedPlace.isValid());
        assert (viewProvider.isValid());
        PsiFile psiFile = psiFile2;
        // MONITOREXIT : object
        if (psiFile != null) return psiFile;
        InjectionRegistrarImpl.$$$reportNull$$$0(27);
        return psiFile;
    }

    private static void patchLeaves(@NotNull List<PlaceInfo> placeInfos, @NotNull InjectedFileViewProvider viewProvider, @NotNull ASTNode parsedNode, @NotNull CharSequence documentText) throws PatchException {
        if (placeInfos == null) {
            InjectionRegistrarImpl.$$$reportNull$$$0(28);
        }
        if (viewProvider == null) {
            InjectionRegistrarImpl.$$$reportNull$$$0(29);
        }
        if (parsedNode == null) {
            InjectionRegistrarImpl.$$$reportNull$$$0(30);
        }
        if (documentText == null) {
            InjectionRegistrarImpl.$$$reportNull$$$0(31);
        }
        viewProvider.doNotInterruptMeWhileImPatchingLeaves(() -> {
            if (placeInfos == null) {
                InjectionRegistrarImpl.$$$reportNull$$$0(105);
            }
            if (parsedNode == null) {
                InjectionRegistrarImpl.$$$reportNull$$$0(106);
            }
            LeafPatcher patcher = new LeafPatcher(placeInfos, parsedNode.getTextLength());
            patcher.patch(parsedNode, placeInfos);
        });
        if (!((FileElement)parsedNode).textMatches(documentText)) {
            throw new PatchException("After patch: doc:\n'" + documentText + "'\n---PSI:\n'" + parsedNode.getText());
        }
    }

    void injectReference(@NotNull Language language, @NotNull String prefix, @NotNull String suffix, @NotNull PsiLanguageInjectionHost host, @NotNull TextRange rangeInsideHost) {
        ParserDefinition parser;
        if (language == null) {
            InjectionRegistrarImpl.$$$reportNull$$$0(32);
        }
        if (prefix == null) {
            InjectionRegistrarImpl.$$$reportNull$$$0(33);
        }
        if (suffix == null) {
            InjectionRegistrarImpl.$$$reportNull$$$0(34);
        }
        if (host == null) {
            InjectionRegistrarImpl.$$$reportNull$$$0(35);
        }
        if (rangeInsideHost == null) {
            InjectionRegistrarImpl.$$$reportNull$$$0(36);
        }
        if ((parser = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(language)) != null) {
            throw new IllegalArgumentException("Language " + language + " being injected as reference must not have ParserDefinition and yet - " + parser);
        }
        ReferenceInjector injector = ReferenceInjector.findById((String)language.getID());
        if (injector == null) {
            throw new IllegalArgumentException("Language " + language + " being injected as reference must register reference injector");
        }
        this.placeInfos = new SmartList();
        if (!this.cleared) {
            this.clear();
            throw new IllegalStateException("Seems you haven't called doneInjecting()");
        }
        this.myLanguage = language;
        this.currentThread = Thread.currentThread();
        this.addPlace(prefix, suffix, host, rangeInsideHost);
        Place place = new Place();
        StringBuilder decodedChars = new StringBuilder();
        ShredImpl shred = InjectionRegistrarImpl.createShred(this.placeInfos.get(0), decodedChars, this.myHostPsiFile);
        place.add(shred);
        if (this.resultReferences == null) {
            this.resultReferences = new SmartList();
        }
        this.resultReferences.add((Pair<ReferenceInjector, Place>)Pair.create((Object)injector, (Object)((Object)place)));
        this.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean cacheEverything(@NotNull Place place, @NotNull DocumentWindowImpl documentWindow, @NotNull InjectedFileViewProvider viewProvider, @NotNull PsiFile psiFile, @NotNull SmartPsiElementPointer<PsiLanguageInjectionHost> pointer, @NotNull PsiDocumentManagerBase documentManager) {
        if (place == null) {
            InjectionRegistrarImpl.$$$reportNull$$$0(37);
        }
        if (documentWindow == null) {
            InjectionRegistrarImpl.$$$reportNull$$$0(38);
        }
        if (viewProvider == null) {
            InjectionRegistrarImpl.$$$reportNull$$$0(39);
        }
        if (psiFile == null) {
            InjectionRegistrarImpl.$$$reportNull$$$0(40);
        }
        if (pointer == null) {
            InjectionRegistrarImpl.$$$reportNull$$$0(41);
        }
        if (documentManager == null) {
            InjectionRegistrarImpl.$$$reportNull$$$0(42);
        }
        FileDocumentManagerImpl.registerDocument(documentWindow, viewProvider.getVirtualFile());
        DebugUtil.startPsiModification("MultiHostRegistrar cacheEverything");
        try {
            viewProvider.forceCachedPsi(psiFile);
        }
        finally {
            DebugUtil.finishPsiModification();
        }
        psiFile.putUserData(FileContextUtil.INJECTED_IN_ELEMENT, pointer);
        documentManager.associatePsi(documentWindow, psiFile);
        InjectionRegistrarImpl.keepTreeFromChameleoningBack(psiFile);
        return viewProvider.setShreds(place);
    }

    @NonNls
    private static String exceptionContext(@NonNls @NotNull String msg, @NotNull Language language, @NotNull PsiFile hostPsiFile, @NotNull VirtualFile hostVirtualFile, @NotNull DocumentEx hostDocument, @NotNull List<PlaceInfo> placeInfos) {
        if (msg == null) {
            InjectionRegistrarImpl.$$$reportNull$$$0(43);
        }
        if (language == null) {
            InjectionRegistrarImpl.$$$reportNull$$$0(44);
        }
        if (hostPsiFile == null) {
            InjectionRegistrarImpl.$$$reportNull$$$0(45);
        }
        if (hostVirtualFile == null) {
            InjectionRegistrarImpl.$$$reportNull$$$0(46);
        }
        if (hostDocument == null) {
            InjectionRegistrarImpl.$$$reportNull$$$0(47);
        }
        if (placeInfos == null) {
            InjectionRegistrarImpl.$$$reportNull$$$0(48);
        }
        return msg + ".\nOK let's see. Host file: " + hostPsiFile + " in '" + hostVirtualFile.getPresentableUrl() + "' (" + hostPsiFile.getLanguage() + ") " + (PsiDocumentManager.getInstance((Project)hostPsiFile.getProject()).isUncommited((Document)hostDocument) ? " (uncommitted)" : "") + "\nWas injected " + language + " at ranges: " + placeInfos;
    }

    private static ASTNode keepTreeFromChameleoningBack(PsiFile psiFile) {
        FileASTNode node = psiFile.getNode();
        ASTNode child = node.getFirstChildNode();
        assert (!TreeUtil.isCollapsedChameleon((ASTNode)node)) : "Chameleon " + node + " is collapsed; file: " + psiFile + "; language: " + psiFile.getLanguage();
        psiFile.putUserData(TREE_HARD_REF, (Object)node);
        if (child == null) assert (node != null);
        return node;
    }

    private static void assertEverythingIsAllright(@NotNull PsiDocumentManagerBase documentManager, @NotNull DocumentWindowImpl documentWindow, @NotNull PsiFile psiFile) {
        if (documentManager == null) {
            InjectionRegistrarImpl.$$$reportNull$$$0(49);
        }
        if (documentWindow == null) {
            InjectionRegistrarImpl.$$$reportNull$$$0(50);
        }
        if (psiFile == null) {
            InjectionRegistrarImpl.$$$reportNull$$$0(51);
        }
        InjectedFileViewProvider injectedFileViewProvider = (InjectedFileViewProvider)psiFile.getViewProvider();
        assert (injectedFileViewProvider.isValid()) : "Invalid view provider: " + injectedFileViewProvider;
        DocumentEx frozenWindow = documentManager.getLastCommittedDocument(documentWindow);
        assert (psiFile.textMatches((CharSequence)frozenWindow.getText())) : "Document window text mismatch";
        assert (injectedFileViewProvider.getDocument() == documentWindow) : "Provider document mismatch";
        assert (documentManager.getCachedDocument(psiFile) == documentWindow) : "Cached document mismatch";
        assert (Comparing.equal((Object)psiFile.getVirtualFile(), (Object)injectedFileViewProvider.getVirtualFile())) : "Virtual file mismatch: " + psiFile.getVirtualFile() + "; " + injectedFileViewProvider.getVirtualFile();
        PsiDocumentManagerBase.checkConsistency(psiFile, frozenWindow);
    }

    void addToResults(@NotNull InjectionResult result2) {
        if (result2 == null) {
            InjectionRegistrarImpl.$$$reportNull$$$0(52);
        }
        if (result2.files != null) {
            for (PsiFile psiFile : result2.files) {
                this.addFileToResults(psiFile);
            }
        }
        if (result2.references != null) {
            for (Pair pair : result2.references) {
                this.addReferenceToResults((Pair<ReferenceInjector, Place>)pair);
            }
        }
    }

    private void addFileToResults(@NotNull PsiFile psiFile) {
        if (psiFile == null) {
            InjectionRegistrarImpl.$$$reportNull$$$0(53);
        }
        if (this.resultFiles == null) {
            this.resultFiles = new SmartList();
        }
        this.resultFiles.add(psiFile);
    }

    private void addReferenceToResults(@NotNull Pair<ReferenceInjector, Place> pair) {
        if (pair == null) {
            InjectionRegistrarImpl.$$$reportNull$$$0(54);
        }
        if (this.resultReferences == null) {
            this.resultReferences = new SmartList();
        }
        this.resultReferences.add(pair);
    }

    @NotNull
    private static PsiFile registerDocument(@NotNull DocumentWindowImpl newDocumentWindow, @NotNull PsiFile newInjectedPsi, @NotNull Place shreds, @NotNull PsiFile hostPsiFile, @NotNull PsiDocumentManager documentManager) {
        if (newDocumentWindow == null) {
            InjectionRegistrarImpl.$$$reportNull$$$0(55);
        }
        if (newInjectedPsi == null) {
            InjectionRegistrarImpl.$$$reportNull$$$0(56);
        }
        if (shreds == null) {
            InjectionRegistrarImpl.$$$reportNull$$$0(57);
        }
        if (hostPsiFile == null) {
            InjectionRegistrarImpl.$$$reportNull$$$0(58);
        }
        if (documentManager == null) {
            InjectionRegistrarImpl.$$$reportNull$$$0(59);
        }
        ConcurrentList<DocumentWindow> injected = InjectedLanguageUtil.getCachedInjectedDocuments(hostPsiFile);
        for (int i = injected.size() - 1; i >= 0; --i) {
            FileViewProvider viewProvider;
            DocumentWindowImpl oldDocument = (DocumentWindowImpl)injected.get(i);
            PsiFileImpl oldFile = (PsiFileImpl)documentManager.getCachedPsiFile((Document)oldDocument);
            if (oldFile == null || !oldFile.isValid() || !((viewProvider = oldFile.getViewProvider()) instanceof InjectedFileViewProvider) || ((InjectedFileViewProvider)viewProvider).isDisposed()) {
                injected.remove(i);
                Disposer.dispose((Disposable)oldDocument);
                continue;
            }
            FileASTNode newInjectedNode = newInjectedPsi.getNode();
            FileASTNode oldFileNode = oldFile.getNode();
            assert (newInjectedNode != null) : "New node is null";
            if (oldDocument.areRangesEqual(newDocumentWindow)) {
                if (oldFile.getFileType() != newInjectedPsi.getFileType() || oldFile.getLanguage() != newInjectedPsi.getLanguage()) {
                    injected.remove(i);
                    Disposer.dispose((Disposable)oldDocument);
                    continue;
                }
                oldFile.putUserData(FileContextUtil.INJECTED_IN_ELEMENT, newInjectedPsi.getUserData(FileContextUtil.INJECTED_IN_ELEMENT));
                assert (shreds.isValid());
                InjectionRegistrarImpl.mergePsi(oldFile, (ASTNode)oldFileNode, newInjectedPsi, (ASTNode)newInjectedNode);
                assert (shreds.isValid());
                PsiFileImpl psiFileImpl = oldFile;
                if (psiFileImpl == null) {
                    InjectionRegistrarImpl.$$$reportNull$$$0(60);
                }
                return psiFileImpl;
            }
            if (!InjectionRegistrarImpl.intersect(oldDocument, newDocumentWindow)) continue;
            injected.remove(i);
        }
        injected.add(newDocumentWindow);
        PsiFile psiFile = newInjectedPsi;
        if (psiFile == null) {
            InjectionRegistrarImpl.$$$reportNull$$$0(61);
        }
        return psiFile;
    }

    private static void mergePsi(@NotNull PsiFile oldFile, @NotNull ASTNode oldFileNode, @NotNull PsiFile injectedPsi, @NotNull ASTNode injectedNode) {
        if (oldFile == null) {
            InjectionRegistrarImpl.$$$reportNull$$$0(62);
        }
        if (oldFileNode == null) {
            InjectionRegistrarImpl.$$$reportNull$$$0(63);
        }
        if (injectedPsi == null) {
            InjectionRegistrarImpl.$$$reportNull$$$0(64);
        }
        if (injectedNode == null) {
            InjectionRegistrarImpl.$$$reportNull$$$0(65);
        }
        if (!oldFile.textMatches((PsiElement)injectedPsi)) {
            InjectedFileViewProvider oldViewProvider = (InjectedFileViewProvider)oldFile.getViewProvider();
            oldViewProvider.performNonPhysically(() -> {
                if (oldFile == null) {
                    InjectionRegistrarImpl.$$$reportNull$$$0(102);
                }
                if (oldFileNode == null) {
                    InjectionRegistrarImpl.$$$reportNull$$$0(103);
                }
                if (injectedNode == null) {
                    InjectionRegistrarImpl.$$$reportNull$$$0(104);
                }
                DebugUtil.startPsiModification("injected tree diff");
                try {
                    DiffLog diffLog = BlockSupportImpl.mergeTrees((PsiFileImpl)oldFile, oldFileNode, injectedNode, new DaemonProgressIndicator(), oldFileNode.getText());
                    DocumentCommitThread.doActualPsiChange(oldFile, diffLog);
                }
                finally {
                    DebugUtil.finishPsiModification();
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static BooleanRunnable reparse(@NotNull Language language, @NotNull DocumentWindowImpl oldDocumentWindow, @NotNull PsiFile oldInjectedPsi, @NotNull VirtualFileWindow oldInjectedVirtualFile, @NotNull VirtualFile hostVirtualFile, @NotNull PsiFile hostPsiFile, @NotNull ProgressIndicator indicator, @NotNull ASTNode oldRoot, @NotNull ASTNode newRoot) {
        if (language == null) {
            InjectionRegistrarImpl.$$$reportNull$$$0(66);
        }
        if (oldDocumentWindow == null) {
            InjectionRegistrarImpl.$$$reportNull$$$0(67);
        }
        if (oldInjectedPsi == null) {
            InjectionRegistrarImpl.$$$reportNull$$$0(68);
        }
        if (oldInjectedVirtualFile == null) {
            InjectionRegistrarImpl.$$$reportNull$$$0(69);
        }
        if (hostVirtualFile == null) {
            InjectionRegistrarImpl.$$$reportNull$$$0(70);
        }
        if (hostPsiFile == null) {
            InjectionRegistrarImpl.$$$reportNull$$$0(71);
        }
        if (indicator == null) {
            InjectionRegistrarImpl.$$$reportNull$$$0(72);
        }
        if (oldRoot == null) {
            InjectionRegistrarImpl.$$$reportNull$$$0(73);
        }
        if (newRoot == null) {
            InjectionRegistrarImpl.$$$reportNull$$$0(74);
        }
        Object object = InjectedLanguageManagerImpl.ourInjectionPsiLock;
        synchronized (object) {
            Project project = hostPsiFile.getProject();
            String newText = oldDocumentWindow.getText();
            FileASTNode oldNode = oldInjectedPsi.getNode();
            InjectedFileViewProvider oldInjectedPsiViewProvider = (InjectedFileViewProvider)oldInjectedPsi.getViewProvider();
            String oldPsiText = oldNode.getText();
            if (newText.equals(oldPsiText)) {
                return () -> true;
            }
            if (oldDocumentWindow.isOneLine() && newText.contains("\n") != oldPsiText.contains("\n")) {
                return null;
            }
            Place oldPlace = oldDocumentWindow.getShreds();
            StringBuilder newDocumentText = new StringBuilder(newText.length());
            SmartList placeInfos = new SmartList();
            StringBuilder chars = new StringBuilder();
            Iterator iterator = oldPlace.iterator();
            while (iterator.hasNext()) {
                PsiLanguageInjectionHost.Shred shred = (PsiLanguageInjectionHost.Shred)iterator.next();
                PsiLanguageInjectionHost oldHost = shred.getHost();
                if (oldHost == null) {
                    return null;
                }
                SmartPsiElementPointer<PsiLanguageInjectionHost> hostPointer = ((ShredImpl)shred).getSmartPointer();
                Segment hostRangeMarker = InjectionRegistrarImpl.calcActualRange(hostPointer, oldDocumentWindow.getDelegate());
                if (hostRangeMarker == null) {
                    return null;
                }
                PsiLanguageInjectionHost newDummyInjectionHost = InjectionRegistrarImpl.findNewInjectionHost(hostPsiFile, oldRoot, newRoot, oldHost, hostRangeMarker);
                if (newDummyInjectionHost == null) {
                    return null;
                }
                Segment hostInjectionRange = shred.getHostRangeMarker();
                if (hostInjectionRange == null) {
                    return null;
                }
                TextRange rangeInsideHost = TextRange.create((Segment)hostInjectionRange).shiftLeft(hostRangeMarker.getStartOffset());
                PlaceInfo info = new PlaceInfo(shred.getPrefix(), shred.getSuffix(), newDummyInjectionHost, rangeInsideHost);
                placeInfos.add(info);
                info.hostSmartPointer = hostPointer;
                InjectionRegistrarImpl.decode(info, chars);
                TextRange rangeInHostElementPSI = info.rangeInHostElement;
                newDocumentText.append(shred.getPrefix());
                newDocumentText.append(newDummyInjectionHost.getText(), rangeInHostElementPSI.getStartOffset(), rangeInHostElementPSI.getEndOffset());
                newDocumentText.append(shred.getSuffix());
            }
            PsiDocumentManagerBase documentManager = (PsiDocumentManagerBase)PsiDocumentManager.getInstance((Project)project);
            DocumentEx hostDocument = oldDocumentWindow.getDelegate();
            assert (documentManager.isUncommited(hostDocument));
            String fileName = ((VirtualFileWindowImpl)oldInjectedVirtualFile).getName();
            ASTNode parsedNode = InjectionRegistrarImpl.parseFile(language, language, oldDocumentWindow, hostVirtualFile, hostDocument, hostPsiFile, project, newDocumentText, (List<PlaceInfo>)placeInfos, chars, fileName);
            DiffLog diffLog = BlockSupportImpl.mergeTrees((PsiFileImpl)oldInjectedPsi, (ASTNode)oldNode, parsedNode, indicator, oldPsiText);
            return () -> InjectionRegistrarImpl.lambda$reparse$5(oldInjectedPsiViewProvider, oldInjectedPsi, diffLog, project, oldPlace, (List)placeInfos, oldDocumentWindow, newText, newDocumentText);
        }
    }

    private static Segment calcActualRange(SmartPsiElementPointer<PsiLanguageInjectionHost> pointer, Document document) {
        PsiFile containingFile = pointer.getContainingFile();
        return SelfElementInfo.calcActualRangeAfterDocumentEvents(containingFile, document, pointer.getPsiRange(), true);
    }

    @NotNull
    private static ASTNode parseFile(@NotNull Language language, Language forcedLanguage, @NotNull DocumentWindowImpl documentWindow, @NotNull VirtualFile hostVirtualFile, @NotNull DocumentEx hostDocument, @NotNull PsiFile hostPsiFile, @NotNull Project project, @NotNull CharSequence documentText, @NotNull List<PlaceInfo> placeInfos, @NotNull StringBuilder decodedChars, @NotNull String fileName) {
        if (language == null) {
            InjectionRegistrarImpl.$$$reportNull$$$0(75);
        }
        if (documentWindow == null) {
            InjectionRegistrarImpl.$$$reportNull$$$0(76);
        }
        if (hostVirtualFile == null) {
            InjectionRegistrarImpl.$$$reportNull$$$0(77);
        }
        if (hostDocument == null) {
            InjectionRegistrarImpl.$$$reportNull$$$0(78);
        }
        if (hostPsiFile == null) {
            InjectionRegistrarImpl.$$$reportNull$$$0(79);
        }
        if (project == null) {
            InjectionRegistrarImpl.$$$reportNull$$$0(80);
        }
        if (documentText == null) {
            InjectionRegistrarImpl.$$$reportNull$$$0(81);
        }
        if (placeInfos == null) {
            InjectionRegistrarImpl.$$$reportNull$$$0(82);
        }
        if (decodedChars == null) {
            InjectionRegistrarImpl.$$$reportNull$$$0(83);
        }
        if (fileName == null) {
            InjectionRegistrarImpl.$$$reportNull$$$0(84);
        }
        VirtualFileWindowImpl virtualFile = new VirtualFileWindowImpl(fileName, hostVirtualFile, documentWindow, language, decodedChars);
        Language finalLanguage = forcedLanguage == null ? LanguageSubstitutors.INSTANCE.substituteLanguage(language, (VirtualFile)virtualFile, project) : forcedLanguage;
        InjectedFileViewProvider viewProvider = new InjectedFileViewProvider(PsiManager.getInstance((Project)project), virtualFile, documentWindow, finalLanguage);
        ParserDefinition parserDefinition = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(finalLanguage);
        assert (parserDefinition != null) : "Parser definition for language " + finalLanguage + " is null";
        PsiFile psiFile = parserDefinition.createFile((FileViewProvider)viewProvider);
        ASTNode parsedNode = InjectionRegistrarImpl.keepTreeFromChameleoningBack(psiFile);
        assert (parsedNode instanceof FileElement) : "Parsed to " + parsedNode + " instead of FileElement";
        assert (((FileElement)parsedNode).textMatches(decodedChars)) : InjectionRegistrarImpl.exceptionContext("Before patch: doc:\n'" + documentText + "'\n---PSI:\n'" + parsedNode.getText() + "'\n---chars:\n'" + decodedChars + "'", finalLanguage, hostPsiFile, hostVirtualFile, hostDocument, placeInfos);
        try {
            InjectionRegistrarImpl.patchLeaves(placeInfos, viewProvider, parsedNode, documentText);
        }
        catch (PatchException e) {
            throw new RuntimeException(InjectionRegistrarImpl.exceptionContext(e.getMessage() + "'\n---chars:\n'" + decodedChars + "'", finalLanguage, hostPsiFile, hostVirtualFile, hostDocument, placeInfos));
        }
        virtualFile.setContent(null, decodedChars, false);
        virtualFile.setWritable(virtualFile.getDelegate().isWritable());
        try {
            List<Trinity<IElementType, SmartPsiElementPointer<PsiLanguageInjectionHost>, TextRange>> tokens = InjectionRegistrarImpl.obtainHighlightTokensFromLexer(language, decodedChars, virtualFile, project, placeInfos);
            psiFile.putUserData(InjectedLanguageUtil.HIGHLIGHT_TOKENS, tokens);
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw new RuntimeException(InjectionRegistrarImpl.exceptionContext("Obtaining tokens error", language, hostPsiFile, hostVirtualFile, hostDocument, placeInfos), e);
        }
        ASTNode aSTNode = parsedNode;
        if (aSTNode == null) {
            InjectionRegistrarImpl.$$$reportNull$$$0(85);
        }
        return aSTNode;
    }

    private static PsiLanguageInjectionHost findNewInjectionHost(@NotNull PsiFile hostPsiFile, @NotNull ASTNode oldRoot, @NotNull ASTNode newRoot, @NotNull PsiLanguageInjectionHost oldInjectionHost, @NotNull Segment newInjectionHostRange) {
        int endToLook;
        int startToLook;
        PsiFile toLookIn;
        if (hostPsiFile == null) {
            InjectionRegistrarImpl.$$$reportNull$$$0(86);
        }
        if (oldRoot == null) {
            InjectionRegistrarImpl.$$$reportNull$$$0(87);
        }
        if (newRoot == null) {
            InjectionRegistrarImpl.$$$reportNull$$$0(88);
        }
        if (oldInjectionHost == null) {
            InjectionRegistrarImpl.$$$reportNull$$$0(89);
        }
        if (newInjectionHostRange == null) {
            InjectionRegistrarImpl.$$$reportNull$$$0(90);
        }
        TextRange oldRootRange = oldRoot.getTextRange();
        TextRange newRootRange = newRoot.getTextRange();
        if (newInjectionHostRange.getEndOffset() <= oldRootRange.getStartOffset()) {
            toLookIn = hostPsiFile;
            startToLook = newInjectionHostRange.getStartOffset();
            endToLook = newInjectionHostRange.getEndOffset();
        } else if (newInjectionHostRange.getStartOffset() >= oldRootRange.getStartOffset() + newRootRange.getLength()) {
            toLookIn = hostPsiFile;
            startToLook = newInjectionHostRange.getStartOffset() + newRootRange.getLength() - oldRootRange.getLength();
            endToLook = newInjectionHostRange.getEndOffset() + newRootRange.getLength() - oldRootRange.getLength();
        } else {
            toLookIn = newRoot.getPsi();
            if (toLookIn instanceof PsiFile) {
                FileViewProvider viewProvider = toLookIn.getViewProvider();
                toLookIn = (PsiElement)ObjectUtils.notNull((Object)viewProvider.getPsi(hostPsiFile.getLanguage()), (Object)viewProvider.getPsi(viewProvider.getBaseLanguage()));
            }
            startToLook = newInjectionHostRange.getStartOffset() - oldRootRange.getStartOffset();
            endToLook = newInjectionHostRange.getEndOffset() - oldRootRange.getStartOffset();
        }
        Identikit.ByType kit = Identikit.fromPsi((PsiElement)oldInjectionHost, hostPsiFile.getLanguage());
        return (PsiLanguageInjectionHost)kit.findInside((PsiElement)toLookIn, startToLook, endToLook);
    }

    static boolean intersect(DocumentWindowImpl doc1, DocumentWindowImpl doc2) {
        Segment[] hostRanges1 = doc1.getHostRanges();
        Segment[] hostRanges2 = doc2.getHostRanges();
        for (Segment segment1 : hostRanges1) {
            for (Segment segment2 : hostRanges2) {
                if (Math.max(segment1.getStartOffset(), segment2.getStartOffset()) >= Math.min(segment1.getEndOffset(), segment2.getEndOffset())) continue;
                return true;
            }
        }
        return false;
    }

    @NotNull
    private static List<Trinity<IElementType, SmartPsiElementPointer<PsiLanguageInjectionHost>, TextRange>> obtainHighlightTokensFromLexer(@NotNull Language language, @NotNull CharSequence outChars, @NotNull VirtualFileWindow virtualFile, @NotNull Project project, @NotNull List<PlaceInfo> placeInfos) {
        if (language == null) {
            InjectionRegistrarImpl.$$$reportNull$$$0(91);
        }
        if (outChars == null) {
            InjectionRegistrarImpl.$$$reportNull$$$0(92);
        }
        if (virtualFile == null) {
            InjectionRegistrarImpl.$$$reportNull$$$0(93);
        }
        if (project == null) {
            InjectionRegistrarImpl.$$$reportNull$$$0(94);
        }
        if (placeInfos == null) {
            InjectionRegistrarImpl.$$$reportNull$$$0(95);
        }
        SyntaxHighlighter syntaxHighlighter = SyntaxHighlighterFactory.getSyntaxHighlighter((Language)language, (Project)project, (VirtualFile)((VirtualFile)virtualFile));
        Lexer lexer = syntaxHighlighter.getHighlightingLexer();
        lexer.start(outChars);
        int hostNum = -1;
        int prevHostEndOffset = 0;
        SmartPsiElementPointer<PsiLanguageInjectionHost> hostPtr = null;
        LiteralTextEscaper<? extends PsiLanguageInjectionHost> escaper = null;
        int prefixLength = 0;
        int suffixLength = 0;
        TextRange rangeInsideHost = null;
        int shredEndOffset = -1;
        ArrayList<Trinity<IElementType, SmartPsiElementPointer<PsiLanguageInjectionHost>, TextRange>> tokens = new ArrayList<Trinity<IElementType, SmartPsiElementPointer<PsiLanguageInjectionHost>, TextRange>>(10);
        IElementType tokenType = lexer.getTokenType();
        while (tokenType != null) {
            ProperTextRange range2 = new ProperTextRange(lexer.getTokenStart(), lexer.getTokenEnd());
            while (range2 != null && !range2.isEmpty()) {
                if (range2.getStartOffset() >= shredEndOffset) {
                    PlaceInfo info = placeInfos.get(++hostNum);
                    shredEndOffset = info.rangeInDecodedPSI.getEndOffset();
                    prevHostEndOffset = range2.getStartOffset();
                    hostPtr = info.hostSmartPointer;
                    escaper = info.myEscaper;
                    rangeInsideHost = info.rangeInHostElement;
                    prefixLength = info.prefix.length();
                    suffixLength = info.suffix.length();
                }
                if (range2.getStartOffset() < prevHostEndOffset + prefixLength) {
                    range2 = new UnfairTextRange(prevHostEndOffset + prefixLength, range2.getEndOffset());
                }
                UnfairTextRange spilled = null;
                if (range2.getEndOffset() > shredEndOffset - suffixLength) {
                    spilled = new UnfairTextRange(shredEndOffset, range2.getEndOffset());
                    range2 = new UnfairTextRange(range2.getStartOffset(), shredEndOffset - suffixLength);
                }
                if (!range2.isEmpty()) {
                    int end;
                    int start = escaper.getOffsetInHost(range2.getStartOffset() - prevHostEndOffset - prefixLength, rangeInsideHost);
                    if (start == -1) {
                        start = rangeInsideHost.getStartOffset();
                    }
                    if ((end = escaper.getOffsetInHost(range2.getEndOffset() - prevHostEndOffset - prefixLength, rangeInsideHost)) == -1) {
                        end = rangeInsideHost.getEndOffset();
                        prevHostEndOffset = shredEndOffset;
                    }
                    ProperTextRange rangeInHost = new ProperTextRange(start, end);
                    tokens.add((Trinity<IElementType, SmartPsiElementPointer<PsiLanguageInjectionHost>, TextRange>)Trinity.create((Object)tokenType, hostPtr, (Object)rangeInHost));
                }
                range2 = spilled;
            }
            lexer.advance();
            tokenType = lexer.getTokenType();
        }
        ArrayList<Trinity<IElementType, SmartPsiElementPointer<PsiLanguageInjectionHost>, TextRange>> arrayList = tokens;
        if (arrayList == null) {
            InjectionRegistrarImpl.$$$reportNull$$$0(96);
        }
        return arrayList;
    }

    public String toString() {
        return String.valueOf(this.resultFiles);
    }

    @NotNull
    PsiFile getHostPsiFile() {
        PsiFile psiFile = this.myHostPsiFile;
        if (psiFile == null) {
            InjectionRegistrarImpl.$$$reportNull$$$0(97);
        }
        return psiFile;
    }

    private static /* synthetic */ boolean lambda$reparse$5(InjectedFileViewProvider oldInjectedPsiViewProvider, @NotNull PsiFile oldInjectedPsi, DiffLog diffLog, Project project, Place oldPlace, List placeInfos, @NotNull DocumentWindowImpl oldDocumentWindow, String newText, StringBuilder newDocumentText) {
        if (oldInjectedPsi == null) {
            InjectionRegistrarImpl.$$$reportNull$$$0(98);
        }
        if (oldDocumentWindow == null) {
            InjectionRegistrarImpl.$$$reportNull$$$0(99);
        }
        oldInjectedPsiViewProvider.performNonPhysically(() -> {
            if (oldInjectedPsi == null) {
                InjectionRegistrarImpl.$$$reportNull$$$0(100);
            }
            if (oldDocumentWindow == null) {
                InjectionRegistrarImpl.$$$reportNull$$$0(101);
            }
            DebugUtil.startPsiModification("injected tree diff");
            try {
                DocumentCommitThread.doActualPsiChange(oldInjectedPsi, diffLog);
                PsiDocumentManagerBase documentManagerBase = (PsiDocumentManagerBase)PsiDocumentManager.getInstance((Project)project);
                Place newPlace = new Place();
                for (int i = 0; i < oldPlace.size(); ++i) {
                    PsiLanguageInjectionHost.Shred shred = (PsiLanguageInjectionHost.Shred)oldPlace.get(i);
                    PlaceInfo info = (PlaceInfo)placeInfos.get(i);
                    ProperTextRange rangeInDecodedPSI = info.rangeInDecodedPSI;
                    TextRange rangeInHostElementPSI = info.rangeInHostElement;
                    ShredImpl newShred = ((ShredImpl)shred).withRange((TextRange)rangeInDecodedPSI, rangeInHostElementPSI);
                    newPlace.add(newShred);
                }
                SmartPsiElementPointer<PsiLanguageInjectionHost> pointer = ((PlaceInfo)placeInfos.get((int)0)).hostSmartPointer;
                InjectionRegistrarImpl.cacheEverything(newPlace, oldDocumentWindow, oldInjectedPsiViewProvider, oldInjectedPsi, pointer, documentManagerBase);
                String docText = oldDocumentWindow.getText();
                assert (docText.equals(newText)) : "=\n" + docText + "\n==\n" + newDocumentText + "\n===\n";
            }
            finally {
                DebugUtil.finishPsiModification();
            }
        });
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 6: 
            case 9: 
            case 15: 
            case 27: 
            case 60: 
            case 61: 
            case 85: 
            case 96: 
            case 97: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 6: 
            case 9: 
            case 15: 
            case 27: 
            case 60: 
            case 61: 
            case 85: 
            case 96: 
            case 97: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 14: 
            case 19: 
            case 25: 
            case 45: 
            case 58: 
            case 71: 
            case 79: 
            case 86: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hostPsiFile";
                break;
            }
            case 2: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextElement";
                break;
            }
            case 3: 
            case 5: 
            case 18: 
            case 22: 
            case 32: 
            case 44: 
            case 66: 
            case 75: 
            case 91: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 4: 
            case 6: 
            case 9: 
            case 15: 
            case 27: 
            case 60: 
            case 61: 
            case 85: 
            case 96: 
            case 97: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/tree/injected/InjectionRegistrarImpl";
                break;
            }
            case 7: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "host";
                break;
            }
            case 8: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rangeInsideHost";
                break;
            }
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 11: 
            case 13: 
            case 92: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outChars";
                break;
            }
            case 16: 
            case 26: 
            case 28: 
            case 48: 
            case 82: 
            case 95: 
            case 105: {
                objectArray2 = objectArray3;
                objectArray3[0] = "placeInfos";
                break;
            }
            case 20: 
            case 24: 
            case 46: 
            case 70: 
            case 77: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hostVirtualFile";
                break;
            }
            case 21: 
            case 23: 
            case 47: 
            case 78: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hostDocument";
                break;
            }
            case 29: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "viewProvider";
                break;
            }
            case 30: 
            case 106: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parsedNode";
                break;
            }
            case 31: 
            case 81: {
                objectArray2 = objectArray3;
                objectArray3[0] = "documentText";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suffix";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 38: 
            case 50: 
            case 76: {
                objectArray2 = objectArray3;
                objectArray3[0] = "documentWindow";
                break;
            }
            case 40: 
            case 51: 
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pointer";
                break;
            }
            case 42: 
            case 49: 
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "documentManager";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "msg";
                break;
            }
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pair";
                break;
            }
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newDocumentWindow";
                break;
            }
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newInjectedPsi";
                break;
            }
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shreds";
                break;
            }
            case 62: 
            case 102: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldFile";
                break;
            }
            case 63: 
            case 103: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldFileNode";
                break;
            }
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "injectedPsi";
                break;
            }
            case 65: 
            case 104: {
                objectArray2 = objectArray3;
                objectArray3[0] = "injectedNode";
                break;
            }
            case 67: 
            case 99: 
            case 101: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldDocumentWindow";
                break;
            }
            case 68: 
            case 98: 
            case 100: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldInjectedPsi";
                break;
            }
            case 69: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldInjectedVirtualFile";
                break;
            }
            case 72: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 73: 
            case 87: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldRoot";
                break;
            }
            case 74: 
            case 88: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newRoot";
                break;
            }
            case 83: {
                objectArray2 = objectArray3;
                objectArray3[0] = "decodedChars";
                break;
            }
            case 84: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 89: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldInjectionHost";
                break;
            }
            case 90: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newInjectionHostRange";
                break;
            }
            case 93: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/tree/injected/InjectionRegistrarImpl";
                break;
            }
            case 4: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "startInjecting";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "addPlace";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "createShred";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "createInjectedFile";
                break;
            }
            case 60: 
            case 61: {
                objectArray = objectArray2;
                objectArray2[1] = "registerDocument";
                break;
            }
            case 85: {
                objectArray = objectArray2;
                objectArray2[1] = "parseFile";
                break;
            }
            case 96: {
                objectArray = objectArray2;
                objectArray2[1] = "obtainHighlightTokensFromLexer";
                break;
            }
            case 97: {
                objectArray = objectArray2;
                objectArray2[1] = "getHostPsiFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "startInjecting";
                break;
            }
            case 4: 
            case 6: 
            case 9: 
            case 15: 
            case 27: 
            case 60: 
            case 61: 
            case 85: 
            case 96: 
            case 97: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "addPlace";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "decode";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "createShred";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "checkForCorrectContextElement";
                break;
            }
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "createInjectedFile";
                break;
            }
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "patchLeaves";
                break;
            }
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "injectReference";
                break;
            }
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "cacheEverything";
                break;
            }
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "exceptionContext";
                break;
            }
            case 49: 
            case 50: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "assertEverythingIsAllright";
                break;
            }
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "addToResults";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "addFileToResults";
                break;
            }
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "addReferenceToResults";
                break;
            }
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "registerDocument";
                break;
            }
            case 62: 
            case 63: 
            case 64: 
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "mergePsi";
                break;
            }
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: {
                objectArray = objectArray;
                objectArray[2] = "reparse";
                break;
            }
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: {
                objectArray = objectArray;
                objectArray[2] = "parseFile";
                break;
            }
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: {
                objectArray = objectArray;
                objectArray[2] = "findNewInjectionHost";
                break;
            }
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: {
                objectArray = objectArray;
                objectArray[2] = "obtainHighlightTokensFromLexer";
                break;
            }
            case 98: 
            case 99: {
                objectArray = objectArray;
                objectArray[2] = "lambda$reparse$5";
                break;
            }
            case 100: 
            case 101: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$4";
                break;
            }
            case 102: 
            case 103: 
            case 104: {
                objectArray = objectArray;
                objectArray[2] = "lambda$mergePsi$2";
                break;
            }
            case 105: 
            case 106: {
                objectArray = objectArray;
                objectArray[2] = "lambda$patchLeaves$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 6: 
            case 9: 
            case 15: 
            case 27: 
            case 60: 
            case 61: 
            case 85: 
            case 96: 
            case 97: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class PatchException
    extends Exception {
        PatchException(String message) {
            super(message);
        }
    }
}

