/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.move;

import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiRecursiveElementVisitor;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceOwner;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.PsiFileReference;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.HashMap;
import java.util.Map;

public class FileReferenceContextUtil {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.refactoring.move.FileReferenceContextUtil");
    private static final Key<PsiFileSystemItem> REF_FILE_SYSTEM_ITEM_KEY = Key.create((String)"REF_FILE_SYSTEM_ITEM_KEY");

    private FileReferenceContextUtil() {
    }

    public static Map<String, PsiFileSystemItem> encodeFileReferences(PsiElement element) {
        HashMap map = new HashMap();
        if (element == null || element instanceof PsiCompiledElement || FileReferenceContextUtil.isBinary(element)) {
            return map;
        }
        element.accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(true, (Map)map){
            final /* synthetic */ Map val$map;
            {
                this.val$map = map;
                super(x0);
            }

            public void visitElement(PsiElement element) {
                PsiReference[] refs;
                if (element instanceof PsiLanguageInjectionHost && element.isValid()) {
                    InjectedLanguageManager.getInstance((Project)element.getProject()).enumerate(element, (injectedPsi, places) -> FileReferenceContextUtil.encodeFileReferences((PsiElement)injectedPsi));
                }
                for (PsiReference reference : refs = element.getReferences()) {
                    PsiFileReference ref;
                    PsiFileReference psiFileReference = ref = reference instanceof FileReferenceOwner ? ((FileReferenceOwner)reference).getLastFileReference() : null;
                    if (ref != null && FileReferenceContextUtil.encodeFileReference(element, ref, this.val$map)) break;
                }
                super.visitElement(element);
            }
        });
        return map;
    }

    private static boolean encodeFileReference(PsiElement element, PsiFileReference ref, Map<String, PsiFileSystemItem> map) {
        ResolveResult[] results;
        for (ResolveResult result2 : results = ref.multiResolve(false)) {
            if (!(result2.getElement() instanceof PsiFileSystemItem)) continue;
            PsiFileSystemItem fileSystemItem = (PsiFileSystemItem)result2.getElement();
            element.putCopyableUserData(REF_FILE_SYSTEM_ITEM_KEY, (Object)fileSystemItem);
            map.put(element.getText(), fileSystemItem);
            return true;
        }
        return false;
    }

    private static boolean isBinary(PsiElement element) {
        PsiFile containingFile = element.getContainingFile();
        return containingFile == null || containingFile.getFileType().isBinary();
    }

    public static void decodeFileReferences(PsiElement element) {
        if (element == null || element instanceof PsiCompiledElement || FileReferenceContextUtil.isBinary(element)) {
            return;
        }
        element.accept((PsiElementVisitor)new PsiRecursiveElementVisitor(true){

            public void visitElement(PsiElement element) {
                PsiFileSystemItem item = (PsiFileSystemItem)element.getCopyableUserData(REF_FILE_SYSTEM_ITEM_KEY);
                element.putCopyableUserData(REF_FILE_SYSTEM_ITEM_KEY, null);
                element = FileReferenceContextUtil.bindElement(element, item);
                if (element != null) {
                    element.acceptChildren((PsiElementVisitor)this);
                }
                if (element instanceof PsiLanguageInjectionHost) {
                    InjectedLanguageManager.getInstance((Project)element.getProject()).enumerate(element, (injectedPsi, places) -> FileReferenceContextUtil.decodeFileReferences((PsiElement)injectedPsi));
                }
            }
        });
    }

    public static void decodeFileReferences(PsiElement element, final Map<String, PsiFileSystemItem> map, final TextRange range2) {
        if (element == null || element instanceof PsiCompiledElement || FileReferenceContextUtil.isBinary(element)) {
            return;
        }
        element.accept((PsiElementVisitor)new PsiRecursiveElementVisitor(true){

            public void visitElement(PsiElement element) {
                if (!range2.intersects(element.getTextRange())) {
                    return;
                }
                String text = element.getText();
                PsiFileSystemItem item = (PsiFileSystemItem)map.get(text);
                element.putCopyableUserData(REF_FILE_SYSTEM_ITEM_KEY, (Object)item);
                element.acceptChildren((PsiElementVisitor)this);
            }
        });
        FileReferenceContextUtil.decodeFileReferences(element);
    }

    private static PsiElement bindElement(PsiElement element, PsiFileSystemItem item) {
        if (item != null && item.isValid() && item.getVirtualFile() != null) {
            PsiReference[] refs;
            for (PsiReference ref : refs = element.getReferences()) {
                if (!(ref instanceof FileReferenceOwner)) continue;
                PsiFileReference fileReference = ((FileReferenceOwner)ref).getLastFileReference();
                if (fileReference == null) break;
                try {
                    PsiElement newElement = fileReference.bindToElement((PsiElement)item);
                    if (newElement != null) {
                        LOG.assertTrue(element.getClass() == newElement.getClass(), (Object)("Reference " + ref + " violated contract of bindToElement()"));
                    }
                    return newElement;
                }
                catch (IncorrectOperationException e) {
                    LOG.error((Throwable)e);
                    break;
                }
            }
        }
        return element;
    }
}

