/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spellchecker.inspections;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.spellchecker.inspections.Splitter;
import com.intellij.util.Consumer;
import com.intellij.util.SmartList;
import java.text.StringCharacterIterator;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseSplitter
implements Splitter {
    public static final int MIN_RANGE_LENGTH = 3;

    protected static void addWord(@NotNull Consumer<TextRange> consumer, boolean ignore, @Nullable TextRange found) {
        boolean tooShort;
        if (consumer == null) {
            BaseSplitter.$$$reportNull$$$0(0);
        }
        if (found == null || ignore) {
            return;
        }
        boolean bl = tooShort = found.getEndOffset() - found.getStartOffset() <= 3;
        if (tooShort) {
            return;
        }
        consumer.consume((Object)found);
    }

    protected static boolean isAllWordsAreUpperCased(@NotNull String text, @NotNull List<TextRange> words) {
        if (text == null) {
            BaseSplitter.$$$reportNull$$$0(1);
        }
        if (words == null) {
            BaseSplitter.$$$reportNull$$$0(2);
        }
        for (TextRange word : words) {
            StringCharacterIterator it = new StringCharacterIterator(text, word.getStartOffset(), word.getEndOffset(), word.getStartOffset());
            char c = it.first();
            while (c != '\uffff') {
                if (!Character.isUpperCase(c)) {
                    return false;
                }
                c = it.next();
            }
        }
        return true;
    }

    protected static boolean containsShortWord(@NotNull List<TextRange> words) {
        if (words == null) {
            BaseSplitter.$$$reportNull$$$0(3);
        }
        for (TextRange word : words) {
            if (word.getLength() >= 3) continue;
            return true;
        }
        return false;
    }

    @NotNull
    protected static TextRange matcherRange(@NotNull TextRange range2, @NotNull Matcher matcher) {
        if (range2 == null) {
            BaseSplitter.$$$reportNull$$$0(4);
        }
        if (matcher == null) {
            BaseSplitter.$$$reportNull$$$0(5);
        }
        TextRange textRange = BaseSplitter.subRange(range2, matcher.start(), matcher.end());
        if (textRange == null) {
            BaseSplitter.$$$reportNull$$$0(6);
        }
        return textRange;
    }

    @NotNull
    protected static TextRange matcherRange(@NotNull TextRange range2, @NotNull Matcher matcher, int group) {
        if (range2 == null) {
            BaseSplitter.$$$reportNull$$$0(7);
        }
        if (matcher == null) {
            BaseSplitter.$$$reportNull$$$0(8);
        }
        TextRange textRange = BaseSplitter.subRange(range2, matcher.start(group), matcher.end(group));
        if (textRange == null) {
            BaseSplitter.$$$reportNull$$$0(9);
        }
        return textRange;
    }

    @NotNull
    protected static TextRange subRange(@NotNull TextRange range2, int start, int end) {
        if (range2 == null) {
            BaseSplitter.$$$reportNull$$$0(10);
        }
        TextRange textRange = TextRange.from((int)(range2.getStartOffset() + start), (int)(end - start));
        if (textRange == null) {
            BaseSplitter.$$$reportNull$$$0(11);
        }
        return textRange;
    }

    protected static boolean badSize(int from, int till) {
        int l = till - from;
        return l <= 3;
    }

    @NotNull
    protected static List<TextRange> excludeByPattern(String text, TextRange range2, @NotNull Pattern toExclude, int groupToInclude) {
        int till;
        boolean addLast;
        int from;
        SmartList toCheck;
        block12: {
            SmartList smartList;
            if (toExclude == null) {
                BaseSplitter.$$$reportNull$$$0(12);
            }
            toCheck = new SmartList();
            from = range2.getStartOffset();
            addLast = true;
            Matcher matcher = toExclude.matcher(StringUtil.newBombedCharSequence((CharSequence)range2.substring(text), (long)500L));
            try {
                while (matcher.find()) {
                    TextRange contentFound;
                    BaseSplitter.checkCancelled();
                    TextRange found = BaseSplitter.matcherRange(range2, matcher);
                    till = found.getStartOffset();
                    if (range2.getEndOffset() - found.getEndOffset() < 3) {
                        addLast = false;
                    }
                    if (!BaseSplitter.badSize(from, till)) {
                        toCheck.add(new TextRange(from, till));
                    }
                    if (groupToInclude > 0 && BaseSplitter.badSize((contentFound = BaseSplitter.matcherRange(range2, matcher, groupToInclude)).getEndOffset(), contentFound.getStartOffset())) {
                        toCheck.add(TextRange.create((Segment)contentFound));
                    }
                    from = found.getEndOffset();
                }
                till = range2.getEndOffset();
                if (!BaseSplitter.badSize(from, till)) break block12;
                smartList = toCheck;
            }
            catch (ProcessCanceledException e) {
                List<TextRange> list2 = Collections.singletonList(range2);
                if (list2 == null) {
                    BaseSplitter.$$$reportNull$$$0(15);
                }
                return list2;
            }
            if (smartList == null) {
                BaseSplitter.$$$reportNull$$$0(13);
            }
            return smartList;
        }
        if (addLast) {
            toCheck.add(new TextRange(from, till));
        }
        SmartList smartList = toCheck;
        if (smartList == null) {
            BaseSplitter.$$$reportNull$$$0(14);
        }
        return smartList;
    }

    public static void checkCancelled() {
        if (ApplicationManager.getApplication() != null) {
            ProgressIndicatorProvider.checkCanceled();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 9: 
            case 11: 
            case 13: 
            case 14: 
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 9: 
            case 11: 
            case 13: 
            case 14: 
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "words";
                break;
            }
            case 4: 
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "matcher";
                break;
            }
            case 6: 
            case 9: 
            case 11: 
            case 13: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spellchecker/inspections/BaseSplitter";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toExclude";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spellchecker/inspections/BaseSplitter";
                break;
            }
            case 6: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "matcherRange";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "subRange";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "excludeByPattern";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addWord";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isAllWordsAreUpperCased";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "containsShortWord";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "matcherRange";
                break;
            }
            case 6: 
            case 9: 
            case 11: 
            case 13: 
            case 14: 
            case 15: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "subRange";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "excludeByPattern";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 9: 
            case 11: 
            case 13: 
            case 14: 
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

