/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spellchecker.settings;

import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.spellchecker.settings.SpellCheckerSettings;
import com.intellij.spellchecker.util.SpellCheckerBundle;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.TableUtil;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.table.TableView;
import com.intellij.util.Consumer;
import com.intellij.util.PathUtil;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.ListTableModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.TableColumn;
import org.jetbrains.annotations.NotNull;

public class CustomDictionariesPanel
extends JPanel {
    private SpellCheckerSettings mySettings;
    private CustomDictionariesTableView myCustomDictionariesTableView;
    @NotNull
    private final Project myProject;
    private final List<String> removedDictionaries;

    public CustomDictionariesPanel(@NotNull SpellCheckerSettings settings, final @NotNull Project project) {
        if (settings == null) {
            CustomDictionariesPanel.$$$reportNull$$$0(0);
        }
        if (project == null) {
            CustomDictionariesPanel.$$$reportNull$$$0(1);
        }
        this.removedDictionaries = new ArrayList<String>();
        this.mySettings = settings;
        this.myCustomDictionariesTableView = new CustomDictionariesTableView(new ArrayList<String>(settings.getCustomDictionariesPaths()), new ArrayList<String>(settings.getDisabledDictionariesPaths()));
        this.myProject = project;
        ToolbarDecorator decorator = ToolbarDecorator.createDecorator((JTable)((Object)this.myCustomDictionariesTableView)).setAddActionName(SpellCheckerBundle.message("add.custom.dictionaries", new Object[0])).setAddAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                CustomDictionariesPanel.this.myCustomDictionariesTableView.stopEditing();
                CustomDictionariesPanel.this.doChooseFiles(project, (Consumer<List<VirtualFile>>)files -> files.stream().map(VirtualFile::getPath).map(PathUtil::toSystemDependentName).filter(path -> !CustomDictionariesPanel.this.myCustomDictionariesTableView.getItems().contains(path)).forEach(path -> CustomDictionariesPanel.this.myCustomDictionariesTableView.getListTableModel().addRow(path)));
            }
        }).setRemoveActionName(SpellCheckerBundle.message("remove.custom.dictionaries", new Object[0])).setRemoveAction(button -> {
            this.removedDictionaries.addAll(this.myCustomDictionariesTableView.getSelectedObjects());
            TableUtil.removeSelectedItems((JTable)((Object)this.myCustomDictionariesTableView));
        }).setEditActionName(SpellCheckerBundle.message("edit.custom.dictionary", new Object[0])).setEditAction(new AnActionButtonRunnable(){

            public void run(AnActionButton anActionButton) {
                VirtualFile file2;
                String filePath = (String)CustomDictionariesPanel.this.myCustomDictionariesTableView.getSelectedObject();
                VirtualFile virtualFile = file2 = StringUtil.isEmpty((String)filePath) ? null : LocalFileSystem.getInstance().refreshAndFindFileByPath(filePath);
                if (file2 == null) {
                    String title = SpellCheckerBundle.message("custom.dictionary.not.found.title", new Object[0]);
                    String message = SpellCheckerBundle.message("custom.dictionary.not.found", filePath);
                    Messages.showMessageDialog((Project)CustomDictionariesPanel.this.myProject, (String)message, (String)title, (Icon)Messages.getErrorIcon());
                    return;
                }
                FileEditorManager fileManager = FileEditorManager.getInstance((Project)CustomDictionariesPanel.this.myProject);
                if (fileManager != null) {
                    fileManager.openFile(file2, true);
                }
            }
        }).disableUpDownActions();
        this.myCustomDictionariesTableView.getEmptyText().setText(SpellCheckerBundle.message("no.custom.dictionaries", new Object[0]));
        this.setLayout(new BorderLayout());
        this.add((Component)decorator.createPanel(), "Center");
    }

    private void doChooseFiles(@NotNull Project project, @NotNull Consumer<List<VirtualFile>> consumer) {
        if (project == null) {
            CustomDictionariesPanel.$$$reportNull$$$0(2);
        }
        if (consumer == null) {
            CustomDictionariesPanel.$$$reportNull$$$0(3);
        }
        FileChooserDescriptor fileChooserDescriptor2 = new FileChooserDescriptor(true, false, false, false, false, true){

            public boolean isFileSelectable(VirtualFile file2) {
                return FileUtilRt.extensionEquals((String)file2.getPath(), (String)"dic");
            }
        };
        FileChooser.chooseFiles((FileChooserDescriptor)fileChooserDescriptor2, (Project)project, (Component)this.getParent(), (VirtualFile)project.getBaseDir(), consumer);
    }

    public List<String> getRemovedDictionaries() {
        return this.removedDictionaries;
    }

    public boolean isModified() {
        List<String> oldPaths = this.mySettings.getCustomDictionariesPaths();
        List newPaths = this.myCustomDictionariesTableView.getItems();
        if (oldPaths.size() != newPaths.size()) {
            return true;
        }
        Set<String> oldDisabled = this.mySettings.getDisabledDictionariesPaths();
        List newDisabled = this.myCustomDictionariesTableView.getDisabled();
        if (oldDisabled.size() != newDisabled.size()) {
            return true;
        }
        if (!newPaths.containsAll(oldPaths) || !oldPaths.containsAll(newPaths)) {
            return true;
        }
        return !newDisabled.containsAll(oldDisabled) || !oldDisabled.containsAll(newDisabled);
    }

    public void reset() {
        this.myCustomDictionariesTableView.getListTableModel().setItems(new ArrayList<String>(this.mySettings.getCustomDictionariesPaths()));
        this.myCustomDictionariesTableView.setDisabled(new ArrayList<String>(this.mySettings.getDisabledDictionariesPaths()));
        this.removedDictionaries.clear();
    }

    public void apply() {
        this.mySettings.setCustomDictionariesPaths(new ArrayList<String>(this.myCustomDictionariesTableView.getItems()));
        this.mySettings.setDisabledDictionariesPaths(new HashSet<String>(this.myCustomDictionariesTableView.getDisabled()));
    }

    public List<String> getValues() {
        return this.myCustomDictionariesTableView.getItems();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
        }
        objectArray2[1] = "com/intellij/spellchecker/settings/CustomDictionariesPanel";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "doChooseFiles";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class CustomDictionariesTableView
    extends TableView<String> {
        @NotNull
        private List<String> myDisabled;

        private CustomDictionariesTableView(@NotNull List<String> dictionaries, @NotNull List<String> disabled) {
            if (dictionaries == null) {
                CustomDictionariesTableView.$$$reportNull$$$0(0);
            }
            if (disabled == null) {
                CustomDictionariesTableView.$$$reportNull$$$0(1);
            }
            this.myDisabled = disabled;
            this.setModelAndUpdateColumns(new ListTableModel(this.createDictionaryColumnInfos(), dictionaries, 1));
            this.setAutoResizeMode(3);
            this.getColumnModel().getColumn(0).setResizable(false);
            this.setShowGrid(false);
            this.setShowVerticalLines(false);
            this.setGridColor(this.getForeground());
            this.setTableHeader(null);
            TableUtil.setupCheckboxColumn((TableColumn)this.getColumnModel().getColumn(0));
        }

        @NotNull
        private List<String> getDisabled() {
            List<String> list2 = this.myDisabled;
            if (list2 == null) {
                CustomDictionariesTableView.$$$reportNull$$$0(2);
            }
            return list2;
        }

        public void setDisabled(@NotNull List<String> disabled) {
            if (disabled == null) {
                CustomDictionariesTableView.$$$reportNull$$$0(3);
            }
            this.myDisabled = disabled;
        }

        private ColumnInfo[] createDictionaryColumnInfos() {
            return new ColumnInfo[]{new ColumnInfo<String, Boolean>(" "){

                public Class<?> getColumnClass() {
                    return Boolean.class;
                }

                public void setValue(String s, Boolean value) {
                    if (value.booleanValue()) {
                        myDisabled.remove(s);
                    } else {
                        myDisabled.add(s);
                    }
                }

                public boolean isCellEditable(String s) {
                    return true;
                }

                public Boolean valueOf(String o) {
                    return !myDisabled.contains(o);
                }
            }, new ColumnInfo<String, String>(SpellCheckerBundle.message("custom.dictionary.title", new Object[0])){

                public String valueOf(String info) {
                    return info;
                }
            }};
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dictionaries";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "disabled";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/spellchecker/settings/CustomDictionariesPanel$CustomDictionariesTableView";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/spellchecker/settings/CustomDictionariesPanel$CustomDictionariesTableView";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDisabled";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "setDisabled";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

