/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spellchecker.settings;

import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.spellchecker.util.SPFileUtil;
import com.intellij.util.Consumer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

@State(name="SpellCheckerSettings", storages={@Storage(value="$WORKSPACE_FILE$")})
public class SpellCheckerSettings
implements PersistentStateComponent<Element> {
    private static final String SPELLCHECKER_MANAGER_SETTINGS_TAG = "SpellCheckerSettings";
    private static final String FOLDERS_ATTR_NAME = "Folders";
    private static final String FOLDER_ATTR_NAME = "Folder";
    private static final String CUSTOM_DICTIONARIES_ATTR_NAME = "CustomDictionaries";
    private static final String CUSTOM_DICTIONARY_ATTR_NAME = "CustomDictionary";
    private static final String DICTIONARIES_ATTR_NAME = "Dictionaries";
    private static final String DICTIONARY_ATTR_NAME = "Dictionary";
    private static final String BUNDLED_DICTIONARIES_ATTR_NAME = "BundledDictionaries";
    private static final String BUNDLED_DICTIONARY_ATTR_NAME = "BundledDictionary";
    private List<String> myOldDictionaryFoldersPaths = new ArrayList<String>();
    private List<String> myCustomDictionariesPaths = new ArrayList<String>();
    private Set<String> myDisabledDictionariesPaths = new HashSet<String>();
    private Set<String> myBundledDisabledDictionariesPaths = new HashSet<String>();

    public static SpellCheckerSettings getInstance(Project project) {
        return (SpellCheckerSettings)ServiceManager.getService((Project)project, SpellCheckerSettings.class);
    }

    public List<String> getCustomDictionariesPaths() {
        return this.myCustomDictionariesPaths;
    }

    public void setCustomDictionariesPaths(List<String> customDictionariesPaths) {
        this.myCustomDictionariesPaths = customDictionariesPaths;
    }

    public Set<String> getDisabledDictionariesPaths() {
        return this.myDisabledDictionariesPaths;
    }

    public void setDisabledDictionariesPaths(Set<String> disabledDictionariesPaths) {
        this.myDisabledDictionariesPaths = disabledDictionariesPaths;
    }

    public Set<String> getBundledDisabledDictionariesPaths() {
        return this.myBundledDisabledDictionariesPaths;
    }

    public void setBundledDisabledDictionariesPaths(Set<String> bundledDisabledDictionariesPaths) {
        this.myBundledDisabledDictionariesPaths = bundledDisabledDictionariesPaths;
    }

    public Element getState() {
        int j;
        if (this.myBundledDisabledDictionariesPaths.isEmpty() && this.myOldDictionaryFoldersPaths.isEmpty() && this.myCustomDictionariesPaths.isEmpty() && this.myDisabledDictionariesPaths.isEmpty()) {
            return null;
        }
        Element element = new Element(SPELLCHECKER_MANAGER_SETTINGS_TAG);
        element.setAttribute(BUNDLED_DICTIONARIES_ATTR_NAME, String.valueOf(this.myBundledDisabledDictionariesPaths.size()));
        Iterator<String> iterator = this.myBundledDisabledDictionariesPaths.iterator();
        int i = 0;
        while (iterator.hasNext()) {
            element.setAttribute(BUNDLED_DICTIONARY_ATTR_NAME + i, iterator.next());
            ++i;
        }
        element.removeAttribute(FOLDERS_ATTR_NAME);
        for (j = 0; j < this.myOldDictionaryFoldersPaths.size(); ++j) {
            element.removeAttribute(FOLDER_ATTR_NAME + j);
        }
        element.setAttribute(CUSTOM_DICTIONARIES_ATTR_NAME, String.valueOf(this.myCustomDictionariesPaths.size()));
        for (j = 0; j < this.myCustomDictionariesPaths.size(); ++j) {
            element.setAttribute(CUSTOM_DICTIONARY_ATTR_NAME + j, this.myCustomDictionariesPaths.get(j));
        }
        element.setAttribute(DICTIONARIES_ATTR_NAME, String.valueOf(this.myDisabledDictionariesPaths.size()));
        iterator = this.myDisabledDictionariesPaths.iterator();
        i = 0;
        while (iterator.hasNext()) {
            element.setAttribute(DICTIONARY_ATTR_NAME + i, iterator.next());
            ++i;
        }
        return element;
    }

    public void loadState(@NotNull Element element) {
        if (element == null) {
            SpellCheckerSettings.$$$reportNull$$$0(0);
        }
        this.myBundledDisabledDictionariesPaths.clear();
        this.myCustomDictionariesPaths.clear();
        this.myOldDictionaryFoldersPaths.clear();
        this.myDisabledDictionariesPaths.clear();
        try {
            int bundledDictionariesSize = StringUtil.parseInt((String)element.getAttributeValue(BUNDLED_DICTIONARIES_ATTR_NAME), (int)0);
            for (int i = 0; i < bundledDictionariesSize; ++i) {
                this.myBundledDisabledDictionariesPaths.add(element.getAttributeValue(BUNDLED_DICTIONARY_ATTR_NAME + i));
            }
            int foldersSize = StringUtil.parseInt((String)element.getAttributeValue(FOLDERS_ATTR_NAME), (int)0);
            for (int i = 0; i < foldersSize; ++i) {
                this.myOldDictionaryFoldersPaths.add(element.getAttributeValue(FOLDER_ATTR_NAME + i));
            }
            this.myOldDictionaryFoldersPaths.forEach(folder -> SPFileUtil.processFilesRecursively(folder, (Consumer<String>)((Consumer)file2 -> {
                if (FileUtilRt.extensionEquals((String)file2, (String)"dic")) {
                    this.myCustomDictionariesPaths.add((String)file2);
                }
            })));
            int customDictSize = StringUtil.parseInt((String)element.getAttributeValue(CUSTOM_DICTIONARIES_ATTR_NAME), (int)0);
            for (int i = 0; i < customDictSize; ++i) {
                this.myCustomDictionariesPaths.add(element.getAttributeValue(CUSTOM_DICTIONARY_ATTR_NAME + i));
            }
            int scriptsSize = StringUtil.parseInt((String)element.getAttributeValue(DICTIONARIES_ATTR_NAME), (int)0);
            for (int i = 0; i < scriptsSize; ++i) {
                this.myDisabledDictionariesPaths.add(element.getAttributeValue(DICTIONARY_ATTR_NAME + i));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/spellchecker/settings/SpellCheckerSettings", "loadState"));
    }
}

