/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spellchecker.settings;

import com.intellij.ide.DataManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.ex.Settings;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.profile.codeInspection.ui.ErrorsConfigurable;
import com.intellij.spellchecker.SpellCheckerManager;
import com.intellij.spellchecker.dictionary.EditableDictionary;
import com.intellij.spellchecker.settings.CustomDictionariesPanel;
import com.intellij.spellchecker.settings.SpellCheckerSettings;
import com.intellij.spellchecker.util.SpellCheckerBundle;
import com.intellij.spellchecker.util.Strings;
import com.intellij.ui.AddDeleteListPanel;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.OptionalChooserComponent;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBTabbedPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.NotNull;

public class SpellCheckerSettingsPane
implements Disposable {
    private JPanel root;
    private JPanel linkContainer;
    private JPanel myPanelForBundledDictionaries;
    private JPanel panelForAcceptedWords;
    private JPanel myPanelForCustomDictionaries;
    private OptionalChooserComponent<String> myBundledDictionariesChooserComponent;
    private final CustomDictionariesPanel myDictionariesPanel;
    private final List<Pair<String, Boolean>> bundledDictionaries;
    private final WordsPanel wordsPanel;
    private final SpellCheckerManager manager;
    private final SpellCheckerSettings settings;

    public SpellCheckerSettingsPane(final SpellCheckerSettings settings, Project project) {
        this.$$$setupUI$$$();
        this.bundledDictionaries = new ArrayList<Pair<String, Boolean>>();
        this.settings = settings;
        this.manager = SpellCheckerManager.getInstance(project);
        HyperlinkLabel link = new HyperlinkLabel(SpellCheckerBundle.message("link.to.inspection.settings", new Object[0]));
        link.addHyperlinkListener(e -> {
            ErrorsConfigurable errorsConfigurable;
            Settings allSettings;
            if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED && (allSettings = (Settings)Settings.KEY.getData(DataManager.getInstance().getDataContext())) != null && (errorsConfigurable = allSettings.find(ErrorsConfigurable.class)) != null) {
                allSettings.select(errorsConfigurable).doWhenDone(() -> errorsConfigurable.selectInspectionTool("SpellCheckingInspection"));
            }
        });
        this.linkContainer.setLayout(new BorderLayout());
        this.linkContainer.add((Component)link);
        this.fillBundledDictionaries();
        this.myDictionariesPanel = new CustomDictionariesPanel(settings, project);
        this.myPanelForCustomDictionaries.setLayout(new BorderLayout());
        this.myPanelForCustomDictionaries.add((Component)this.myDictionariesPanel, "Center");
        this.myBundledDictionariesChooserComponent = new OptionalChooserComponent<String>(this.bundledDictionaries){

            public JCheckBox createCheckBox(String path, boolean checked) {
                return new JCheckBox(FileUtil.toSystemDependentName((String)path), checked);
            }

            public void apply() {
                super.apply();
                HashSet<String> bundledDisabledDictionaries = new HashSet<String>();
                for (Pair pair : SpellCheckerSettingsPane.this.bundledDictionaries) {
                    if (((Boolean)pair.second).booleanValue()) continue;
                    bundledDisabledDictionaries.add((String)pair.first);
                }
                settings.setBundledDisabledDictionariesPaths(bundledDisabledDictionaries);
            }

            public void reset() {
                super.reset();
                SpellCheckerSettingsPane.this.fillBundledDictionaries();
            }
        };
        this.myPanelForBundledDictionaries.setLayout(new BorderLayout());
        this.myPanelForBundledDictionaries.add((Component)this.myBundledDictionariesChooserComponent.getContentPane(), "Center");
        this.myBundledDictionariesChooserComponent.getEmptyText().setText(SpellCheckerBundle.message("no.dictionaries", new Object[0]));
        this.wordsPanel = new WordsPanel(this.manager);
        this.panelForAcceptedWords.setLayout(new BorderLayout());
        this.panelForAcceptedWords.add((Component)((Object)this.wordsPanel), "Center");
    }

    public JComponent getPane() {
        return this.root;
    }

    public boolean isModified() {
        return this.wordsPanel.isModified() || this.myBundledDictionariesChooserComponent.isModified() || this.myDictionariesPanel.isModified();
    }

    public void apply() throws ConfigurationException {
        if (this.wordsPanel.isModified()) {
            this.manager.updateUserDictionary(this.wordsPanel.getWords());
        }
        if (!this.myBundledDictionariesChooserComponent.isModified() && !this.myDictionariesPanel.isModified()) {
            return;
        }
        this.myBundledDictionariesChooserComponent.apply();
        this.myDictionariesPanel.apply();
        this.manager.updateBundledDictionaries(this.myDictionariesPanel.getRemovedDictionaries());
    }

    public void reset() {
        this.myDictionariesPanel.reset();
        this.myBundledDictionariesChooserComponent.reset();
    }

    private void fillBundledDictionaries() {
        this.bundledDictionaries.clear();
        for (String dictionary : SpellCheckerManager.getBundledDictionaries()) {
            this.bundledDictionaries.add((Pair<String, Boolean>)Pair.create((Object)dictionary, (Object)(!this.settings.getBundledDisabledDictionariesPaths().contains(dictionary) ? 1 : 0)));
        }
    }

    public void dispose() {
        if (this.wordsPanel != null) {
            Disposer.dispose((Disposable)this.wordsPanel);
        }
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JPanel jPanel2;
        JPanel jPanel3;
        JPanel jPanel4;
        JPanel jPanel5;
        this.root = jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel5.add((Component)jPanel6, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 1, null, null, null));
        this.linkContainer = jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel6.add((Component)jPanel4, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, new Dimension(24, 38), null));
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel5.add((Component)jPanel7, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 7, null, null, null));
        JBTabbedPane jBTabbedPane = new JBTabbedPane();
        jPanel7.add((Component)jBTabbedPane, new GridConstraints(0, 0, 1, 1, 0, 3, 7, 7, null, new Dimension(200, 200), null));
        JPanel jPanel8 = new JPanel();
        jPanel8.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jBTabbedPane.addTab("Accepted Words", null, jPanel8, null);
        this.panelForAcceptedWords = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel8.add((Component)jPanel3, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JPanel jPanel9 = new JPanel();
        jPanel9.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jBTabbedPane.addTab("Dictionaries", null, jPanel9, null);
        JPanel jPanel10 = new JPanel();
        jPanel10.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel10.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithoutIndent");
        jPanel9.add((Component)jPanel10, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel10.setBorder(IdeBorderFactory.PlainSmallWithoutIndent.createTitledBorder((Border)BorderFactory.createEtchedBorder(), (String)ResourceBundle.getBundle("com/intellij/spellchecker/util/SpellCheckerBundle").getString("bundled.dictionaries.title"), (int)0, (int)0, null, null));
        this.myPanelForBundledDictionaries = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel10.add((Component)jPanel2, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JBLabel jBLabel = new JBLabel();
        jBLabel.setComponentStyle(UIUtil.ComponentStyle.SMALL);
        jBLabel.setFontColor(UIUtil.FontColor.BRIGHTER);
        this.$$$loadLabelText$$$((JLabel)jBLabel, ResourceBundle.getBundle("com/intellij/spellchecker/util/SpellCheckerBundle").getString("dictionaries.panel.description"));
        jPanel10.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JPanel jPanel11 = new JPanel();
        jPanel11.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel11.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithoutIndent");
        jPanel9.add((Component)jPanel11, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel11.setBorder(IdeBorderFactory.PlainSmallWithoutIndent.createTitledBorder((Border)BorderFactory.createEtchedBorder(), (String)ResourceBundle.getBundle("com/intellij/spellchecker/util/SpellCheckerBundle").getString("custom.dictionaries.title"), (int)0, (int)0, null, null));
        this.myPanelForCustomDictionaries = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel11.add((Component)jPanel, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JBLabel jBLabel2 = new JBLabel();
        jBLabel2.setComponentStyle(UIUtil.ComponentStyle.SMALL);
        jBLabel2.setFontColor(UIUtil.FontColor.BRIGHTER);
        this.$$$loadLabelText$$$((JLabel)jBLabel2, ResourceBundle.getBundle("com/intellij/spellchecker/util/SpellCheckerBundle").getString("add.dictionary.description"));
        jPanel11.add((Component)jBLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.root;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private static final class WordsPanel
    extends AddDeleteListPanel<String>
    implements Disposable {
        private final SpellCheckerManager manager;

        private WordsPanel(SpellCheckerManager manager) {
            super(null, new WordDescriber(manager.getUserDictionary()).process());
            this.manager = manager;
            this.getEmptyText().setText(SpellCheckerBundle.message("no.words", new Object[0]));
        }

        protected String findItemToAdd() {
            String word = Messages.showInputDialog((String)SpellCheckerBundle.message("enter.simple.word", new Object[0]), (String)SpellCheckerBundle.message("add.new.word", new Object[0]), null);
            if (word == null) {
                return null;
            }
            if (Strings.isMixedCase(word = word.trim())) {
                Messages.showWarningDialog((String)SpellCheckerBundle.message("entered.word.0.is.mixed.cased.you.must.enter.simple.word", word), (String)SpellCheckerBundle.message("add.new.word", new Object[0]));
                return null;
            }
            if (!this.manager.hasProblem(word)) {
                Messages.showWarningDialog((String)SpellCheckerBundle.message("entered.word.0.is.correct.you.no.need.to.add.this.in.list", word), (String)SpellCheckerBundle.message("add.new.word", new Object[0]));
                return null;
            }
            return word;
        }

        public void dispose() {
            this.myListModel.removeAllElements();
        }

        @NotNull
        public List<String> getWords() {
            Object[] pairs = this.getListItems();
            if (pairs == null) {
                ArrayList<String> arrayList = new ArrayList<String>();
                if (arrayList == null) {
                    WordsPanel.$$$reportNull$$$0(0);
                }
                return arrayList;
            }
            ArrayList<String> words = new ArrayList<String>();
            for (Object pair : pairs) {
                words.add(pair.toString());
            }
            ArrayList<String> arrayList = words;
            if (arrayList == null) {
                WordsPanel.$$$reportNull$$$0(1);
            }
            return arrayList;
        }

        public boolean isModified() {
            List<String> newWords = this.getWords();
            Set<String> words = this.manager.getUserDictionary().getEditableWords();
            if (newWords.size() != words.size()) {
                return true;
            }
            return !words.containsAll(newWords) || !newWords.containsAll(words);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spellchecker/settings/SpellCheckerSettingsPane$WordsPanel", "getWords"));
        }
    }

    public static final class WordDescriber {
        private final EditableDictionary dictionary;

        public WordDescriber(EditableDictionary dictionary) {
            this.dictionary = dictionary;
        }

        @NotNull
        public List<String> process() {
            if (this.dictionary == null) {
                ArrayList<String> arrayList = new ArrayList<String>();
                if (arrayList == null) {
                    WordDescriber.$$$reportNull$$$0(0);
                }
                return arrayList;
            }
            Set<String> words = this.dictionary.getEditableWords();
            ArrayList<String> result2 = new ArrayList<String>(words);
            Collections.sort(result2);
            ArrayList<String> arrayList = result2;
            if (arrayList == null) {
                WordDescriber.$$$reportNull$$$0(1);
            }
            return arrayList;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spellchecker/settings/SpellCheckerSettingsPane$WordDescriber", "process"));
        }
    }
}

