/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.ui.SpeedSearchBase;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;

public class SpeedSearchObjectWithWeight {
    public final Object node;
    private final int weight;

    SpeedSearchObjectWithWeight(Object element, int weight2) {
        this.node = element;
        this.weight = weight2;
    }

    public int compareWith(SpeedSearchObjectWithWeight obj) {
        return this.weight == obj.weight ? 0 : (this.weight < obj.weight ? 1 : -1);
    }

    public static List<SpeedSearchObjectWithWeight> findElement(String pattern, SpeedSearchBase speedSearch) {
        ArrayList<SpeedSearchObjectWithWeight> elements = new ArrayList<SpeedSearchObjectWithWeight>();
        pattern = pattern.trim();
        ListIterator<Object> it = speedSearch.getElementIterator(0);
        while (it.hasNext()) {
            Object element = it.next();
            String text = speedSearch.getElementText(element);
            if (text == null) continue;
            elements.add(new SpeedSearchObjectWithWeight(element, speedSearch.getComparator().matchingDegree(pattern, text)));
        }
        SpeedSearchObjectWithWeight cur = null;
        ArrayList<SpeedSearchObjectWithWeight> current = new ArrayList<SpeedSearchObjectWithWeight>();
        for (SpeedSearchObjectWithWeight element : elements) {
            if (cur == null) {
                cur = element;
                current.add(cur);
                continue;
            }
            int i = element.compareWith(cur);
            if (i == 0) {
                current.add(element);
                continue;
            }
            if (i >= 0) continue;
            cur = element;
            current.clear();
            current.add(cur);
        }
        return current;
    }
}

