/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentIterator;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.util.indexing.IndexableFileSet;
import com.intellij.util.indexing.IndexableSetContributor;
import gnu.trove.THashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class AdditionalIndexableFileSet
implements IndexableFileSet {
    private final Project myProject;
    private volatile Set<VirtualFile> cachedFiles;
    private volatile Set<VirtualFile> cachedDirectories;
    private volatile IndexableSetContributor[] myExtensions;

    public AdditionalIndexableFileSet(Project project, IndexableSetContributor ... extensions) {
        this.myProject = project;
        this.myExtensions = extensions;
    }

    public AdditionalIndexableFileSet(Project project) {
        this.myProject = project;
    }

    public AdditionalIndexableFileSet(IndexableSetContributor ... extensions) {
        this.myProject = null;
        this.myExtensions = extensions;
    }

    public AdditionalIndexableFileSet() {
        this.myProject = null;
    }

    private Set<VirtualFile> getDirectories() {
        Set<VirtualFile> directories = this.cachedDirectories;
        if (directories == null || VfsUtilCore.hasInvalidFiles(directories) || VfsUtilCore.hasInvalidFiles(this.cachedFiles)) {
            directories = this.collectFilesAndDirectories();
        }
        return directories;
    }

    private THashSet<VirtualFile> collectFilesAndDirectories() {
        THashSet files = new THashSet();
        THashSet directories = new THashSet();
        if (this.myExtensions == null) {
            this.myExtensions = (IndexableSetContributor[])Extensions.getExtensions((ExtensionPointName)IndexableSetContributor.EP_NAME);
        }
        for (IndexableSetContributor contributor : this.myExtensions) {
            for (VirtualFile root : IndexableSetContributor.getRootsToIndex((IndexableSetContributor)contributor)) {
                (root.isDirectory() ? directories : files).add((Object)root);
            }
            if (this.myProject == null) continue;
            Set projectRoots = IndexableSetContributor.getProjectRootsToIndex((IndexableSetContributor)contributor, (Project)this.myProject);
            for (VirtualFile root : projectRoots) {
                (root.isDirectory() ? directories : files).add((Object)root);
            }
        }
        this.cachedFiles = files;
        this.cachedDirectories = directories;
        return directories;
    }

    public boolean isInSet(@NotNull VirtualFile file2) {
        if (file2 == null) {
            AdditionalIndexableFileSet.$$$reportNull$$$0(0);
        }
        return VfsUtilCore.isUnder((VirtualFile)file2, this.getDirectories()) || this.cachedFiles.contains(file2);
    }

    public void iterateIndexableFilesIn(@NotNull VirtualFile file2, final @NotNull ContentIterator iterator) {
        if (file2 == null) {
            AdditionalIndexableFileSet.$$$reportNull$$$0(1);
        }
        if (iterator == null) {
            AdditionalIndexableFileSet.$$$reportNull$$$0(2);
        }
        VfsUtilCore.visitChildrenRecursively((VirtualFile)file2, (VirtualFileVisitor)new VirtualFileVisitor(new VirtualFileVisitor.Option[0]){

            public boolean visitFile(@NotNull VirtualFile file2) {
                if (file2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (!AdditionalIndexableFileSet.this.isInSet(file2)) {
                    return false;
                }
                if (!file2.isDirectory()) {
                    iterator.processFile(file2);
                }
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/util/indexing/AdditionalIndexableFileSet$1", "visitFile"));
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "iterator";
                break;
            }
        }
        objectArray2[1] = "com/intellij/util/indexing/AdditionalIndexableFileSet";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isInSet";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "iterateIndexableFilesIn";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

