/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.frame;

import com.google.common.primitives.Ints;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.OnePixelSplitter;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.SearchTextField;
import com.intellij.ui.components.JBLoadingPanel;
import com.intellij.ui.components.panels.Wrapper;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.table.ComponentsListFocusTraversalPolicy;
import com.intellij.vcs.CommittedChangeListForRevision;
import com.intellij.vcs.log.CommitId;
import com.intellij.vcs.log.VcsFullCommitDetails;
import com.intellij.vcs.log.VcsLog;
import com.intellij.vcs.log.VcsLogFilterUi;
import com.intellij.vcs.log.VcsLogUi;
import com.intellij.vcs.log.VcsShortCommitDetails;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.impl.CommonUiProperties;
import com.intellij.vcs.log.impl.MainVcsLogUiProperties;
import com.intellij.vcs.log.ui.VcsLogInternalDataKeys;
import com.intellij.vcs.log.ui.VcsLogUiImpl;
import com.intellij.vcs.log.ui.actions.IntelliSortChooserPopupAction;
import com.intellij.vcs.log.ui.filter.VcsLogClassicFilterUi;
import com.intellij.vcs.log.ui.frame.DetailsPanel;
import com.intellij.vcs.log.ui.frame.VcsLogChangesBrowser;
import com.intellij.vcs.log.ui.table.CommitSelectionListener;
import com.intellij.vcs.log.ui.table.VcsLogGraphTable;
import com.intellij.vcs.log.util.BekUtil;
import com.intellij.vcs.log.util.VcsLogUiUtil;
import com.intellij.vcs.log.util.VcsLogUtil;
import com.intellij.vcs.log.visible.VisiblePack;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import net.miginfocom.swing.MigLayout;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MainFrame
extends JPanel
implements DataProvider,
Disposable {
    private static final String HELP_ID = "reference.changesToolWindow.log";
    @NotNull
    private final VcsLogData myLogData;
    @NotNull
    private final VcsLogUi myUi;
    @NotNull
    private final VcsLog myLog;
    @NotNull
    private final VcsLogClassicFilterUi myFilterUi;
    @NotNull
    private final JBLoadingPanel myChangesLoadingPane;
    @NotNull
    private final VcsLogGraphTable myGraphTable;
    @NotNull
    private final DetailsPanel myDetailsPanel;
    @NotNull
    private final Splitter myDetailsSplitter;
    @NotNull
    private final JComponent myToolbar;
    @NotNull
    private final VcsLogChangesBrowser myChangesBrowser;
    @NotNull
    private final Splitter myChangesBrowserSplitter;
    @NotNull
    private final SearchTextField myTextFilter;
    @NotNull
    private final MainVcsLogUiProperties myUiProperties;

    public MainFrame(@NotNull VcsLogData logData, @NotNull VcsLogUiImpl ui, @NotNull Project project, @NotNull MainVcsLogUiProperties uiProperties, @NotNull VcsLog log, @NotNull VisiblePack initialDataPack) {
        if (logData == null) {
            MainFrame.$$$reportNull$$$0(0);
        }
        if (ui == null) {
            MainFrame.$$$reportNull$$$0(1);
        }
        if (project == null) {
            MainFrame.$$$reportNull$$$0(2);
        }
        if (uiProperties == null) {
            MainFrame.$$$reportNull$$$0(3);
        }
        if (log == null) {
            MainFrame.$$$reportNull$$$0(4);
        }
        if (initialDataPack == null) {
            MainFrame.$$$reportNull$$$0(5);
        }
        this.myLogData = logData;
        this.myUi = ui;
        this.myLog = log;
        this.myUiProperties = uiProperties;
        this.myFilterUi = new VcsLogClassicFilterUi(ui, logData, this.myUiProperties, initialDataPack);
        this.myGraphTable = new VcsLogGraphTable(ui, logData, initialDataPack);
        this.myGraphTable.setCompactReferencesView(this.myUiProperties.get(MainVcsLogUiProperties.COMPACT_REFERENCES_VIEW));
        this.myGraphTable.setShowTagNames(this.myUiProperties.get(MainVcsLogUiProperties.SHOW_TAG_NAMES));
        PopupHandler.installPopupHandler((JComponent)((Object)this.myGraphTable), (String)"Vcs.Log.ContextMenu", (String)"Vcs.Log.ContextMenu");
        this.myDetailsPanel = new DetailsPanel(logData, ui.getColorManager(), this);
        this.myChangesBrowser = new VcsLogChangesBrowser(project, this.myUiProperties, (Function<CommitId, VcsShortCommitDetails>)((Function)commitId -> {
            int index = this.myLogData.getCommitIndex(commitId.getHash(), commitId.getRoot());
            return this.myLogData.getMiniDetailsGetter().getCommitData((Integer)index, Collections.singleton(index));
        }), this);
        this.myChangesBrowser.getDiffAction().registerCustomShortcutSet(this.myChangesBrowser.getDiffAction().getShortcutSet(), (JComponent)((Object)this.getGraphTable()));
        this.myChangesLoadingPane = new JBLoadingPanel((LayoutManager)new BorderLayout(), (Disposable)this, 300);
        this.myChangesLoadingPane.add((Component)this.myChangesBrowser);
        this.myDetailsSplitter = new OnePixelSplitter(true, "vcs.log.details.splitter.proportion", 0.7f);
        this.myDetailsSplitter.setFirstComponent((JComponent)this.myChangesLoadingPane);
        this.setupDetailsSplitter(this.myUiProperties.get(CommonUiProperties.SHOW_DETAILS));
        this.myGraphTable.getSelectionModel().addListSelectionListener(new MyCommitSelectionListenerForDiff());
        this.myDetailsPanel.installCommitSelectionListener(this.myGraphTable);
        VcsLogUiUtil.installDetailsListeners(this.myGraphTable, this.myDetailsPanel, this.myLogData, this);
        this.myTextFilter = this.myFilterUi.createTextFilter();
        this.myToolbar = this.createActionsToolbar();
        this.myChangesBrowser.setToolbarHeightReferent(this.myToolbar);
        JPanel toolbars = new JPanel(new BorderLayout());
        toolbars.add((Component)this.myToolbar, "North");
        JPanel toolbarsAndTable = new JPanel(new BorderLayout());
        toolbarsAndTable.add((Component)toolbars, "North");
        toolbarsAndTable.add((Component)VcsLogUiUtil.installProgress(VcsLogUiUtil.setupScrolledGraph(this.myGraphTable, 2), this.myLogData, this), "Center");
        this.myChangesBrowserSplitter = new OnePixelSplitter(false, "vcs.log.changes.splitter.proportion", 0.7f);
        this.myChangesBrowserSplitter.setFirstComponent((JComponent)toolbarsAndTable);
        this.myChangesBrowserSplitter.setSecondComponent((JComponent)this.myDetailsSplitter);
        this.setLayout(new BorderLayout());
        this.add((Component)this.myChangesBrowserSplitter);
        Disposer.register((Disposable)ui, (Disposable)this);
        this.myGraphTable.resetDefaultFocusTraversalKeys();
        this.setFocusCycleRoot(true);
        this.setFocusTraversalPolicy(new MyFocusPolicy());
    }

    public void updateDataPack(@NotNull VisiblePack dataPack, boolean permGraphChanged) {
        if (dataPack == null) {
            MainFrame.$$$reportNull$$$0(6);
        }
        this.myFilterUi.updateDataPack(dataPack);
        this.myGraphTable.updateDataPack(dataPack, permGraphChanged);
    }

    public void setupDetailsSplitter(boolean state) {
        this.myDetailsSplitter.setSecondComponent((JComponent)(state ? this.myDetailsPanel : null));
    }

    @NotNull
    public VcsLogGraphTable getGraphTable() {
        VcsLogGraphTable vcsLogGraphTable = this.myGraphTable;
        if (vcsLogGraphTable == null) {
            MainFrame.$$$reportNull$$$0(7);
        }
        return vcsLogGraphTable;
    }

    @NotNull
    public VcsLogFilterUi getFilterUi() {
        VcsLogClassicFilterUi vcsLogClassicFilterUi = this.myFilterUi;
        if (vcsLogClassicFilterUi == null) {
            MainFrame.$$$reportNull$$$0(8);
        }
        return vcsLogClassicFilterUi;
    }

    private JComponent createActionsToolbar() {
        DefaultActionGroup toolbarGroup = new DefaultActionGroup();
        toolbarGroup.add(ActionManager.getInstance().getAction("Vcs.Log.Toolbar.Internal"));
        DefaultActionGroup mainGroup = new DefaultActionGroup();
        mainGroup.add(ActionManager.getInstance().getAction("Vcs.Log.QuickTextFilterSettings"));
        mainGroup.add((AnAction)new Separator());
        mainGroup.add((AnAction)this.myFilterUi.createActionGroup());
        mainGroup.addSeparator();
        if (BekUtil.isBekEnabled()) {
            if (BekUtil.isLinearBekEnabled()) {
                mainGroup.add((AnAction)new IntelliSortChooserPopupAction());
            } else {
                mainGroup.add(ActionManager.getInstance().getAction("Vcs.Log.IntelliSortChooser"));
            }
        }
        mainGroup.add((AnAction)toolbarGroup);
        ActionToolbar toolbar = this.createActionsToolbar(mainGroup);
        Wrapper textFilter = new Wrapper((JComponent)this.myTextFilter);
        textFilter.setVerticalSizeReferent(toolbar.getComponent());
        textFilter.setBorder((Border)JBUI.Borders.emptyLeft((int)5));
        ActionToolbar settings = this.createActionsToolbar(new DefaultActionGroup(new AnAction[]{ActionManager.getInstance().getAction("Vcs.Log.QuickSettings")}));
        settings.setReservePlaceAutoPopupIcon(false);
        settings.setLayoutPolicy(0);
        JPanel panel2 = new JPanel((LayoutManager)new MigLayout("ins 0, fill", "[left]0[left, fill]push[right]", "center"));
        panel2.add((Component)textFilter);
        panel2.add(toolbar.getComponent());
        panel2.add(settings.getComponent());
        return panel2;
    }

    @NotNull
    private ActionToolbar createActionsToolbar(@NotNull DefaultActionGroup mainGroup) {
        if (mainGroup == null) {
            MainFrame.$$$reportNull$$$0(9);
        }
        ActionToolbar toolbar = ActionManager.getInstance().createActionToolbar("Vcs.Log.Toolbar", (ActionGroup)mainGroup, true);
        toolbar.setTargetComponent((JComponent)this);
        ActionToolbar actionToolbar = toolbar;
        if (actionToolbar == null) {
            MainFrame.$$$reportNull$$$0(10);
        }
        return actionToolbar;
    }

    @NotNull
    public JComponent getMainComponent() {
        MainFrame mainFrame = this;
        if (mainFrame == null) {
            MainFrame.$$$reportNull$$$0(11);
        }
        return mainFrame;
    }

    @Nullable
    public Object getData(@NonNls String dataId) {
        if (VcsDataKeys.CHANGES.is(dataId) || VcsDataKeys.SELECTED_CHANGES.is(dataId)) {
            return ArrayUtil.toObjectArray(this.myChangesBrowser.getAllChanges(), Change.class);
        }
        if (VcsDataKeys.CHANGE_LISTS.is(dataId)) {
            List details = this.myLog.getSelectedDetails();
            if (details.size() > 1000) {
                return null;
            }
            return ContainerUtil.map2Array((Collection)details, CommittedChangeListForRevision.class, VcsLogUtil::createCommittedChangeList);
        }
        if (PlatformDataKeys.HELP_ID.is(dataId)) {
            return HELP_ID;
        }
        if (VcsLogInternalDataKeys.LOG_UI_PROPERTIES.is(dataId)) {
            return this.myUiProperties;
        }
        if (CommonDataKeys.VIRTUAL_FILE_ARRAY.is(dataId)) {
            Collection roots = (Collection)ObjectUtils.chooseNotNull(this.getSelectedRoots(), VcsLogUtil.getVisibleRoots(this.myUi));
            return VfsUtilCore.toVirtualFileArray((Collection)roots);
        }
        return null;
    }

    @Nullable
    private Set<VirtualFile> getSelectedRoots() {
        int[] selectedRows = this.myGraphTable.getSelectedRows();
        if (selectedRows.length == 0 || selectedRows.length > 1000) {
            return null;
        }
        return ContainerUtil.map2Set((Collection)Ints.asList((int[])selectedRows), row -> this.myGraphTable.getModel().getRoot((int)row));
    }

    @NotNull
    public JComponent getToolbar() {
        JComponent jComponent = this.myToolbar;
        if (jComponent == null) {
            MainFrame.$$$reportNull$$$0(12);
        }
        return jComponent;
    }

    @NotNull
    public SearchTextField getTextFilter() {
        SearchTextField searchTextField = this.myTextFilter;
        if (searchTextField == null) {
            MainFrame.$$$reportNull$$$0(13);
        }
        return searchTextField;
    }

    public void showDetails(boolean state) {
        this.myDetailsSplitter.setSecondComponent((JComponent)(state ? this.myDetailsPanel : null));
    }

    public void dispose() {
        this.myDetailsSplitter.dispose();
        this.myChangesBrowserSplitter.dispose();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logData";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ui";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uiProperties";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "log";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initialDataPack";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataPack";
                break;
            }
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/log/ui/frame/MainFrame";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mainGroup";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/log/ui/frame/MainFrame";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getGraphTable";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilterUi";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createActionsToolbar";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getMainComponent";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getToolbar";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getTextFilter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "updateDataPack";
                break;
            }
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createActionsToolbar";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class MyFocusPolicy
    extends ComponentsListFocusTraversalPolicy {
        private MyFocusPolicy() {
        }

        @Override
        @NotNull
        protected List<Component> getOrderedComponents() {
            List<Component> list2 = Arrays.asList(new Component[]{MainFrame.this.myGraphTable, MainFrame.this.myChangesBrowser.getPreferredFocusedComponent(), MainFrame.this.myTextFilter.getTextEditor()});
            if (list2 == null) {
                MyFocusPolicy.$$$reportNull$$$0(0);
            }
            return list2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/frame/MainFrame$MyFocusPolicy", "getOrderedComponents"));
        }
    }

    private class MyCommitSelectionListenerForDiff
    extends CommitSelectionListener {
        protected MyCommitSelectionListenerForDiff() {
            super(MainFrame.this.myLogData, MainFrame.this.myGraphTable);
        }

        @Override
        protected void onEmptySelection() {
            MainFrame.this.myChangesBrowser.setSelectedDetails(Collections.emptyList());
        }

        @Override
        protected void onDetailsLoaded(@NotNull List<VcsFullCommitDetails> detailsList) {
            if (detailsList == null) {
                MyCommitSelectionListenerForDiff.$$$reportNull$$$0(0);
            }
            MainFrame.this.myChangesBrowser.setSelectedDetails(detailsList);
        }

        @Override
        protected void onSelection(@NotNull int[] selection) {
            if (selection == null) {
                MyCommitSelectionListenerForDiff.$$$reportNull$$$0(1);
            }
            MainFrame.this.myChangesBrowser.resetSelectedDetails();
        }

        @Override
        protected void startLoading() {
            MainFrame.this.myChangesLoadingPane.startLoading();
        }

        @Override
        protected void stopLoading() {
            MainFrame.this.myChangesLoadingPane.stopLoading();
        }

        @Override
        protected void onError(@NotNull Throwable error) {
            if (error == null) {
                MyCommitSelectionListenerForDiff.$$$reportNull$$$0(2);
            }
            MainFrame.this.myChangesBrowser.setSelectedDetails(Collections.emptyList());
            MainFrame.this.myChangesBrowser.getViewer().setEmptyText("Error loading commits");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "detailsList";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "selection";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "error";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/vcs/log/ui/frame/MainFrame$MyCommitSelectionListenerForDiff";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "onDetailsLoaded";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "onSelection";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "onError";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

