/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.relaxNG.model.resolve;

import com.intellij.ide.highlighter.XmlFileType;
import com.intellij.navigation.ColoredItemPresentation;
import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.NavigationItem;
import com.intellij.navigation.PsiElementNavigationItem;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.meta.PsiMetaData;
import com.intellij.psi.meta.PsiMetaOwner;
import com.intellij.psi.meta.PsiPresentableMetaData;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.DefaultFileTypeSpecificInputFilter;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.ScalarIndexExtension;
import com.intellij.util.io.EnumeratorStringDescriptor;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.text.CharArrayUtil;
import com.intellij.util.xml.NanoXmlUtil;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import net.n3.nanoxml.IXMLBuilder;
import org.intellij.plugins.relaxNG.compact.RncFileType;
import org.intellij.plugins.relaxNG.model.CommonElement;
import org.intellij.plugins.relaxNG.model.Define;
import org.intellij.plugins.relaxNG.model.Grammar;
import org.intellij.plugins.relaxNG.model.resolve.GrammarFactory;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RelaxSymbolIndex
extends ScalarIndexExtension<String> {
    @NonNls
    public static final ID<String, Void> NAME = ID.create((String)"RelaxSymbolIndex");

    public static Collection<String> getSymbolNames(Project project) {
        return FileBasedIndex.getInstance().getAllKeys(NAME, project);
    }

    public static NavigationItem[] getSymbolsByName(final String name, Project project, boolean includeNonProjectItems) {
        GlobalSearchScope scope = includeNonProjectItems ? GlobalSearchScope.allScope((Project)project) : GlobalSearchScope.projectScope((Project)project);
        final ArrayList result2 = new ArrayList();
        PsiManager psiManager = PsiManager.getInstance((Project)project);
        for (VirtualFile file2 : FileBasedIndex.getInstance().getContainingFiles(NAME, (Object)name, scope)) {
            Grammar grammar;
            PsiFile psiFile = psiManager.findFile(file2);
            if (!(psiFile instanceof XmlFile) || (grammar = GrammarFactory.getGrammar((XmlFile)psiFile)) == null) continue;
            grammar.acceptChildren(new CommonElement.Visitor(){

                @Override
                public void visitDefine(Define define) {
                    Object psi;
                    if (name.equals(define.getName()) && (psi = define.getPsiElement()) != null) {
                        MyNavigationItem.add((NavigationItem)define.getPsiElement(), result2);
                    }
                }
            });
        }
        return result2.toArray(new NavigationItem[result2.size()]);
    }

    @NotNull
    public ID<String, Void> getName() {
        ID<String, Void> iD = NAME;
        if (iD == null) {
            RelaxSymbolIndex.$$$reportNull$$$0(0);
        }
        return iD;
    }

    @NotNull
    public DataIndexer<String, Void, FileContent> getIndexer() {
        DataIndexer<String, Void, FileContent> dataIndexer = new DataIndexer<String, Void, FileContent>(){

            @NotNull
            public Map<String, Void> map(@NotNull FileContent inputData) {
                Grammar grammar;
                PsiFile file2;
                if (inputData == null) {
                    2.$$$reportNull$$$0(0);
                }
                final HashMap<String, Void> map = new HashMap<String, Void>();
                if (inputData.getFileType() == XmlFileType.INSTANCE) {
                    CharSequence inputDataContentAsText = inputData.getContentAsText();
                    if (CharArrayUtil.indexOf((CharSequence)inputDataContentAsText, (CharSequence)"http://relaxng.org/ns/structure/1.0", (int)0) == -1) {
                        Map<String, Void> map2 = Collections.emptyMap();
                        if (map2 == null) {
                            2.$$$reportNull$$$0(1);
                        }
                        return map2;
                    }
                    NanoXmlUtil.parse((Reader)CharArrayUtil.readerFromCharSequence((CharSequence)inputData.getContentAsText()), (IXMLBuilder)new NanoXmlUtil.IXMLBuilderAdapter(){
                        NanoXmlUtil.IXMLBuilderAdapter attributeHandler;
                        int depth;

                        public void addAttribute(String key, String nsPrefix, String nsURI, String value, String type) throws Exception {
                            if (this.attributeHandler != null) {
                                this.attributeHandler.addAttribute(key, nsPrefix, nsURI, value, type);
                            }
                        }

                        public void startElement(String name, String nsPrefix, String nsURI, String systemID, int lineNr) throws Exception {
                            this.attributeHandler = null;
                            if (this.depth == 1 && "http://relaxng.org/ns/structure/1.0".equals(nsURI) && "define".equals(name)) {
                                this.attributeHandler = new NanoXmlUtil.IXMLBuilderAdapter(){

                                    public void addAttribute(String key, String nsPrefix, String nsURI, String value, String type) throws Exception {
                                        if ("name".equals(key) && (nsURI == null || nsURI.length() == 0) && value != null) {
                                            map.put(value, null);
                                        }
                                    }
                                };
                            }
                            ++this.depth;
                        }

                        public void endElement(String name, String nsPrefix, String nsURI) throws Exception {
                            this.attributeHandler = null;
                            --this.depth;
                        }
                    });
                } else if (inputData.getFileType() == RncFileType.getInstance() && (file2 = inputData.getPsiFile()) instanceof XmlFile && (grammar = GrammarFactory.getGrammar((XmlFile)file2)) != null) {
                    grammar.acceptChildren(new CommonElement.Visitor(){

                        @Override
                        public void visitDefine(Define define) {
                            String name = define.getName();
                            if (name != null) {
                                map.put(name, null);
                            }
                        }
                    });
                }
                HashMap<String, Void> hashMap = map;
                if (hashMap == null) {
                    2.$$$reportNull$$$0(2);
                }
                return hashMap;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: 
                    case 2: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: 
                    case 2: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "inputData";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "org/intellij/plugins/relaxNG/model/resolve/RelaxSymbolIndex$2";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "org/intellij/plugins/relaxNG/model/resolve/RelaxSymbolIndex$2";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "map";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "map";
                        break;
                    }
                    case 1: 
                    case 2: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: 
                    case 2: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
        if (dataIndexer == null) {
            RelaxSymbolIndex.$$$reportNull$$$0(1);
        }
        return dataIndexer;
    }

    @NotNull
    public KeyDescriptor<String> getKeyDescriptor() {
        EnumeratorStringDescriptor enumeratorStringDescriptor = EnumeratorStringDescriptor.INSTANCE;
        if (enumeratorStringDescriptor == null) {
            RelaxSymbolIndex.$$$reportNull$$$0(2);
        }
        return enumeratorStringDescriptor;
    }

    @NotNull
    public FileBasedIndex.InputFilter getInputFilter() {
        DefaultFileTypeSpecificInputFilter defaultFileTypeSpecificInputFilter = new DefaultFileTypeSpecificInputFilter(new FileType[]{StdFileTypes.XML, RncFileType.getInstance()}){

            public boolean acceptInput(@NotNull VirtualFile file2) {
                if (file2 == null) {
                    3.$$$reportNull$$$0(0);
                }
                return !(file2.getFileSystem() instanceof JarFileSystem);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/intellij/plugins/relaxNG/model/resolve/RelaxSymbolIndex$3", "acceptInput"));
            }
        };
        if (defaultFileTypeSpecificInputFilter == null) {
            RelaxSymbolIndex.$$$reportNull$$$0(3);
        }
        return defaultFileTypeSpecificInputFilter;
    }

    public boolean dependsOnFileContent() {
        return true;
    }

    public int getVersion() {
        return 0;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "org/intellij/plugins/relaxNG/model/resolve/RelaxSymbolIndex";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndexer";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeyDescriptor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getInputFilter";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class MyNavigationItem
    implements PsiElementNavigationItem,
    ItemPresentation {
        private final NavigationItem myItem;
        private final ItemPresentation myPresentation;

        private MyNavigationItem(NavigationItem item, @NotNull ItemPresentation presentation) {
            if (presentation == null) {
                MyNavigationItem.$$$reportNull$$$0(0);
            }
            this.myItem = item;
            this.myPresentation = presentation;
        }

        public String getPresentableText() {
            return this.myPresentation.getPresentableText();
        }

        @Nullable
        public String getLocationString() {
            return MyNavigationItem.getLocationString((PsiElement)this.myItem);
        }

        private static String getLocationString(PsiElement element) {
            return "(in " + element.getContainingFile().getName() + ")";
        }

        @Nullable
        public Icon getIcon(boolean open2) {
            return this.myPresentation.getIcon(open2);
        }

        @Nullable
        public TextAttributesKey getTextAttributesKey() {
            return this.myPresentation instanceof ColoredItemPresentation ? ((ColoredItemPresentation)this.myPresentation).getTextAttributesKey() : null;
        }

        public String getName() {
            return this.myItem.getName();
        }

        public ItemPresentation getPresentation() {
            return this;
        }

        public PsiElement getTargetElement() {
            return (PsiElement)this.myItem;
        }

        public void navigate(boolean requestFocus) {
            this.myItem.navigate(requestFocus);
        }

        public boolean canNavigate() {
            return this.myItem.canNavigate();
        }

        public boolean canNavigateToSource() {
            return this.myItem.canNavigateToSource();
        }

        public static void add(final NavigationItem item, Collection<NavigationItem> symbolNavItems) {
            Object presentation;
            if (item instanceof PsiMetaOwner) {
                PsiMetaData data = ((PsiMetaOwner)item).getMetaData();
                if (data instanceof PsiPresentableMetaData) {
                    final PsiPresentableMetaData metaData = (PsiPresentableMetaData)data;
                    presentation = new ColoredItemPresentation(){

                        public String getPresentableText() {
                            return metaData.getName();
                        }

                        @Nullable
                        public String getLocationString() {
                            return MyNavigationItem.getLocationString((PsiElement)item);
                        }

                        @Nullable
                        public Icon getIcon(boolean open2) {
                            return metaData.getIcon();
                        }

                        @Nullable
                        public TextAttributesKey getTextAttributesKey() {
                            ItemPresentation p = item.getPresentation();
                            return p instanceof ColoredItemPresentation ? ((ColoredItemPresentation)p).getTextAttributesKey() : null;
                        }
                    };
                } else {
                    presentation = item.getPresentation();
                }
            } else {
                presentation = item.getPresentation();
            }
            if (presentation != null) {
                symbolNavItems.add((NavigationItem)new MyNavigationItem(item, (ItemPresentation)presentation));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "presentation", "org/intellij/plugins/relaxNG/model/resolve/RelaxSymbolIndex$MyNavigationItem", "<init>"));
        }
    }
}

