/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.relaxNG.validation;

import com.intellij.ide.errorTreeView.NewErrorTreeViewPanel;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlFile;
import com.intellij.xml.XmlElementDescriptor;
import com.thaiopensource.util.PropertyMapBuilder;
import com.thaiopensource.util.UriOrFile;
import com.thaiopensource.validate.SchemaReader;
import com.thaiopensource.validate.ValidateProperty;
import com.thaiopensource.validate.ValidationDriver;
import com.thaiopensource.validate.auto.AutoSchemaReader;
import com.thaiopensource.validate.rng.CompactSchemaReader;
import com.thaiopensource.validate.rng.RngProperty;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.concurrent.Future;
import javax.swing.SwingUtilities;
import org.intellij.plugins.relaxNG.compact.RncFileType;
import org.intellij.plugins.relaxNG.model.descriptors.RngElementDescriptor;
import org.intellij.plugins.relaxNG.validation.MessageViewHelper;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class ValidateAction
extends AnAction {
    private static final String CONTENT_NAME = "Validate RELAX NG";
    private static final Key<NewErrorTreeViewPanel> KEY = Key.create((String)"VALIDATING");
    private static final Key<Boolean> IN_PROGRESS_KEY = Key.create((String)"VALIDATION IN PROGRESS");
    private final AnAction myOrigAction;

    public ValidateAction(AnAction origAction) {
        this.myOrigAction = origAction;
        this.copyFrom(origAction);
        this.setEnabledInModalContext(origAction.isEnabledInModalContext());
    }

    public void actionPerformed(AnActionEvent e) {
        if (!this.actionPerformedImpl(e)) {
            this.myOrigAction.actionPerformed(e);
        }
    }

    public final void update(AnActionEvent e) {
        super.update(e);
        this.myOrigAction.update(e);
        VirtualFile file2 = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE);
        if (file2 != null && file2.getUserData(IN_PROGRESS_KEY) == Boolean.TRUE) {
            e.getPresentation().setEnabled(false);
        }
    }

    private boolean actionPerformedImpl(AnActionEvent e) {
        PsiFile file2 = (PsiFile)e.getData(CommonDataKeys.PSI_FILE);
        if (file2 == null) {
            return false;
        }
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        if (project == null) {
            return false;
        }
        RngElementDescriptor descriptor = ValidateAction.getRootDescriptor(file2);
        if (descriptor == null) {
            return false;
        }
        PsiElement element = descriptor.getDeclaration();
        XmlFile xmlFile = (XmlFile)PsiTreeUtil.getParentOfType((PsiElement)element, XmlFile.class);
        if (xmlFile == null) {
            return false;
        }
        VirtualFile instanceFile = file2.getVirtualFile();
        VirtualFile schemaFile = xmlFile.getVirtualFile();
        if (instanceFile == null || schemaFile == null) {
            return true;
        }
        ValidateAction.doRun(project, instanceFile, schemaFile);
        return true;
    }

    private static void doRun(Project project, VirtualFile instanceFile, VirtualFile schemaFile) {
        ValidateAction.saveFiles(instanceFile, schemaFile);
        MessageViewHelper helper = new MessageViewHelper(project, CONTENT_NAME, KEY);
        helper.openMessageView(() -> ValidateAction.doRun(project, instanceFile, schemaFile));
        final Future future2 = ApplicationManager.getApplication().executeOnPooledThread(() -> ApplicationManager.getApplication().runReadAction(() -> {
            MessageViewHelper.ErrorHandler eh = helper.new MessageViewHelper.ErrorHandler();
            instanceFile.putUserData(IN_PROGRESS_KEY, (Object)Boolean.TRUE);
            try {
                ValidateAction.doValidation(instanceFile, schemaFile, eh);
            }
            finally {
                instanceFile.putUserData(IN_PROGRESS_KEY, null);
            }
            SwingUtilities.invokeLater(() -> {
                if (!eh.hadErrorOrWarning()) {
                    SwingUtilities.invokeLater(() -> {
                        helper.close();
                        WindowManager.getInstance().getStatusBar(project).setInfo("No errors detected");
                    });
                }
            });
        }));
        helper.setProcessController(new NewErrorTreeViewPanel.ProcessController(){

            @Override
            public void stopProcess() {
                future2.cancel(true);
            }

            @Override
            public boolean isProcessStopped() {
                return future2.isDone();
            }
        });
    }

    private static void doValidation(VirtualFile instanceFile, VirtualFile schemaFile, ErrorHandler eh) {
        block7: {
            SchemaReader sr = schemaFile.getFileType() == RncFileType.getInstance() ? CompactSchemaReader.getInstance() : new AutoSchemaReader();
            PropertyMapBuilder properties = new PropertyMapBuilder();
            ValidateProperty.ERROR_HANDLER.put(properties, eh);
            RngProperty.CHECK_ID_IDREF.add(properties);
            try {
                String schemaPath = VfsUtilCore.fixIDEAUrl((String)schemaFile.getUrl());
                try {
                    ValidationDriver driver = new ValidationDriver(properties.toPropertyMap(), sr);
                    InputSource in = ValidationDriver.uriOrFileInputSource((String)schemaPath);
                    in.setEncoding(schemaFile.getCharset().name());
                    if (!driver.loadSchema(in)) break block7;
                    String path = VfsUtilCore.fixIDEAUrl((String)instanceFile.getUrl());
                    try {
                        driver.validate(ValidationDriver.uriOrFileInputSource((String)path));
                    }
                    catch (IOException e1) {
                        eh.fatalError(new SAXParseException(e1.getMessage(), null, UriOrFile.fileToUri((String)path), -1, -1, e1));
                    }
                }
                catch (SAXParseException e1) {
                    eh.fatalError(e1);
                }
                catch (IOException e1) {
                    eh.fatalError(new SAXParseException(e1.getMessage(), null, UriOrFile.fileToUri((String)schemaPath), -1, -1, e1));
                }
            }
            catch (MalformedURLException | SAXException e1) {
                Logger.getInstance((String)ValidateAction.class.getName()).error((Throwable)e1);
            }
        }
    }

    private static RngElementDescriptor getRootDescriptor(PsiFile file2) {
        try {
            XmlElementDescriptor descriptor;
            if (file2 instanceof XmlFile && (descriptor = ((XmlFile)file2).getDocument().getRootTag().getDescriptor()) instanceof RngElementDescriptor) {
                return (RngElementDescriptor)descriptor;
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return null;
    }

    public boolean displayTextInToolbar() {
        return this.myOrigAction.displayTextInToolbar();
    }

    public void setDefaultIcon(boolean b) {
        this.myOrigAction.setDefaultIcon(b);
    }

    public boolean isDefaultIcon() {
        return this.myOrigAction.isDefaultIcon();
    }

    public void setInjectedContext(boolean worksInInjected) {
        this.myOrigAction.setInjectedContext(worksInInjected);
    }

    public boolean isInInjectedContext() {
        return this.myOrigAction.isInInjectedContext();
    }

    public static void saveFiles(VirtualFile ... files) {
        FileDocumentManager mgr = FileDocumentManager.getInstance();
        for (VirtualFile f : files) {
            Document document = mgr.getDocument(f);
            if (document == null) continue;
            mgr.saveDocument(document);
        }
    }
}

