/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter.tslint.config.style.rules;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.intellij.lang.Language;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.linter.tslint.config.style.rules.TsLintConfigKt;
import com.intellij.lang.javascript.linter.tslint.config.style.rules.TsLintConfigOption;
import com.intellij.lang.javascript.linter.tslint.config.style.rules.TsLintConfigWrapper;
import com.intellij.lang.javascript.linter.tslint.config.style.rules.TsLintRulesKt;
import com.intellij.lang.javascript.linter.tslint.config.style.rules.TsLintSimpleRule;
import com.intellij.lang.typescript.formatter.TypeScriptCodeStyleSettings;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.util.ThrowableRunnable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0010\u0010\r\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000f0\u000eJ$\u0010\u0010\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0014\u0010\u0011\u001a\u0010\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000f\u0012\u0002\b\u00030\u0006J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0018\u0010\u0014\u001a\n \u0016*\u0004\u0018\u00010\u00150\u00152\u0006\u0010\u0017\u001a\u00020\u0013H\u0002J2\u0010\u0018\u001a\u0014\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000f\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u00062\u0006\u0010\u000b\u001a\u00020\f2\u0010\u0010\r\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000f0\u000eJ\u0010\u0010\u0019\u001a\u0004\u0018\u00010\b2\u0006\u0010\u001a\u001a\u00020\u0007J\u0018\u0010\u001b\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000f0\u000e2\u0006\u0010\u000b\u001a\u00020\fJ\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0017\u001a\u00020\u0013H\u0002R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/intellij/lang/javascript/linter/tslint/config/style/rules/TsLintConfigWrapper;", "", "config", "Lcom/google/gson/JsonObject;", "(Lcom/google/gson/JsonObject;)V", "options", "", "", "Lcom/intellij/lang/javascript/linter/tslint/config/style/rules/TsLintConfigOption;", "applyRules", "", "project", "Lcom/intellij/openapi/project/Project;", "rules", "", "Lcom/intellij/lang/javascript/linter/tslint/config/style/rules/TsLintSimpleRule;", "applyValues", "values", "current", "Lcom/intellij/psi/codeStyle/CodeStyleSettings;", "custom", "Lcom/intellij/lang/typescript/formatter/TypeScriptCodeStyleSettings;", "kotlin.jvm.PlatformType", "settings", "getCurrentSettings", "getOption", "name", "getRulesToApply", "language", "Lcom/intellij/psi/codeStyle/CommonCodeStyleSettings;", "tslint-idea"})
public final class TsLintConfigWrapper {
    private final Map<String, TsLintConfigOption> options;

    @Nullable
    public final TsLintConfigOption getOption(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        return this.options.get(name);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Collection<TsLintSimpleRule<?>> getRulesToApply(@NotNull Project project) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        CodeStyleSettings settings;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        ApplicationManager.getApplication().assertReadAccessAllowed();
        CodeStyleSettings codeStyleSettings = settings = this.current(project);
        Intrinsics.checkExpressionValueIsNotNull((Object)codeStyleSettings, (String)"settings");
        CommonCodeStyleSettings commonCodeStyleSettings = this.language(codeStyleSettings);
        if (commonCodeStyleSettings == null) {
            return CollectionsKt.emptyList();
        }
        CommonCodeStyleSettings languageSettings = commonCodeStyleSettings;
        TypeScriptCodeStyleSettings typeScriptCodeStyleSettings = this.custom(settings);
        if (typeScriptCodeStyleSettings == null) {
            return CollectionsKt.emptyList();
        }
        TypeScriptCodeStyleSettings jsCodeStyleSettings = typeScriptCodeStyleSettings;
        Iterable iterable = $receiver$iv = (Iterable)TsLintRulesKt.getTslintRulesSet();
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            TsLintSimpleRule it = (TsLintSimpleRule)element$iv$iv;
            CommonCodeStyleSettings commonCodeStyleSettings2 = languageSettings;
            Intrinsics.checkExpressionValueIsNotNull((Object)commonCodeStyleSettings2, (String)"languageSettings");
            if (!it.isAvailable(project, commonCodeStyleSettings2, (JSCodeStyleSettings)jsCodeStyleSettings, this)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final CodeStyleSettings current(Project project) {
        return CodeStyleSettingsManager.getInstance((Project)project).getCurrentSettings();
    }

    private final CommonCodeStyleSettings language(CodeStyleSettings settings) {
        return settings.getCommonSettings((Language)JavaScriptSupportLoader.TYPESCRIPT);
    }

    private final TypeScriptCodeStyleSettings custom(CodeStyleSettings settings) {
        return (TypeScriptCodeStyleSettings)settings.getCustomSettings(TypeScriptCodeStyleSettings.class);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Map<TsLintSimpleRule<?>, Object> getCurrentSettings(@NotNull Project project, @NotNull Collection<? extends TsLintSimpleRule<?>> rules) {
        void $receiver$iv$iv;
        CodeStyleSettings settings;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull(rules, (String)"rules");
        ApplicationManager.getApplication().assertReadAccessAllowed();
        CodeStyleSettings codeStyleSettings = settings = this.current(project);
        Intrinsics.checkExpressionValueIsNotNull((Object)codeStyleSettings, (String)"settings");
        CommonCodeStyleSettings commonCodeStyleSettings = this.language(codeStyleSettings);
        if (commonCodeStyleSettings == null) {
            return MapsKt.emptyMap();
        }
        CommonCodeStyleSettings languageSettings = commonCodeStyleSettings;
        TypeScriptCodeStyleSettings typeScriptCodeStyleSettings = this.custom(settings);
        if (typeScriptCodeStyleSettings == null) {
            return MapsKt.emptyMap();
        }
        TypeScriptCodeStyleSettings jsCodeStyleSettings = typeScriptCodeStyleSettings;
        Iterable $receiver$iv = rules;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10)), (int)16);
        Iterable iterable = $receiver$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        for (Object element$iv$iv : $receiver$iv$iv) {
            Map map = destination$iv$iv;
            TsLintSimpleRule it = (TsLintSimpleRule)element$iv$iv;
            CommonCodeStyleSettings commonCodeStyleSettings2 = languageSettings;
            Intrinsics.checkExpressionValueIsNotNull((Object)commonCodeStyleSettings2, (String)"languageSettings");
            Pair pair = new Pair((Object)it, it.getSettingsValue(commonCodeStyleSettings2, (JSCodeStyleSettings)jsCodeStyleSettings));
            map.put(pair.getFirst(), pair.getSecond());
        }
        return destination$iv$iv;
    }

    public final void applyValues(@NotNull Project project, @NotNull Map<TsLintSimpleRule<?>, ?> values) {
        CodeStyleSettings settings;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull(values, (String)"values");
        CodeStyleSettings codeStyleSettings = settings = this.current(project);
        Intrinsics.checkExpressionValueIsNotNull((Object)codeStyleSettings, (String)"settings");
        CommonCodeStyleSettings commonCodeStyleSettings = this.language(codeStyleSettings);
        if (commonCodeStyleSettings == null) {
            return;
        }
        CommonCodeStyleSettings languageSettings = commonCodeStyleSettings;
        TypeScriptCodeStyleSettings typeScriptCodeStyleSettings = this.custom(settings);
        if (typeScriptCodeStyleSettings == null) {
            return;
        }
        TypeScriptCodeStyleSettings jsCodeStyleSettings = typeScriptCodeStyleSettings;
        WriteAction.run((ThrowableRunnable)new ThrowableRunnable<E>(values, languageSettings, jsCodeStyleSettings){
            final /* synthetic */ Map $values;
            final /* synthetic */ CommonCodeStyleSettings $languageSettings;
            final /* synthetic */ TypeScriptCodeStyleSettings $jsCodeStyleSettings;

            public final void run() {
                this.$values.forEach((BiConsumer)new BiConsumer<TsLintSimpleRule<?>, Object>(this){
                    final /* synthetic */ applyValues.1 this$0;

                    public final void accept(@NotNull TsLintSimpleRule<?> key, @Nullable Object value) {
                        Intrinsics.checkParameterIsNotNull(key, (String)"key");
                        CommonCodeStyleSettings commonCodeStyleSettings = this.this$0.$languageSettings;
                        Intrinsics.checkExpressionValueIsNotNull((Object)commonCodeStyleSettings, (String)"languageSettings");
                        key.setDirectValue(commonCodeStyleSettings, (JSCodeStyleSettings)this.this$0.$jsCodeStyleSettings, value);
                    }
                    {
                        this.this$0 = var1_1;
                    }
                });
            }
            {
                this.$values = map;
                this.$languageSettings = commonCodeStyleSettings;
                this.$jsCodeStyleSettings = typeScriptCodeStyleSettings;
            }
        });
    }

    public final void applyRules(@NotNull Project project, @NotNull Collection<? extends TsLintSimpleRule<?>> rules) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull(rules, (String)"rules");
        WriteAction.run((ThrowableRunnable)new ThrowableRunnable<E>(this, project, rules){
            final /* synthetic */ TsLintConfigWrapper this$0;
            final /* synthetic */ Project $project;
            final /* synthetic */ Collection $rules;

            public final void run() {
                CodeStyleSettings newSettings;
                CodeStyleSettingsManager settingsManager = CodeStyleSettingsManager.getInstance((Project)this.$project);
                if (!settingsManager.USE_PER_PROJECT_SETTINGS) {
                    settingsManager.PER_PROJECT_SETTINGS = settingsManager.getCurrentSettings().clone();
                    settingsManager.USE_PER_PROJECT_SETTINGS = true;
                }
                CodeStyleSettings codeStyleSettings = newSettings = settingsManager.getCurrentSettings();
                Intrinsics.checkExpressionValueIsNotNull((Object)codeStyleSettings, (String)"newSettings");
                CommonCodeStyleSettings newLanguageSettings = TsLintConfigWrapper.access$language(this.this$0, codeStyleSettings);
                TypeScriptCodeStyleSettings newJsCodeStyleSettings = TsLintConfigWrapper.access$custom(this.this$0, newSettings);
                Iterable $receiver$iv = this.$rules;
                for (T element$iv : $receiver$iv) {
                    TsLintSimpleRule rule = (TsLintSimpleRule)element$iv;
                    CommonCodeStyleSettings commonCodeStyleSettings = newLanguageSettings;
                    Intrinsics.checkExpressionValueIsNotNull((Object)commonCodeStyleSettings, (String)"newLanguageSettings");
                    TypeScriptCodeStyleSettings typeScriptCodeStyleSettings = newJsCodeStyleSettings;
                    Intrinsics.checkExpressionValueIsNotNull((Object)typeScriptCodeStyleSettings, (String)"newJsCodeStyleSettings");
                    rule.apply(this.$project, commonCodeStyleSettings, (JSCodeStyleSettings)typeScriptCodeStyleSettings, this.this$0);
                }
            }
            {
                this.this$0 = tsLintConfigWrapper;
                this.$project = project;
                this.$rules = collection;
            }
        });
    }

    public TsLintConfigWrapper(@NotNull JsonObject config) {
        Intrinsics.checkParameterIsNotNull((Object)config, (String)"config");
        Map result = new LinkedHashMap();
        for (Object element$iv : (Object[])TsLintConfigKt.access$getTO_PROCESS$p()) {
            JsonElement jsRules;
            String name = (String)element$iv;
            if (!config.has(name) || !(jsRules = config.get(name)).isJsonObject()) continue;
            Iterable $receiver$iv = jsRules.getAsJsonObject().entrySet();
            for (Object element$iv2 : $receiver$iv) {
                Object k;
                Map.Entry it = (Map.Entry)element$iv2;
                Map map = result;
                Intrinsics.checkExpressionValueIsNotNull(it.getKey(), (String)"it.key");
                Object v = it.getValue();
                Intrinsics.checkExpressionValueIsNotNull(v, (String)"it.value");
                TsLintConfigOption tsLintConfigOption = new TsLintConfigOption((JsonElement)v);
                map.put(k, tsLintConfigOption);
            }
        }
        this.options = result;
    }

    @NotNull
    public static final /* synthetic */ CommonCodeStyleSettings access$language(TsLintConfigWrapper $this, @NotNull CodeStyleSettings settings) {
        return $this.language(settings);
    }

    public static final /* synthetic */ TypeScriptCodeStyleSettings access$custom(TsLintConfigWrapper $this, @NotNull CodeStyleSettings settings) {
        return $this.custom(settings);
    }
}

