/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger;

import com.intellij.javascript.debugger.JavaScriptDebuggerViewSupport;
import com.intellij.javascript.debugger.JavaScriptNameMapper;
import com.intellij.javascript.debugger.MemberFilterVisitorKt;
import com.intellij.javascript.debugger.MyMemberFilter;
import com.intellij.javascript.debugger.NameMapper;
import com.intellij.javascript.debugger.VariablesAndExpressionsCollector;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSSourceElement;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.util.Function;
import com.intellij.xdebugger.XSourcePosition;
import com.jetbrains.javascript.debugger.JavaScriptDebugAware;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;
import org.jetbrains.debugger.CallFrame;
import org.jetbrains.debugger.MemberFilter;
import org.jetbrains.debugger.PsiVisitors;
import org.jetbrains.debugger.Script;
import org.jetbrains.debugger.Vm;
import org.jetbrains.debugger.frame.CallFrameView;
import org.jetbrains.debugger.sourcemap.MappingEntry;
import org.jetbrains.debugger.sourcemap.SourceMap;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\"\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00020\u000bJ\u0018\u0010\u000f\u001a\n \u0010*\u0004\u0018\u00010\u00020\u00022\u0006\u0010\f\u001a\u00020\rH\u0002J(\u0010\u0011\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/intellij/javascript/debugger/MemberFilterVisitor;", "Lorg/jetbrains/debugger/PsiVisitors$Visitor;", "Lorg/jetbrains/debugger/MemberFilter;", "viewSupport", "Lcom/intellij/javascript/debugger/JavaScriptDebuggerViewSupport;", "callFrameView", "Lorg/jetbrains/debugger/frame/CallFrameView;", "(Lcom/intellij/javascript/debugger/JavaScriptDebuggerViewSupport;Lorg/jetbrains/debugger/frame/CallFrameView;)V", "transpiledFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "compute", "Lorg/jetbrains/concurrency/Promise;", "position", "Lcom/intellij/xdebugger/XSourcePosition;", "defaultMemberFilterPromise", "doCompute", "kotlin.jvm.PlatformType", "visit", "element", "Lcom/intellij/psi/PsiElement;", "positionOffset", "", "document", "Lcom/intellij/openapi/editor/Document;", "JavaScriptDebugger"})
public final class MemberFilterVisitor
implements PsiVisitors.Visitor<MemberFilter> {
    private VirtualFile transpiledFile;
    private final JavaScriptDebuggerViewSupport viewSupport;
    private final CallFrameView callFrameView;

    @NotNull
    public final Promise<MemberFilter> compute(@NotNull XSourcePosition position, @NotNull Promise<MemberFilter> defaultMemberFilterPromise) {
        Promise promise;
        SourceMap sourceMap;
        Script script;
        Intrinsics.checkParameterIsNotNull((Object)position, (String)"position");
        Intrinsics.checkParameterIsNotNull(defaultMemberFilterPromise, (String)"defaultMemberFilterPromise");
        Script script2 = script = this.callFrameView.getScript();
        Object object = sourceMap = script2 != null ? script2.getSourceMap() : null;
        if (sourceMap != null && (sourceMap.getHasNameMappings() || Registry.is((String)"js.debugger.map.this.by.source.code", (boolean)false))) {
            Vm vm = this.callFrameView.getVm();
            if (vm == null) {
                Intrinsics.throwNpe();
            }
            Promise promise2 = MemberFilterVisitorKt.findTranspiledFile(this.viewSupport, vm, script).then(new Function<T, SUB_RESULT>(this, position){
                final /* synthetic */ MemberFilterVisitor this$0;
                final /* synthetic */ XSourcePosition $position;

                public final MemberFilter fun(VirtualFile it) {
                    MemberFilterVisitor.access$setTranspiledFile$p(this.this$0, it);
                    return MemberFilterVisitor.access$doCompute(this.this$0, this.$position);
                }
                {
                    this.this$0 = memberFilterVisitor;
                    this.$position = xSourcePosition;
                }
            });
            Intrinsics.checkExpressionValueIsNotNull((Object)promise2, (String)"viewSupport.findTranspil\u2026mpute(position)\n        }");
            return promise2;
        }
        MemberFilter result = this.doCompute(position);
        if (result == this.viewSupport) {
            promise = defaultMemberFilterPromise;
        } else {
            MemberFilter memberFilter = result;
            Intrinsics.checkExpressionValueIsNotNull((Object)memberFilter, (String)"result");
            promise = Promises.resolvedPromise((Object)memberFilter);
        }
        return promise;
    }

    private final MemberFilter doCompute(XSourcePosition position) {
        return (MemberFilter)PsiVisitors.visit((XSourcePosition)position, (Project)this.viewSupport.getDebugProcess().getSession().getProject(), (PsiVisitors.Visitor)this, (Object)((Object)this.viewSupport));
    }

    @NotNull
    public MemberFilter visit(@NotNull XSourcePosition position, @NotNull PsiElement element, int positionOffset, @NotNull Document document) {
        JSFunction jsFun;
        SourceMap sourceMap;
        Intrinsics.checkParameterIsNotNull((Object)position, (String)"position");
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        Intrinsics.checkParameterIsNotNull((Object)document, (String)"document");
        NameMapper nameMapper = null;
        Script script = this.callFrameView.getScript();
        Object object = sourceMap = script != null ? script.getSourceMap() : null;
        if (sourceMap != null && this.transpiledFile != null) {
            Document transpiledDocument;
            FileDocumentManager fileDocumentManager = FileDocumentManager.getInstance();
            VirtualFile virtualFile = this.transpiledFile;
            if (virtualFile == null) {
                Intrinsics.throwNpe();
            }
            if ((transpiledDocument = fileDocumentManager.getDocument(virtualFile)) != null && transpiledDocument.getTextLength() > 0) {
                CallFrame callFrame = this.callFrameView.getCallFrame();
                MappingEntry mappingEntry = sourceMap.getGeneratedMappings().get(callFrame.getLine(), callFrame.getColumn());
                if (mappingEntry != null) {
                    MappingEntry mappingEntry2;
                    MappingEntry it = mappingEntry2 = mappingEntry;
                    nameMapper = new JavaScriptNameMapper(document, transpiledDocument, sourceMap.findSourceMappings(it.getSource()), sourceMap, this.transpiledFile);
                }
            }
        }
        for (JavaScriptDebugAware debugAware : (MappingEntry)JavaScriptDebugAware.Companion.getEP_NAME().getExtensions()) {
            MemberFilter $i$a$1$let;
            MemberFilter memberFilter = debugAware.createMemberFilter(nameMapper, element, positionOffset);
            if (memberFilter == null) continue;
            MemberFilter it = $i$a$1$let = memberFilter;
            return it;
        }
        JSFunction jSFunction = jsFun = MemberFilterVisitorKt.access$getParentFunction(element);
        PsiElement psiElement = jSFunction != null ? (PsiElement)jSFunction : (PsiElement)element.getContainingFile();
        if (psiElement == null) {
            return (MemberFilter)this.viewSupport;
        }
        PsiElement host = psiElement;
        VariablesAndExpressionsCollector visitor = new VariablesAndExpressionsCollector(positionOffset, host, nameMapper);
        if (jsFun == null) {
            host.accept((PsiElementVisitor)visitor);
        } else {
            NameMapper nameMapper2 = nameMapper;
            if (nameMapper2 != null) {
                NameMapper it;
                NameMapper nameMapper3 = it = nameMapper2;
                for (Object element$iv : (Object[])jsFun.getParameterVariables()) {
                    JSParameter it2;
                    JSParameter jSParameter = it2 = (JSParameter)element$iv;
                    Intrinsics.checkExpressionValueIsNotNull((Object)jSParameter, (String)"it");
                    NameMapper.map$default((NameMapper)nameMapper3, (PsiElement)((PsiElement)jSParameter), (boolean)false, (int)2, null);
                }
            }
            for (JSSourceElement sourceElement : jsFun.getBody()) {
                sourceElement.accept((PsiElementVisitor)visitor);
            }
        }
        Set<String> set = visitor.getVariableDeclaredAfter();
        Collection collection = visitor.getExpressions();
        Object object2 = nameMapper;
        if (object2 == null || (object2 = object2.getRawNameToSource()) == null) {
            object2 = MapsKt.emptyMap();
        }
        return (MemberFilter)new MyMemberFilter(set, collection, (Map<String, String>)object2, this.viewSupport.getDebugProcess());
    }

    public MemberFilterVisitor(@NotNull JavaScriptDebuggerViewSupport viewSupport, @NotNull CallFrameView callFrameView) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)viewSupport), (String)"viewSupport");
        Intrinsics.checkParameterIsNotNull((Object)callFrameView, (String)"callFrameView");
        this.viewSupport = viewSupport;
        this.callFrameView = callFrameView;
    }

    @Nullable
    public static final /* synthetic */ VirtualFile access$getTranspiledFile$p(MemberFilterVisitor $this) {
        return $this.transpiledFile;
    }

    public static final /* synthetic */ void access$setTranspiledFile$p(MemberFilterVisitor $this, @Nullable VirtualFile virtualFile) {
        $this.transpiledFile = virtualFile;
    }

    public static final /* synthetic */ MemberFilter access$doCompute(MemberFilterVisitor $this, @NotNull XSourcePosition position) {
        return $this.doCompute(position);
    }
}

