/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger.scripts;

import com.google.common.base.CharMatcher;
import com.google.common.base.Splitter;
import com.intellij.icons.AllIcons;
import com.intellij.javascript.debugger.scripts.DirectoryInfo;
import com.intellij.javascript.debugger.scripts.FileInfo;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PlatformIcons;
import com.intellij.util.SmartList;
import com.intellij.util.Url;
import com.intellij.util.Urls;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ContainerUtilRt;
import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.debugger.Script;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=2, d1={"\u0000:\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\u001a*\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0000\u001a\u001a\u0010\u000f\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\n2\b\u0010\u0010\u001a\u0004\u0018\u00010\fH\u0002\u001a\u0016\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\t\u001a\u00020\nH\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0016\u0010\u0002\u001a\n \u0004*\u0004\u0018\u00010\u00030\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "PATH_SPLITTER", "Lcom/google/common/base/Splitter;", "kotlin.jvm.PlatformType", "addEntry", "", "script", "Lorg/jetbrains/debugger/Script;", "url", "Lcom/intellij/util/Url;", "parentInfo", "Lcom/intellij/javascript/debugger/scripts/DirectoryInfo;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "removeEntry", "directoryInfo", "splitUrl", "", "", "JavaScriptDebugger"})
public final class DirectoryInfoKt {
    private static final Splitter PATH_SPLITTER = Splitter.on((CharMatcher)CharMatcher.anyOf((CharSequence)"/\\")).omitEmptyStrings();
    private static final Logger LOG = Logger.getInstance(DirectoryInfo.class);

    /*
     * WARNING - void declaration
     */
    private static final void removeEntry(Url url, DirectoryInfo directoryInfo) {
        Object child = directoryInfo;
        List<String> path = DirectoryInfoKt.splitUrl(url);
        int childIndex = 0;
        SmartList parents = new SmartList();
        while (true) {
            FileInfo fileInfo;
            String name = path.get(childIndex++);
            if (path.size() == childIndex) {
                THashMap<String, FileInfo> tHashMap = child;
                if (tHashMap != null && (tHashMap = tHashMap.getChildNameToInfo()) != null) {
                    FileInfo cfr_ignored_0 = (FileInfo)tHashMap.remove((Object)name);
                }
                break;
            }
            THashMap<String, FileInfo> tHashMap = child;
            if (!((tHashMap != null && (tHashMap = tHashMap.getChildNameToInfo()) != null ? (FileInfo)tHashMap.get((Object)name) : (fileInfo = null)) instanceof DirectoryInfo)) {
                fileInfo = null;
            }
            if ((child = (DirectoryInfo)fileInfo) == null) {
                return;
            }
            parents.add(child);
        }
        int name = parents.size() - 1;
        int n = 1;
        while (name >= n) {
            void i;
            DirectoryInfo parent = (DirectoryInfo)parents.get((int)i);
            if (!parent.hasChildren()) {
                ((DirectoryInfo)parents.get((int)(i - true))).getChildNameToInfo().remove((Object)parent.getName());
            }
            --i;
        }
    }

    public static final void addEntry(@NotNull Script script, @NotNull Url url, @NotNull DirectoryInfo parentInfo, @Nullable VirtualFile file) {
        Intrinsics.checkParameterIsNotNull((Object)script, (String)"script");
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        Intrinsics.checkParameterIsNotNull((Object)parentInfo, (String)"parentInfo");
        DirectoryInfo parent = parentInfo;
        Icon directoryIcon = parent.getIcon() == PlatformIcons.LIBRARY_ICON || parent.getIcon() == AllIcons.Nodes.PpLibFolder ? AllIcons.Nodes.PpLibFolder : PlatformIcons.FOLDER_ICON;
        List<String> path = DirectoryInfoKt.splitUrl(url);
        boolean prependSlash = false;
        StringBuilder urlBuilder = new StringBuilder();
        int i = 0;
        while (true) {
            DirectoryInfo child;
            FileInfo fileInfo;
            String name = path.get(i);
            if (prependSlash) {
                urlBuilder.append('/');
            } else {
                prependSlash = true;
            }
            if (path.size() - 1 == i) {
                if (script.getLine() > 0 && Intrinsics.areEqual((Object)script.getUrl(), (Object)url)) {
                    name = name + ':' + Integer.toString(script.getLine() + 1) + ':' + Integer.toString(script.getColumn() + 1);
                }
                if ((fileInfo = (FileInfo)parent.getChildNameToInfo().get((Object)name)) == null) {
                    fileInfo = new FileInfo(name, url, (List)new SmartList((Object)script));
                    if (file != null) {
                        fileInfo.set_icon$JavaScriptDebugger(file.getFileType().getIcon());
                    }
                    parent.getChildNameToInfo().put((Object)name, (Object)fileInfo);
                    break;
                }
                if (Intrinsics.areEqual((Object)fileInfo.getUrl().trimParameters(), (Object)url.trimParameters()) ^ true) {
                    LOG.error("fileInfo.url: " + fileInfo.getUrl() + ", url: " + url);
                }
                if (fileInfo instanceof DirectoryInfo) {
                    ((DirectoryInfo)fileInfo).getChildNameToInfo().put((Object)fileInfo.getName(), (Object)new FileInfo(fileInfo.getName(), fileInfo.getUrl(), (List)new SmartList((Object)script)));
                    break;
                }
                fileInfo.addScript$JavaScriptDebugger(script);
                break;
            }
            urlBuilder.append(name);
            fileInfo = (FileInfo)parent.getChildNameToInfo().get((Object)name);
            FileInfo fileInfo2 = fileInfo;
            if (!(fileInfo2 instanceof DirectoryInfo)) {
                fileInfo2 = null;
            }
            if ((child = (DirectoryInfo)fileInfo2) == null) {
                Url url2 = Urls.newFromIdea((CharSequence)urlBuilder);
                Intrinsics.checkExpressionValueIsNotNull((Object)url2, (String)"Urls.newFromIdea(urlBuilder)");
                Icon icon = directoryIcon;
                Intrinsics.checkExpressionValueIsNotNull((Object)icon, (String)"directoryIcon");
                child = new DirectoryInfo(name, url2, icon);
                if (fileInfo != null) {
                    child.getChildNameToInfo().put((Object)name, (Object)fileInfo);
                }
                parent.getChildNameToInfo().put((Object)name, (Object)child);
            }
            parent = child;
            ++i;
        }
    }

    private static final List<String> splitUrl(Url url) {
        List result;
        String path = url.getPath();
        if (Intrinsics.areEqual((Object)path, (Object)"/")) {
            result = new ArrayList();
            StringBuilder stringBuilder = new StringBuilder();
            String string = url.getScheme();
            if (string == null) {
                Intrinsics.throwNpe();
            }
            result.add(stringBuilder.append(string).append("://").append(url.getAuthority()).toString());
        } else {
            Iterable strings = PATH_SPLITTER.split((CharSequence)path);
            if (url.getAuthority() == null) {
                ArrayList arrayList = ContainerUtilRt.newArrayList((Iterable)strings);
                Intrinsics.checkExpressionValueIsNotNull((Object)arrayList, (String)"ContainerUtilRt.newArrayList(strings)");
                result = arrayList;
                if (result.isEmpty()) {
                    LOG.error("url: " + url.toExternalForm() + ", path: " + path);
                }
                if (url.getScheme() != null) {
                    StringBuilder stringBuilder = new StringBuilder();
                    String string = url.getScheme();
                    if (string == null) {
                        Intrinsics.throwNpe();
                    }
                    result.set(0, stringBuilder.append(string).append(':').append((String)result.get(0)).toString());
                } else if (url.isInLocalFileSystem() && StringUtil.startsWithChar((CharSequence)path, (char)'/')) {
                    result.set(0, '/' + (String)result.get(0));
                }
            } else {
                result = new ArrayList();
                StringBuilder stringBuilder = new StringBuilder();
                String string = url.getScheme();
                if (string == null) {
                    Intrinsics.throwNpe();
                }
                result.add(stringBuilder.append(string).append("://").append(url.getAuthority()).toString());
                ContainerUtil.addAll((Collection)result, (Iterable)strings);
            }
        }
        if (StringsKt.endsWith$default((CharSequence)path, (char)'/', (boolean)false, (int)2, null) && url.getParameters() == null) {
            result.add("(program)");
        }
        if (url.getParameters() != null && !StringsKt.endsWith$default((String)path, (String)".js", (boolean)false, (int)2, null) && !StringsKt.endsWith$default((String)path, (String)".dart", (boolean)false, (int)2, null)) {
            int lastIndex = result.size() - 1;
            if (lastIndex == 0 && url.getAuthority() != null) {
                String string = url.getParameters();
                if (string == null) {
                    Intrinsics.throwNpe();
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"url.parameters!!");
                result.add(string);
            } else {
                StringBuilder stringBuilder = new StringBuilder().append((String)result.get(lastIndex));
                String string = url.getParameters();
                if (string == null) {
                    Intrinsics.throwNpe();
                }
                result.set(lastIndex, stringBuilder.append(string).toString());
            }
        }
        return result;
    }

    public static final /* synthetic */ void access$removeEntry(@NotNull Url url, @Nullable DirectoryInfo directoryInfo) {
        DirectoryInfoKt.removeEntry(url, directoryInfo);
    }
}

