/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.datastore;

import com.intellij.openapi.diagnostic.Logger;
import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import org.jetbrains.annotations.NotNull;

public class DataStoreDatabase {
    private final Connection myConnection;

    private static Logger getLogger() {
        return Logger.getInstance(DataStoreDatabase.class);
    }

    public DataStoreDatabase(@NotNull String dbPath, @NotNull Characteristic characteristic) {
        if (dbPath == null) {
            DataStoreDatabase.$$$reportNull$$$0(0);
        }
        if (characteristic == null) {
            DataStoreDatabase.$$$reportNull$$$0(1);
        }
        Connection connection = null;
        try {
            Class.forName("org.sqlite.JDBC");
            switch (characteristic) {
                case PERFORMANT: {
                    connection = DriverManager.getConnection("jdbc:sqlite::memory:");
                    break;
                }
                case DURABLE: {
                    File dbFile = new File(dbPath);
                    File parent = dbFile.getParentFile();
                    if (parent != null && !parent.mkdirs() && !parent.exists()) {
                        DataStoreDatabase.getLogger().error("Unable to create parent directory");
                    }
                    connection = DriverManager.getConnection(String.format("jdbc:sqlite:%s", dbFile.getPath()));
                    break;
                }
                default: {
                    throw new RuntimeException("Characteristic not handled!");
                }
            }
            connection.setAutoCommit(false);
        }
        catch (ClassNotFoundException | SQLException e) {
            DataStoreDatabase.getLogger().error((Throwable)e);
        }
        this.myConnection = connection;
    }

    public void disconnect() {
        try {
            this.myConnection.commit();
        }
        catch (SQLException e) {
            DataStoreDatabase.getLogger().error((Throwable)e);
        }
        finally {
            try {
                if (!this.myConnection.isClosed()) {
                    this.myConnection.close();
                }
            }
            catch (SQLException e) {
                DataStoreDatabase.getLogger().error((Throwable)e);
            }
        }
    }

    public Connection getConnection() {
        return this.myConnection;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "dbPath";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "characteristic";
                break;
            }
        }
        objectArray[1] = "com/android/tools/datastore/DataStoreDatabase";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static enum Characteristic {
        DURABLE,
        PERFORMANT;

    }
}

