/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.datastore.database;

import com.android.tools.datastore.database.DataStoreTable;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profiler.proto.MemoryProfiler;
import com.google.protobuf3jarjar.InvalidProtocolBufferException;
import com.intellij.openapi.diagnostic.Logger;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class MemoryLiveAllocationTable
extends DataStoreTable<MemoryStatements> {
    private int myAllocationCountLimit;

    private static Logger getLogger() {
        return Logger.getInstance(MemoryLiveAllocationTable.class);
    }

    public MemoryLiveAllocationTable(@NotNull Map<Common.Session, Long> sesstionIdLookup) {
        if (sesstionIdLookup == null) {
            MemoryLiveAllocationTable.$$$reportNull$$$0(0);
        }
        super(sesstionIdLookup);
        this.myAllocationCountLimit = 5000000;
    }

    @Override
    public void initialize(@NotNull Connection connection) {
        if (connection == null) {
            MemoryLiveAllocationTable.$$$reportNull$$$0(1);
        }
        super.initialize(connection);
        try {
            this.createTable("Memory_AllocatedClass", "Pid INTEGER NOT NULL", "Session INTEGER NOT NULL", "Tag INTEGER", "AllocTime INTEGER", "Name TEXT", "PRIMARY KEY(Pid, Session, Tag)");
            this.createTable("Memory_AllocationEvents", "Pid INTEGER NOT NULL", "Session INTEGER NOT NULL", "Tag INTEGER", "ClassTag INTEGER", "AllocTime INTEGER", "FreeTime INTEGER", "Size INTEGER", "Length INTEGER", "ThreadId INTEGER", "StackId INTEGER", "HeapId INTEGER", "PRIMARY KEY(Pid, Session, Tag)");
            this.createTable("Memory_MethodInfos", "Pid INTEGER NOT NULL", "Session INTEGER NOT NULL", "MethodId INTEGER", "MethodName TEXT", "ClassName TEXT", "PRIMARY KEY(Pid, Session, MethodId)");
            this.createTable("Memory_StackInfos", "Pid INTEGER NOT NULL", "Session INTEGER NOT NULL", "StackId INTEGER", "AllocTime INTEGER", "StackData BLOB", "PRIMARY KEY(Pid, Session, StackId)");
            this.createTable("Memory_ThreadInfos", "Pid INTEGER NOT NULL", "Session INTEGER NOT NULL", "ThreadId INTEGER", "AllocTime INTEGER", "ThreadName TEXT", "PRIMARY KEY(Pid, Session, ThreadId)");
            this.createIndex("Memory_AllocationEvents", 0, "Pid", "Session", "AllocTime");
            this.createIndex("Memory_AllocationEvents", 1, "Pid", "Session", "FreeTime");
            this.createIndex("Memory_AllocatedClass", 0, "Pid", "Session", "AllocTime");
            this.createIndex("Memory_StackInfos", 0, "Pid", "Session", "AllocTime");
            this.createIndex("Memory_ThreadInfos", 0, "Pid", "Session", "AllocTime");
        }
        catch (SQLException ex) {
            MemoryLiveAllocationTable.getLogger().error((Throwable)ex);
        }
    }

    void setAllocationCountLimit(int allocationCountLimit) {
        this.myAllocationCountLimit = allocationCountLimit;
    }

    @Override
    public void prepareStatements() {
        try {
            for (MemoryStatements statement : MemoryStatements.values()) {
                this.createStatement(statement, statement.getStatement());
            }
        }
        catch (SQLException ex) {
            MemoryLiveAllocationTable.getLogger().error((Throwable)ex);
        }
    }

    public MemoryProfiler.BatchAllocationSample getAllocations(int pid, Common.Session session, long startTime, long endTime) {
        MemoryProfiler.BatchAllocationSample.Builder sampleBuilder = MemoryProfiler.BatchAllocationSample.newBuilder();
        try {
            ResultSet allocResult = this.executeQuery(MemoryStatements.QUERY_ALLOC_BY_ALLOC_TIME, pid, session, startTime, endTime);
            long timestamp = Long.MIN_VALUE;
            while (allocResult.next()) {
                long allocTime = allocResult.getLong(3);
                if (allocTime < startTime) continue;
                MemoryProfiler.AllocationEvent event = MemoryProfiler.AllocationEvent.newBuilder().setAllocData(MemoryProfiler.AllocationEvent.Allocation.newBuilder().setTag(allocResult.getInt(1)).setClassTag(allocResult.getInt(2)).setSize(allocResult.getLong(5)).setLength(allocResult.getInt(6)).setThreadId(allocResult.getInt(7)).setStackId(allocResult.getInt(8)).setHeapId(allocResult.getInt(9)).build()).setTimestamp(allocTime).build();
                sampleBuilder.addEvents(event);
                timestamp = Math.max(timestamp, allocTime);
            }
            ResultSet freeResult = this.executeQuery(MemoryStatements.QUERY_ALLOC_BY_FREE_TIME, pid, session, startTime, endTime);
            while (freeResult.next()) {
                long freeTime = freeResult.getLong(4);
                if (freeTime >= endTime) continue;
                MemoryProfiler.AllocationEvent event = MemoryProfiler.AllocationEvent.newBuilder().setFreeData(MemoryProfiler.AllocationEvent.Deallocation.newBuilder().setTag(freeResult.getInt(1)).setClassTag(freeResult.getInt(2)).setSize(freeResult.getLong(5)).setLength(freeResult.getInt(6)).setThreadId(freeResult.getInt(7)).setStackId(freeResult.getInt(8)).setHeapId(freeResult.getInt(9)).build()).setTimestamp(freeTime).build();
                sampleBuilder.addEvents(event);
                timestamp = Math.max(timestamp, freeTime);
            }
            sampleBuilder.setTimestamp(timestamp);
        }
        catch (SQLException ex) {
            MemoryLiveAllocationTable.getLogger().error((Throwable)ex);
        }
        return sampleBuilder.build();
    }

    @NotNull
    public MemoryProfiler.AllocationContextsResponse getAllocationContexts(int pid, Common.Session session, long startTime, long endTime) {
        MemoryProfiler.AllocationContextsResponse.Builder resultBuilder = MemoryProfiler.AllocationContextsResponse.newBuilder();
        try {
            ResultSet klassResult = this.executeQuery(MemoryStatements.QUERY_CLASS, pid, session, startTime, endTime);
            long timestamp = Long.MIN_VALUE;
            while (klassResult.next()) {
                long allocTime = klassResult.getLong(2);
                MemoryProfiler.AllocatedClass klass = MemoryProfiler.AllocatedClass.newBuilder().setClassId(klassResult.getInt(1)).setClassName(klassResult.getString(3)).build();
                resultBuilder.addAllocatedClasses(klass);
                timestamp = Math.max(timestamp, allocTime);
            }
            ResultSet stackResult = this.executeQuery(MemoryStatements.QUERY_ENCODED_STACK_INFO_BY_TIME, pid, session, startTime, endTime);
            while (stackResult.next()) {
                MemoryProfiler.AllocationStack.Builder stackBuilder = MemoryProfiler.AllocationStack.newBuilder();
                MemoryProfiler.EncodedAllocationStack encodedStack = MemoryProfiler.EncodedAllocationStack.parseFrom((byte[])stackResult.getBytes(1));
                stackBuilder.setStackId(encodedStack.getStackId());
                MemoryProfiler.AllocationStack.SmallFrameWrapper.Builder frameBuilder = MemoryProfiler.AllocationStack.SmallFrameWrapper.newBuilder();
                assert (encodedStack.getMethodIdsCount() == encodedStack.getLineNumbersCount());
                for (int i = 0; i < encodedStack.getMethodIdsCount(); ++i) {
                    MemoryProfiler.AllocationStack.SmallFrame frame = MemoryProfiler.AllocationStack.SmallFrame.newBuilder().setMethodId(encodedStack.getMethodIds(i)).setLineNumber(encodedStack.getLineNumbers(i)).build();
                    frameBuilder.addFrames(frame);
                }
                stackBuilder.setSmallStack(frameBuilder);
                resultBuilder.addAllocationStacks(stackBuilder);
            }
            ResultSet threadResult = this.executeQuery(MemoryStatements.QUERY_THREAD_INFO_BY_TIME, pid, session, startTime, endTime);
            while (threadResult.next()) {
                MemoryProfiler.ThreadInfo thread = MemoryProfiler.ThreadInfo.newBuilder().setThreadId(threadResult.getInt(1)).setThreadName(threadResult.getString(2)).build();
                resultBuilder.addAllocationThreads(thread);
            }
            resultBuilder.setTimestamp(timestamp);
        }
        catch (InvalidProtocolBufferException | SQLException ex) {
            MemoryLiveAllocationTable.getLogger().error(ex);
        }
        MemoryProfiler.AllocationContextsResponse allocationContextsResponse = resultBuilder.build();
        if (allocationContextsResponse == null) {
            MemoryLiveAllocationTable.$$$reportNull$$$0(2);
        }
        return allocationContextsResponse;
    }

    public void insertAllocationData(int pid, Common.Session session, MemoryProfiler.BatchAllocationSample sample) {
        MemoryProfiler.AllocationEvent.EventCase currentCase = null;
        Statement currentStatement = null;
        int allocAndFreeCount = 0;
        try {
            for (MemoryProfiler.AllocationEvent event : sample.getEventsList()) {
                if (currentCase != event.getEventCase()) {
                    if (currentCase != null) {
                        currentStatement.executeBatch();
                    }
                    currentCase = event.getEventCase();
                    switch (currentCase) {
                        case CLASS_DATA: {
                            currentStatement = this.getStatementMap().get((Object)MemoryStatements.INSERT_CLASS);
                            break;
                        }
                        case ALLOC_DATA: {
                            currentStatement = this.getStatementMap().get((Object)MemoryStatements.INSERT_ALLOC);
                            break;
                        }
                        case FREE_DATA: {
                            currentStatement = this.getStatementMap().get((Object)MemoryStatements.UPDATE_ALLOC);
                            break;
                        }
                        default: {
                            assert (false);
                            break;
                        }
                    }
                }
                switch (currentCase) {
                    case CLASS_DATA: {
                        assert (currentStatement != null);
                        MemoryProfiler.AllocatedClass klass = event.getClassData();
                        this.applyParams((PreparedStatement)currentStatement, pid, session, klass.getClassId(), event.getTimestamp(), MemoryLiveAllocationTable.jniToJavaName(klass.getClassName()));
                        break;
                    }
                    case ALLOC_DATA: {
                        assert (currentStatement != null);
                        ++allocAndFreeCount;
                        MemoryProfiler.AllocationEvent.Allocation allocation = event.getAllocData();
                        this.applyParams((PreparedStatement)currentStatement, pid, session, allocation.getTag(), allocation.getClassTag(), event.getTimestamp(), Long.MAX_VALUE, allocation.getSize(), allocation.getLength(), allocation.getThreadId(), allocation.getStackId(), allocation.getHeapId());
                        break;
                    }
                    case FREE_DATA: {
                        assert (currentStatement != null);
                        ++allocAndFreeCount;
                        MemoryProfiler.AllocationEvent.Deallocation free = event.getFreeData();
                        this.applyParams((PreparedStatement)currentStatement, event.getTimestamp(), pid, session, free.getTag());
                        break;
                    }
                    default: {
                        assert (false);
                        break;
                    }
                }
                currentStatement.addBatch();
            }
            currentStatement.executeBatch();
            if (allocAndFreeCount > 0) {
                this.pruneAllocations(pid, session);
            }
        }
        catch (SQLException ex) {
            MemoryLiveAllocationTable.getLogger().error((Throwable)ex);
        }
    }

    public void insertMethodInfo(int pid, Common.Session session, List<MemoryProfiler.AllocationStack.StackFrame> methods) {
        try {
            PreparedStatement statement = this.getStatementMap().get((Object)MemoryStatements.INSERT_METHOD);
            assert (statement != null);
            for (MemoryProfiler.AllocationStack.StackFrame method : methods) {
                this.applyParams(statement, pid, session, method.getMethodId(), method.getMethodName(), MemoryLiveAllocationTable.jniToJavaName(method.getClassName()));
                statement.addBatch();
            }
            statement.executeBatch();
        }
        catch (SQLException ex) {
            MemoryLiveAllocationTable.getLogger().error((Throwable)ex);
        }
    }

    @NotNull
    public MemoryProfiler.StackFrameInfoResponse getStackFrameInfo(int pid, Common.Session session, long methodId) {
        MemoryProfiler.StackFrameInfoResponse.Builder methodBuilder = MemoryProfiler.StackFrameInfoResponse.newBuilder();
        try {
            ResultSet result = this.executeQuery(MemoryStatements.QUERY_METHOD_INFO, pid, session, methodId);
            if (result.next()) {
                methodBuilder.setMethodName(result.getString(1)).setClassName(result.getString(2));
            }
        }
        catch (SQLException ex) {
            MemoryLiveAllocationTable.getLogger().error((Throwable)ex);
        }
        MemoryProfiler.StackFrameInfoResponse stackFrameInfoResponse = methodBuilder.build();
        if (stackFrameInfoResponse == null) {
            MemoryLiveAllocationTable.$$$reportNull$$$0(3);
        }
        return stackFrameInfoResponse;
    }

    public void insertStackInfo(int pid, Common.Session session, List<MemoryProfiler.EncodedAllocationStack> stacks) {
        try {
            PreparedStatement statement = this.getStatementMap().get((Object)MemoryStatements.INSERT_ENCODED_STACK);
            assert (statement != null);
            for (MemoryProfiler.EncodedAllocationStack stack : stacks) {
                this.applyParams(statement, pid, session, stack.getStackId(), stack.getTimestamp(), stack.toByteArray());
                statement.addBatch();
            }
            statement.executeBatch();
        }
        catch (SQLException ex) {
            MemoryLiveAllocationTable.getLogger().error((Throwable)ex);
        }
    }

    public void insertThreadInfo(int pid, Common.Session session, List<MemoryProfiler.ThreadInfo> threads) {
        try {
            PreparedStatement statement = this.getStatementMap().get((Object)MemoryStatements.INSERT_THREAD_INFO);
            assert (statement != null);
            for (MemoryProfiler.ThreadInfo thread : threads) {
                this.applyParams(statement, pid, session, thread.getThreadId(), thread.getTimestamp(), thread.getThreadName());
                statement.addBatch();
            }
            statement.executeBatch();
        }
        catch (SQLException ex) {
            MemoryLiveAllocationTable.getLogger().error((Throwable)ex);
        }
    }

    private void pruneAllocations(int pid, @NotNull Common.Session session) {
        if (session == null) {
            MemoryLiveAllocationTable.$$$reportNull$$$0(4);
        }
        try {
            ResultSet result = this.executeQuery(MemoryStatements.COUNT_ALLOC, new Object[0]);
            result.next();
            int rowCount = result.getInt(1);
            if (rowCount > this.myAllocationCountLimit) {
                int pruneCount = rowCount - this.myAllocationCountLimit;
                this.execute(MemoryStatements.PRUNE_ALLOC, pid, session, pid, session, pruneCount);
                MemoryLiveAllocationTable.getLogger().info(String.format("Allocations have exceed %d entries. Attempting to prune %d.", this.myAllocationCountLimit, pruneCount));
            }
        }
        catch (SQLException e) {
            MemoryLiveAllocationTable.getLogger().error((Throwable)e);
        }
    }

    private static String jniToJavaName(String jniName) {
        String javaName;
        int arrayDimension = 0;
        int classNameIndex = 0;
        while (jniName.charAt(classNameIndex) == '[') {
            ++arrayDimension;
            ++classNameIndex;
        }
        if (jniName.charAt(classNameIndex) == 'L') {
            javaName = jniName.substring(classNameIndex + 1, jniName.length() - 1).replace('/', '.');
        } else {
            switch (javaName = jniName.substring(classNameIndex, jniName.length())) {
                case "Z": {
                    javaName = "boolean";
                    break;
                }
                case "B": {
                    javaName = "byte";
                    break;
                }
                case "C": {
                    javaName = "char";
                    break;
                }
                case "S": {
                    javaName = "short";
                    break;
                }
                case "I": {
                    javaName = "int";
                    break;
                }
                case "J": {
                    javaName = "long";
                    break;
                }
                case "F": {
                    javaName = "float";
                    break;
                }
                case "D": {
                    javaName = "double";
                    break;
                }
            }
        }
        while (arrayDimension > 0) {
            javaName = javaName + "[]";
            --arrayDimension;
        }
        return javaName;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sesstionIdLookup";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/datastore/database/MemoryLiveAllocationTable";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/datastore/database/MemoryLiveAllocationTable";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllocationContexts";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getStackFrameInfo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "initialize";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "pruneAllocations";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum MemoryStatements {
        INSERT_CLASS("INSERT OR IGNORE INTO Memory_AllocatedClass (Pid, Session, Tag, AllocTime, Name) VALUES (?, ?, ?, ?, ?)"),
        INSERT_ALLOC("INSERT OR IGNORE INTO Memory_AllocationEvents (Pid, Session, Tag, ClassTag, AllocTime, FreeTime, Size, Length, ThreadId, StackId, HeapId) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)"),
        INSERT_METHOD("INSERT OR IGNORE INTO Memory_MethodInfos (Pid, Session, MethodId, MethodName, ClassName) VALUES (?, ?, ?, ?, ?)"),
        INSERT_ENCODED_STACK("INSERT OR IGNORE INTO Memory_StackInfos (Pid, Session, StackId, AllocTime, StackData) VALUES (?, ?, ?, ?, ?)"),
        INSERT_THREAD_INFO("INSERT OR IGNORE INTO Memory_ThreadInfos (Pid, Session, ThreadId, AllocTime, ThreadName) VALUES (?, ?, ?, ?, ?)"),
        UPDATE_ALLOC("UPDATE Memory_AllocationEvents SET FreeTime = ? WHERE Pid = ? AND Session = ? AND Tag = ?"),
        QUERY_CLASS("SELECT Tag, AllocTime, Name FROM Memory_AllocatedClass where Pid = ? AND Session = ? AND AllocTime >= ? AND AllocTime < ?"),
        QUERY_ALLOC_BY_ALLOC_TIME("SELECT Tag, ClassTag, AllocTime, FreeTime, Size, Length, ThreadId, StackId, HeapId FROM Memory_AllocationEvents WHERE Pid = ? AND Session = ? AND AllocTime >= ? AND AllocTime < ?"),
        QUERY_ALLOC_BY_FREE_TIME("SELECT Tag, ClassTag, AllocTime, FreeTime, Size, Length, ThreadId, StackId, HeapId FROM Memory_AllocationEvents WHERE Pid = ? AND Session = ? AND FreeTime >= ? AND FreeTime < ?"),
        QUERY_METHOD_INFO("Select MethodName, ClassName FROM Memory_MethodInfos WHERE Pid = ? AND Session = ? AND MethodId = ?"),
        QUERY_ENCODED_STACK_INFO_BY_TIME("Select StackData FROM Memory_StackInfos WHERE Pid = ? AND Session = ? AND AllocTime >= ? AND AllocTime < ?"),
        QUERY_THREAD_INFO_BY_TIME("Select ThreadId, ThreadName FROM Memory_ThreadInfos WHERE Pid = ? AND Session = ? AND AllocTime >= ? AND AllocTime < ?"),
        COUNT_ALLOC("SELECT count(*) FROM Memory_AllocationEvents"),
        PRUNE_ALLOC("DELETE FROM Memory_AllocationEvents WHERE Pid = ? AND Session = ? AND FreeTime <= ( SELECT MAX(FreeTime) FROM Memory_AllocationEvents WHERE Pid = ? AND Session = ? AND FreeTime < 9223372036854775807 ORDER BY FreeTime LIMIT ?)");

        @NotNull
        private final String mySqlStatement;

        private MemoryStatements(String sqlStatement) {
            if (sqlStatement == null) {
                MemoryStatements.$$$reportNull$$$0(0);
            }
            this.mySqlStatement = sqlStatement;
        }

        @NotNull
        public String getStatement() {
            String string = this.mySqlStatement;
            if (string == null) {
                MemoryStatements.$$$reportNull$$$0(1);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sqlStatement";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/datastore/database/MemoryLiveAllocationTable$MemoryStatements";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/datastore/database/MemoryLiveAllocationTable$MemoryStatements";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getStatement";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

