/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.datastore.service;

import com.android.tools.datastore.DataStoreService;
import com.android.tools.datastore.ServicePassThrough;
import com.android.tools.datastore.database.EventsTable;
import com.android.tools.datastore.poller.EventDataPoller;
import com.android.tools.datastore.poller.PollRunner;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profiler.proto.EventProfiler;
import com.android.tools.profiler.proto.EventServiceGrpc;
import io.grpc.stub.StreamObserver;
import java.sql.Connection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;

public class EventService
extends EventServiceGrpc.EventServiceImplBase
implements ServicePassThrough {
    private final EventsTable myEventsTable;
    private final Map<Integer, PollRunner> myRunners;
    private final Consumer<Runnable> myFetchExecutor;
    private final DataStoreService myService;

    public EventService(@NotNull DataStoreService dataStoreService, Consumer<Runnable> fetchExecutor, @NotNull Map<Common.Session, Long> sessionIdLookup) {
        if (dataStoreService == null) {
            EventService.$$$reportNull$$$0(0);
        }
        if (sessionIdLookup == null) {
            EventService.$$$reportNull$$$0(1);
        }
        this.myRunners = new HashMap<Integer, PollRunner>();
        this.myFetchExecutor = fetchExecutor;
        this.myService = dataStoreService;
        this.myEventsTable = new EventsTable(sessionIdLookup);
    }

    public void getActivityData(EventProfiler.EventDataRequest request, StreamObserver<EventProfiler.ActivityDataResponse> responseObserver) {
        EventProfiler.ActivityDataResponse.Builder response = EventProfiler.ActivityDataResponse.newBuilder();
        Common.Session session = request.getSession();
        List<EventProfiler.ActivityData> activites = this.myEventsTable.getActivityDataByApp(request.getProcessId(), session);
        for (EventProfiler.ActivityData data : activites) {
            EventProfiler.ActivityData.Builder builder = EventProfiler.ActivityData.newBuilder();
            builder.setName(data.getName());
            builder.setProcessId(data.getProcessId());
            builder.setHash(data.getHash());
            builder.setFragmentData(data.getFragmentData());
            for (int i = 0; i < data.getStateChangesCount(); ++i) {
                EventProfiler.ActivityStateData state = data.getStateChanges(i);
                if (state.getTimestamp() > request.getStartTimestamp() && state.getTimestamp() <= request.getEndTimestamp()) {
                    if (builder.getStateChangesCount() == 0 && i > 0) {
                        builder.addStateChanges(data.getStateChanges(i - 1));
                    }
                    builder.addStateChanges(state);
                    continue;
                }
                if (state.getTimestamp() <= request.getEndTimestamp()) continue;
                builder.addStateChanges(state);
                break;
            }
            if (builder.getStateChangesCount() == 0) {
                builder.addStateChanges(data.getStateChanges(data.getStateChangesCount() - 1));
            }
            response.addData(builder);
        }
        responseObserver.onNext((Object)response.build());
        responseObserver.onCompleted();
    }

    public void getSystemData(EventProfiler.EventDataRequest request, StreamObserver<EventProfiler.SystemDataResponse> responseObserver) {
        EventProfiler.SystemDataResponse.Builder response = EventProfiler.SystemDataResponse.newBuilder();
        List<EventProfiler.SystemData> systemData = this.myEventsTable.getSystemDataByRequest(request);
        for (EventProfiler.SystemData data : systemData) {
            response.addData(data);
        }
        responseObserver.onNext((Object)response.build());
        responseObserver.onCompleted();
    }

    public void startMonitoringApp(EventProfiler.EventStartRequest request, StreamObserver<EventProfiler.EventStartResponse> observer) {
        EventServiceGrpc.EventServiceBlockingStub client = this.myService.getEventClient(request.getSession());
        if (client != null) {
            observer.onNext((Object)client.startMonitoringApp(request));
            observer.onCompleted();
            int processId = request.getProcessId();
            Common.Session session = request.getSession();
            this.myRunners.put(processId, new EventDataPoller(processId, session, this.myEventsTable, client));
            this.myFetchExecutor.accept(this.myRunners.get(processId));
        } else {
            observer.onNext((Object)EventProfiler.EventStartResponse.getDefaultInstance());
            observer.onCompleted();
        }
    }

    public void stopMonitoringApp(EventProfiler.EventStopRequest request, StreamObserver<EventProfiler.EventStopResponse> observer) {
        EventServiceGrpc.EventServiceBlockingStub client;
        int processId = request.getProcessId();
        PollRunner runner = this.myRunners.remove(processId);
        if (runner != null) {
            runner.stop();
        }
        if ((client = this.myService.getEventClient(request.getSession())) == null) {
            observer.onNext((Object)EventProfiler.EventStopResponse.getDefaultInstance());
        } else {
            observer.onNext((Object)client.stopMonitoringApp(request));
        }
        observer.onCompleted();
    }

    @Override
    @NotNull
    public List<DataStoreService.BackingNamespace> getBackingNamespaces() {
        List<DataStoreService.BackingNamespace> list = Collections.singletonList(DataStoreService.BackingNamespace.DEFAULT_SHARED_NAMESPACE);
        if (list == null) {
            EventService.$$$reportNull$$$0(2);
        }
        return list;
    }

    @Override
    public void setBackingStore(@NotNull DataStoreService.BackingNamespace namespace, @NotNull Connection connection) {
        if (namespace == null) {
            EventService.$$$reportNull$$$0(3);
        }
        if (connection == null) {
            EventService.$$$reportNull$$$0(4);
        }
        assert (namespace == DataStoreService.BackingNamespace.DEFAULT_SHARED_NAMESPACE);
        this.myEventsTable.initialize(connection);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataStoreService";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sessionIdLookup";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/datastore/service/EventService";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namespace";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/datastore/service/EventService";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getBackingNamespaces";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setBackingStore";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

