/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu;

import com.android.tools.adtui.model.HNode;
import com.android.tools.adtui.model.Range;
import com.android.tools.profilers.cpu.CaptureNode;
import com.android.tools.profilers.cpu.CpuTreeNode;
import com.android.tools.profilers.cpu.MethodModel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Stack;
import org.jetbrains.annotations.NotNull;

public class BottomUpNode
extends CpuTreeNode<BottomUpNode> {
    private final List<HNode<MethodModel>> myPathNodes;
    private final boolean myIsRoot;
    private boolean myChildrenBuilt;

    private BottomUpNode(String id) {
        super(id);
        this.myPathNodes = new ArrayList<HNode<MethodModel>>();
        this.myIsRoot = false;
        this.myChildrenBuilt = false;
    }

    public BottomUpNode(@NotNull CaptureNode node) {
        if (node == null) {
            BottomUpNode.$$$reportNull$$$0(0);
        }
        super("Root");
        this.myPathNodes = new ArrayList<HNode<MethodModel>>();
        this.myIsRoot = true;
        this.myChildrenBuilt = true;
        ArrayList<CaptureNode> allNodes = new ArrayList<CaptureNode>();
        Stack<CaptureNode> stack = new Stack<CaptureNode>();
        stack.add(node);
        while (!stack.isEmpty()) {
            CaptureNode curNode = (CaptureNode)stack.pop();
            allNodes.add(curNode);
            for (int i = curNode.getChildren().size() - 1; i >= 0; --i) {
                stack.add(curNode.getChildren().get(i));
            }
        }
        HashMap<String, BottomUpNode> children = new HashMap<String, BottomUpNode>();
        for (CaptureNode curNode : allNodes) {
            assert (curNode.getData() != null);
            String curId = curNode.getData().getId();
            BottomUpNode child = (BottomUpNode)children.get(curId);
            if (child == null) {
                child = new BottomUpNode(curId);
                children.put(curId, child);
                this.addChild(child);
            }
            child.addPathNode(curNode);
            child.addNode(curNode);
        }
        this.addNode(node);
        for (BottomUpNode child : this.getChildren()) {
            child.buildChildren();
        }
    }

    private void addPathNode(@NotNull HNode<MethodModel> node) {
        if (node == null) {
            BottomUpNode.$$$reportNull$$$0(1);
        }
        this.myPathNodes.add(node);
    }

    public boolean buildChildren() {
        if (this.myChildrenBuilt) {
            return false;
        }
        HashMap<String, BottomUpNode> children = new HashMap<String, BottomUpNode>();
        assert (this.myPathNodes.size() == this.getNodes().size());
        for (int i = 0; i < this.myPathNodes.size(); ++i) {
            HNode parent = this.myPathNodes.get(i).getParent();
            if (parent == null) continue;
            assert (parent.getData() != null);
            String parentId = ((MethodModel)parent.getData()).getId();
            BottomUpNode child = (BottomUpNode)children.get(parentId);
            if (child == null) {
                child = new BottomUpNode(parentId);
                children.put(parentId, child);
                this.addChild(child);
            }
            child.addPathNode((HNode<MethodModel>)parent);
            child.addNode(this.getNodes().get(i));
        }
        this.myChildrenBuilt = true;
        return true;
    }

    @Override
    public void update(@NotNull Range range) {
        if (range == null) {
            BottomUpNode.$$$reportNull$$$0(2);
        }
        this.myTotal = 0.0;
        double self = 0.0;
        CaptureNode outerSoFar = null;
        for (CaptureNode node : this.myNodes) {
            if (outerSoFar == null || node.getEnd() > outerSoFar.getEnd()) {
                if (outerSoFar != null) {
                    this.myTotal += BottomUpNode.getIntersection(range, outerSoFar);
                }
                outerSoFar = node;
            }
            self += BottomUpNode.getIntersection(range, node);
            for (CaptureNode child : node.getChildren()) {
                self -= BottomUpNode.getIntersection(range, child);
            }
        }
        if (outerSoFar != null) {
            this.myTotal += BottomUpNode.getIntersection(range, outerSoFar);
        }
        this.myChildrenTotal = this.myTotal - self;
    }

    @Override
    public String getMethodName() {
        if (this.myIsRoot) {
            return "";
        }
        MethodModel method = (MethodModel)this.myPathNodes.get(0).getData();
        return method == null ? "" : method.getName();
    }

    @Override
    public String getClassName() {
        if (this.myIsRoot) {
            return "";
        }
        MethodModel method = (MethodModel)this.myPathNodes.get(0).getData();
        return method == null ? "" : method.getClassName();
    }

    @Override
    public String getSignature() {
        if (this.myIsRoot) {
            return "";
        }
        MethodModel method = (MethodModel)this.myPathNodes.get(0).getData();
        return method == null ? "" : method.getSignature();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/profilers/cpu/BottomUpNode";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "addPathNode";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

