/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.memory;

import com.android.tools.profilers.memory.MemoryObjectTreeNode;
import com.android.tools.profilers.memory.MemoryProfilerStageView;
import com.android.tools.profilers.memory.adapters.ValueObject;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import java.awt.Color;
import javax.swing.JTree;
import org.jetbrains.annotations.NotNull;

public class ValueColumnRenderer
extends ColoredTreeCellRenderer {
    public static final SimpleTextAttributes STRING_ATTRIBUTES = new SimpleTextAttributes(1, new Color(0, 128, 0));

    public void customizeCellRenderer(@NotNull JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        if (tree == null) {
            ValueColumnRenderer.$$$reportNull$$$0(0);
        }
        if (!(value instanceof MemoryObjectTreeNode)) {
            this.append(value.toString());
            return;
        }
        Object adapter = ((MemoryObjectTreeNode)value).getAdapter();
        if (!(adapter instanceof ValueObject)) {
            this.append(adapter.getName());
            return;
        }
        ValueObject valueObject = (ValueObject)adapter;
        this.setIcon(MemoryProfilerStageView.getValueObjectIcon(valueObject));
        this.setTextAlign(2);
        String name = valueObject.getName();
        this.append(name, SimpleTextAttributes.REGULAR_ATTRIBUTES, name);
        this.append(name.isEmpty() ? "" : " = ");
        String valueText = valueObject.getValueText();
        this.append(valueText, SimpleTextAttributes.REGULAR_ATTRIBUTES, valueText);
        this.append(valueText.isEmpty() ? "" : " ");
        String toStringText = valueObject.getToStringText();
        if (valueObject.getValueType() == ValueObject.ValueType.STRING) {
            this.append(toStringText, STRING_ATTRIBUTES, toStringText);
        } else {
            this.append(toStringText, SimpleTextAttributes.REGULAR_ATTRIBUTES, toStringText);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/android/tools/profilers/memory/ValueColumnRenderer", "customizeCellRenderer"));
    }
}

