/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.memory.adapters;

import com.android.tools.profilers.memory.adapters.InstanceObject;
import com.android.tools.profilers.memory.adapters.MemoryObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sun.reflect.generics.reflectiveObjects.NotImplementedException;

public abstract class ClassifierSet
implements MemoryObject {
    @NotNull
    private String myName;
    @NotNull
    private Supplier<String> myNameSupplier;
    @NotNull
    protected final Set<InstanceObject> myInstances;
    @Nullable
    protected Classifier myClassifier;
    protected int myAllocatedCount;
    protected int myDeallocatedCount;
    protected long myTotalNativeSize;
    protected long myTotalShallowSize;
    protected long myTotalRetainedSize;
    protected int myInstancesWithStackInfoCount;

    public ClassifierSet(@NotNull String name) {
        if (name == null) {
            ClassifierSet.$$$reportNull$$$0(0);
        }
        this.myNameSupplier = null;
        this.myInstances = new LinkedHashSet<InstanceObject>(0);
        this.myClassifier = null;
        this.myAllocatedCount = 0;
        this.myDeallocatedCount = 0;
        this.myTotalNativeSize = 0L;
        this.myTotalShallowSize = 0L;
        this.myTotalRetainedSize = 0L;
        this.myInstancesWithStackInfoCount = 0;
        this.myName = name;
    }

    public ClassifierSet(@NotNull Supplier<String> nameSupplier) {
        if (nameSupplier == null) {
            ClassifierSet.$$$reportNull$$$0(1);
        }
        this.myNameSupplier = null;
        this.myInstances = new LinkedHashSet<InstanceObject>(0);
        this.myClassifier = null;
        this.myAllocatedCount = 0;
        this.myDeallocatedCount = 0;
        this.myTotalNativeSize = 0L;
        this.myTotalShallowSize = 0L;
        this.myTotalRetainedSize = 0L;
        this.myInstancesWithStackInfoCount = 0;
        this.myNameSupplier = nameSupplier;
    }

    @Override
    @NotNull
    public String getName() {
        if (this.myName == null) {
            assert (this.myNameSupplier != null);
            this.myName = this.myNameSupplier.get();
        }
        String string = this.myName;
        if (string == null) {
            ClassifierSet.$$$reportNull$$$0(2);
        }
        return string;
    }

    public boolean isEmpty() {
        return this.myAllocatedCount == 0 && this.myDeallocatedCount == 0;
    }

    public int getAllocatedCount() {
        return this.myAllocatedCount;
    }

    public int getDeallocatedCount() {
        return this.myDeallocatedCount;
    }

    public long getTotalRetainedSize() {
        return this.myTotalRetainedSize;
    }

    public long getTotalShallowSize() {
        return this.myTotalShallowSize;
    }

    public long getTotalNativeSize() {
        return this.myTotalNativeSize;
    }

    public boolean addInstanceObject(@NotNull InstanceObject instanceObject) {
        if (instanceObject == null) {
            ClassifierSet.$$$reportNull$$$0(3);
        }
        return this.addInstanceObjectInformation(instanceObject, true);
    }

    public boolean freeInstanceObject(@NotNull InstanceObject instanceObject) {
        if (instanceObject == null) {
            ClassifierSet.$$$reportNull$$$0(4);
        }
        return this.addInstanceObjectInformation(instanceObject, false);
    }

    public boolean removeAddingInstanceObject(@NotNull InstanceObject instanceObject) {
        if (instanceObject == null) {
            ClassifierSet.$$$reportNull$$$0(5);
        }
        return this.removeInstanceObjectInformation(instanceObject, true);
    }

    public boolean removeFreeingInstanceObject(@NotNull InstanceObject instanceObject) {
        if (instanceObject == null) {
            ClassifierSet.$$$reportNull$$$0(6);
        }
        return this.removeInstanceObjectInformation(instanceObject, false);
    }

    private boolean addInstanceObjectInformation(@NotNull InstanceObject instanceObject, boolean isAllocation) {
        if (instanceObject == null) {
            ClassifierSet.$$$reportNull$$$0(7);
        }
        boolean instanceAdded = false;
        if (this.myClassifier != null && !this.myClassifier.isTerminalClassifier()) {
            instanceAdded = this.myClassifier.getOrCreateClassifierSet(instanceObject).addInstanceObjectInformation(instanceObject, isAllocation);
        } else if (!this.myInstances.contains(instanceObject)) {
            instanceAdded = true;
            this.myInstances.add(instanceObject);
        }
        if (isAllocation) {
            ++this.myAllocatedCount;
        } else {
            ++this.myDeallocatedCount;
        }
        this.myTotalNativeSize += (long)(isAllocation ? 1 : -1) * (instanceObject.getNativeSize() == -1L ? 0L : instanceObject.getNativeSize());
        this.myTotalShallowSize += (long)((isAllocation ? 1 : -1) * (instanceObject.getShallowSize() == -1 ? 0 : instanceObject.getShallowSize()));
        this.myTotalRetainedSize += (long)(isAllocation ? 1 : -1) * (instanceObject.getRetainedSize() == -1L ? 0L : instanceObject.getRetainedSize());
        if (instanceAdded && instanceObject.getCallStackDepth() > 0) {
            ++this.myInstancesWithStackInfoCount;
        }
        return instanceAdded;
    }

    private boolean removeInstanceObjectInformation(@NotNull InstanceObject instanceObject, boolean isAllocation) {
        if (instanceObject == null) {
            ClassifierSet.$$$reportNull$$$0(8);
        }
        boolean instanceRemoved = false;
        if (this.myClassifier != null && !this.myClassifier.isTerminalClassifier()) {
            instanceRemoved = this.myClassifier.getOrCreateClassifierSet(instanceObject).removeInstanceObjectInformation(instanceObject, isAllocation);
        } else if (!instanceObject.hasTimeData() && this.myInstances.contains(instanceObject)) {
            this.myInstances.remove(instanceObject);
            instanceRemoved = true;
        }
        if (isAllocation) {
            --this.myAllocatedCount;
        } else {
            --this.myDeallocatedCount;
        }
        this.myTotalNativeSize -= (long)(isAllocation ? 1 : -1) * (instanceObject.getNativeSize() == -1L ? 0L : instanceObject.getNativeSize());
        this.myTotalShallowSize -= (long)((isAllocation ? 1 : -1) * (instanceObject.getShallowSize() == -1 ? 0 : instanceObject.getShallowSize()));
        this.myTotalRetainedSize -= (long)(isAllocation ? 1 : -1) * (instanceObject.getRetainedSize() == -1L ? 0L : instanceObject.getRetainedSize());
        if (instanceRemoved && instanceObject.getCallStackDepth() > 0) {
            --this.myInstancesWithStackInfoCount;
        }
        return instanceRemoved;
    }

    public void clearClassifierSets() {
        this.myInstances.clear();
        this.myClassifier = this.createSubClassifier();
        this.myAllocatedCount = 0;
        this.myDeallocatedCount = 0;
        this.myTotalShallowSize = 0L;
        this.myTotalRetainedSize = 0L;
        this.myInstancesWithStackInfoCount = 0;
    }

    public int getInstancesCount() {
        if (this.myClassifier == null) {
            return this.myInstances.size();
        }
        return (int)this.getInstancesStream().count();
    }

    @NotNull
    public Stream<InstanceObject> getInstancesStream() {
        if (this.myClassifier == null) {
            Stream<InstanceObject> stream = this.myInstances.stream();
            if (stream == null) {
                ClassifierSet.$$$reportNull$$$0(9);
            }
            return stream;
        }
        Stream<InstanceObject> stream = Stream.concat(this.getChildrenClassifierSets().stream().flatMap(ClassifierSet::getInstancesStream), this.myInstances.stream());
        if (stream == null) {
            ClassifierSet.$$$reportNull$$$0(10);
        }
        return stream;
    }

    public boolean hasStackInfo() {
        return this.myInstancesWithStackInfoCount > 0;
    }

    @NotNull
    public List<ClassifierSet> getChildrenClassifierSets() {
        this.ensurePartition();
        assert (this.myClassifier != null);
        List<ClassifierSet> list = this.myClassifier.getClassifierSets();
        if (list == null) {
            ClassifierSet.$$$reportNull$$$0(11);
        }
        return list;
    }

    @Nullable
    public ClassifierSet findContainingClassifierSet(@NotNull InstanceObject target) {
        boolean instancesContainsTarget;
        if (target == null) {
            ClassifierSet.$$$reportNull$$$0(12);
        }
        if ((instancesContainsTarget = this.myInstances.contains(target)) && this.myClassifier != null) {
            return this;
        }
        if (instancesContainsTarget || this.myClassifier != null) {
            List<ClassifierSet> childrenClassifierSets = this.getChildrenClassifierSets();
            if (instancesContainsTarget && this.myInstances.contains(target)) {
                return this;
            }
            for (ClassifierSet set : childrenClassifierSets) {
                ClassifierSet result = set.findContainingClassifierSet(target);
                if (result == null) continue;
                return result;
            }
        }
        return null;
    }

    public boolean isSupersetOf(@NotNull ClassifierSet targetSet) {
        if (targetSet == null) {
            ClassifierSet.$$$reportNull$$$0(13);
        }
        if (this.getInstancesCount() < targetSet.getInstancesCount()) {
            return false;
        }
        Set instances = this.getInstancesStream().collect(Collectors.toSet());
        return targetSet.getInstancesStream().allMatch(instances::contains);
    }

    protected void ensurePartition() {
        if (this.myClassifier == null) {
            this.myClassifier = this.createSubClassifier();
            this.myClassifier.partition(this.myInstances);
        }
    }

    @NotNull
    protected abstract Classifier createSubClassifier();

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 9: 
            case 10: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 9: 
            case 10: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nameSupplier";
                break;
            }
            case 2: 
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/profilers/memory/adapters/ClassifierSet";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "instanceObject";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetSet";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/profilers/memory/adapters/ClassifierSet";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstancesStream";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildrenClassifierSets";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 9: 
            case 10: 
            case 11: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addInstanceObject";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "freeInstanceObject";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "removeAddingInstanceObject";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "removeFreeingInstanceObject";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addInstanceObjectInformation";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "removeInstanceObjectInformation";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "findContainingClassifierSet";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isSupersetOf";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 9: 
            case 10: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static abstract class Classifier {
        public static final Classifier IDENTITY_CLASSIFIER = new Classifier(){

            @Override
            public boolean isTerminalClassifier() {
                return true;
            }

            @Override
            @NotNull
            public ClassifierSet getOrCreateClassifierSet(@NotNull InstanceObject instance) {
                if (instance == null) {
                    1.$$$reportNull$$$0(0);
                }
                throw new NotImplementedException();
            }

            @Override
            @NotNull
            public List<ClassifierSet> getClassifierSets() {
                List<ClassifierSet> list = Collections.emptyList();
                if (list == null) {
                    1.$$$reportNull$$$0(1);
                }
                return list;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "instance";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/android/tools/profilers/memory/adapters/ClassifierSet$Classifier$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/android/tools/profilers/memory/adapters/ClassifierSet$Classifier$1";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getClassifierSets";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "getOrCreateClassifierSet";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };

        public boolean isTerminalClassifier() {
            return false;
        }

        @NotNull
        public abstract ClassifierSet getOrCreateClassifierSet(@NotNull InstanceObject var1);

        @NotNull
        public abstract List<ClassifierSet> getClassifierSets();

        public final void partition(@NotNull Set<InstanceObject> instances) {
            if (instances == null) {
                Classifier.$$$reportNull$$$0(0);
            }
            ArrayList partitionedInstances = new ArrayList(instances.size());
            if (!this.isTerminalClassifier()) {
                instances.forEach(instance -> {
                    if (instance.hasTimeData()) {
                        if (instance.hasAllocData()) {
                            this.getOrCreateClassifierSet((InstanceObject)instance).addInstanceObject((InstanceObject)instance);
                        }
                        if (instance.hasDeallocData()) {
                            this.getOrCreateClassifierSet((InstanceObject)instance).freeInstanceObject((InstanceObject)instance);
                        }
                        partitionedInstances.add(instance);
                    } else {
                        this.getOrCreateClassifierSet((InstanceObject)instance).addInstanceObject((InstanceObject)instance);
                        partitionedInstances.add(instance);
                    }
                });
            }
            if (partitionedInstances.size() == instances.size()) {
                instances.clear();
            } else {
                instances.removeAll(partitionedInstances);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "instances", "com/android/tools/profilers/memory/adapters/ClassifierSet$Classifier", "partition"));
        }
    }
}

