/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.aspectj.facet;

import com.intellij.facet.ui.FacetEditorContext;
import com.intellij.facet.ui.FacetEditorTab;
import com.intellij.facet.ui.FacetEditorValidator;
import com.intellij.facet.ui.FacetValidatorsManager;
import com.intellij.facet.ui.ValidationResult;
import com.intellij.lang.aspectj.AspectJBundle;
import com.intellij.lang.aspectj.build.config.AjModuleSettings;
import com.intellij.lang.aspectj.build.config.AjPathEntries;
import com.intellij.lang.aspectj.facet.AjFacetPanel;
import com.intellij.lang.aspectj.util.LibraryUtil;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.util.Comparing;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class AjFacetEditorTab
extends FacetEditorTab {
    private final AjModuleSettings mySettings;
    private final FacetEditorContext myContext;
    private final FacetValidatorsManager myValidator;
    private AjFacetPanel myFacetPanel;

    public AjFacetEditorTab(@NotNull AjModuleSettings settings, @NotNull FacetEditorContext context, @NotNull FacetValidatorsManager validator) {
        if (settings == null) {
            AjFacetEditorTab.$$$reportNull$$$0(0);
        }
        if (context == null) {
            AjFacetEditorTab.$$$reportNull$$$0(1);
        }
        if (validator == null) {
            AjFacetEditorTab.$$$reportNull$$$0(2);
        }
        this.mySettings = settings;
        this.myContext = context;
        this.myValidator = validator;
    }

    @Nls
    public String getDisplayName() {
        return null;
    }

    @NotNull
    public JComponent createComponent() {
        this.myFacetPanel = new AjFacetPanel(this.myContext.getModule());
        JComponent component = this.myFacetPanel.getComponent();
        this.myValidator.registerValidator(new FacetEditorValidator(){

            @NotNull
            public ValidationResult check() {
                ValidationResult validationResult = AjFacetEditorTab.this.validate();
                if (validationResult == null) {
                    1.$$$reportNull$$$0(0);
                }
                return validationResult;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/aspectj/facet/AjFacetEditorTab$1", "check"));
            }
        }, new JComponent[]{component});
        JComponent jComponent = component;
        if (jComponent == null) {
            AjFacetEditorTab.$$$reportNull$$$0(3);
        }
        return jComponent;
    }

    public void onTabEntering() {
        this.myValidator.validate();
    }

    public boolean isModified() {
        return !Comparing.equal((Object)this.mySettings.weaveOnly, (Object)this.myFacetPanel.isWeaveOnly()) || !Comparing.equal(this.myFacetPanel.getAspectPathEntries(), (Object)this.mySettings.aspectPath);
    }

    public String getHelpTopic() {
        return "AspectJ_Facet";
    }

    public void apply() throws ConfigurationException {
        this.mySettings.weaveOnly = this.myFacetPanel.isWeaveOnly();
        this.mySettings.aspectPath = ContainerUtil.newArrayList(this.myFacetPanel.getAspectPathEntries());
    }

    public void reset() {
        this.myFacetPanel.setWeaveOnly(this.mySettings.weaveOnly);
        this.myFacetPanel.setAspectPathEntries(this.mySettings.aspectPath);
    }

    public void disposeUIResources() {
        this.myFacetPanel = null;
    }

    private ValidationResult validate() {
        List<AjPathEntries.Entry> entries = this.myFacetPanel.getAspectPathEntries();
        Map<AjPathEntries.Entry, Object> map = LibraryUtil.mapEntries(entries, this.myContext.getProject());
        List<Object> dependencyList = LibraryUtil.getAspectPathCandidates(this.myContext.getModule(), Collections.emptySet());
        Set dependencies = ContainerUtil.newHashOrEmptySet(dependencyList);
        for (AjPathEntries.Entry entry : entries) {
            Object o = map.get(entry);
            if (o == null) {
                return new ValidationResult(AspectJBundle.message("facet.validation.unknown.entry", entry.getName()));
            }
            if (dependencies.contains(o)) continue;
            return new ValidationResult(AspectJBundle.message("facet.validation.stray.entry", entry.getName()));
        }
        return ValidationResult.OK;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "validator";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/aspectj/facet/AjFacetEditorTab";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/aspectj/facet/AjFacetEditorTab";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

