/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.aspectj.highlight.analysis.member;

import com.intellij.codeInsight.daemon.impl.analysis.HighlightNamesUtil;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.aspectj.AspectJBundle;
import com.intellij.lang.aspectj.highlight.analysis.ElementAnnotator;
import com.intellij.lang.aspectj.psi.PsiAspect;
import com.intellij.lang.aspectj.psi.PsiInterTypeMethod;
import com.intellij.lang.aspectj.quickFix.MakeAspectAbstractFix;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;

public class AspectConstructorParamsAnnotator
extends ElementAnnotator<PsiMethod> {
    @Override
    public boolean annotate(AnnotationHolder holder, PsiMethod method) {
        if (method instanceof PsiInterTypeMethod || !method.isConstructor() || method.getParameterList().getParametersCount() == 0) {
            return false;
        }
        PsiElement parent = method.getParent();
        if (!(parent instanceof PsiAspect)) {
            return false;
        }
        PsiAspect aspect = (PsiAspect)parent;
        PsiModifierList modList = aspect.getModifierList();
        if (modList == null || modList.hasModifierProperty("abstract")) {
            return false;
        }
        TextRange range = HighlightNamesUtil.getMethodDeclarationTextRange((PsiMethod)method);
        Annotation anno = holder.createErrorAnnotation(range, AspectJBundle.message("highlighting.aspect.params", new Object[0]));
        anno.registerFix((IntentionAction)new MakeAspectAbstractFix(aspect));
        return true;
    }
}

