/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.idea.lang.javascript.intention.number;

import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSParenthesizedExpression;
import com.intellij.lang.javascript.psi.impl.JSElementPredicate;
import com.intellij.lang.javascript.psi.util.ParenthesesUtils;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.IncorrectOperationException;
import com.sixrr.inspectjs.utils.BinaryOperatorUtils;
import org.intellij.idea.lang.javascript.intention.JSMutablyNamedIntention;
import org.intellij.idea.lang.javascript.intention.number.ShiftUtils;
import org.intellij.idea.lang.javascript.psiutil.JSElementFactory;
import org.jetbrains.annotations.NotNull;

public class JSReplaceShiftWithMultiplyIntention
extends JSMutablyNamedIntention {
    @Override
    protected String getTextForElement(PsiElement element) {
        IElementType tokenType = ((JSBinaryExpression)element).getOperationSign();
        String operatorString = element instanceof JSAssignmentExpression ? (tokenType.equals(JSTokenTypes.LTLTEQ) ? "*=" : "/=") : (tokenType.equals(JSTokenTypes.LTLT) ? "*" : "/");
        return this.getText(BinaryOperatorUtils.getOperatorText((IElementType)tokenType), operatorString);
    }

    @Override
    @NotNull
    public JSElementPredicate getElementPredicate() {
        ShiftByLiteralPredicate shiftByLiteralPredicate = new ShiftByLiteralPredicate();
        if (shiftByLiteralPredicate == null) {
            JSReplaceShiftWithMultiplyIntention.$$$reportNull$$$0(0);
        }
        return shiftByLiteralPredicate;
    }

    @Override
    public void processIntention(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            JSReplaceShiftWithMultiplyIntention.$$$reportNull$$$0(1);
        }
        if (element instanceof JSAssignmentExpression) {
            this.replaceShiftAssignWithMultiplyOrDivideAssign((JSAssignmentExpression)element);
        } else {
            assert (element instanceof JSBinaryExpression);
            this.replaceShiftWithMultiplyOrDivide((JSBinaryExpression)element);
        }
    }

    private void replaceShiftAssignWithMultiplyOrDivideAssign(JSAssignmentExpression exp) throws IncorrectOperationException {
        JSExpression lhs = exp.getLOperand();
        JSExpression rhs = exp.getROperand();
        IElementType tokenType = exp.getOperationSign();
        String assignString = tokenType.equals(JSTokenTypes.LTLTEQ) ? "*=" : "/=";
        String expString = lhs.getText() + assignString + ShiftUtils.getExpBase2(rhs);
        JSElementFactory.replaceExpression((JSExpression)exp, expString);
    }

    private void replaceShiftWithMultiplyOrDivide(JSBinaryExpression exp) throws IncorrectOperationException {
        JSExpression lhs = exp.getLOperand();
        JSExpression rhs = exp.getROperand();
        IElementType tokenType = exp.getOperationSign();
        String operatorString = tokenType.equals(JSTokenTypes.LTLT) ? "*" : "/";
        String lhsText = ParenthesesUtils.getParenthesized((JSExpression)lhs, (int)5);
        String expString = lhsText + operatorString + ShiftUtils.getExpBase2(rhs);
        JSElement parent = (JSElement)exp.getParent();
        if (parent instanceof JSExpression && !(parent instanceof JSParenthesizedExpression) && ParenthesesUtils.getPrecedence((JSExpression)((JSExpression)parent)) < 5) {
            expString = '(' + expString + ')';
        }
        JSElementFactory.replaceExpression((JSExpression)exp, expString);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/intellij/idea/lang/javascript/intention/number/JSReplaceShiftWithMultiplyIntention";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementPredicate";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "org/intellij/idea/lang/javascript/intention/number/JSReplaceShiftWithMultiplyIntention";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "processIntention";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ShiftByLiteralPredicate
    implements JSElementPredicate {
        private ShiftByLiteralPredicate() {
        }

        public boolean satisfiedBy(@NotNull PsiElement element) {
            if (element == null) {
                ShiftByLiteralPredicate.$$$reportNull$$$0(0);
            }
            if (element instanceof JSAssignmentExpression) {
                return this.isAssignmentShiftByLiteral((JSAssignmentExpression)element);
            }
            if (element instanceof JSBinaryExpression) {
                return this.isBinaryShiftByLiteral((JSBinaryExpression)element);
            }
            return false;
        }

        private boolean isAssignmentShiftByLiteral(JSAssignmentExpression expression) {
            IElementType tokenType = expression.getOperationSign();
            if (tokenType == null || !tokenType.equals(JSTokenTypes.LTLTEQ) && !tokenType.equals(JSTokenTypes.GTGTEQ)) {
                return false;
            }
            JSExpression rhs = expression.getROperand();
            if (rhs == null) {
                return false;
            }
            return ShiftUtils.isIntLiteral(rhs);
        }

        private boolean isBinaryShiftByLiteral(JSBinaryExpression expression) {
            IElementType tokenType = expression.getOperationSign();
            if (!JSTokenTypes.LTLT.equals(tokenType) && !JSTokenTypes.GTGT.equals(tokenType)) {
                return false;
            }
            return ShiftUtils.isIntLiteral(expression.getROperand());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/intellij/idea/lang/javascript/intention/number/JSReplaceShiftWithMultiplyIntention$ShiftByLiteralPredicate", "satisfiedBy"));
        }
    }
}

