/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.idea.lang.javascript.intention.switchtoif;

import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSBreakStatement;
import com.intellij.lang.javascript.psi.JSCaseClause;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSIfStatement;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.util.ExpressionUtil;
import com.intellij.lang.javascript.psi.util.ParenthesesUtils;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.sixrr.inspectjs.utils.EquivalenceChecker;
import java.util.ArrayList;
import java.util.List;
import org.intellij.idea.lang.javascript.intention.switchtoif.LabelSearchVisitor;
import org.intellij.idea.lang.javascript.intention.switchtoif.LocalVariableUsageVisitor;
import org.intellij.idea.lang.javascript.psiutil.SideEffectChecker;

class CaseUtil {
    private CaseUtil() {
    }

    private static boolean canBeCaseLabel(JSExpression expression) {
        if (expression == null) {
            return false;
        }
        return ExpressionUtil.isConstantExpression((JSExpression)expression);
    }

    public static boolean containsHiddenBreak(JSCaseClause caseClause) {
        for (JSStatement statement : caseClause.getStatements()) {
            if (!CaseUtil.containsHiddenBreak(statement, true)) continue;
            return true;
        }
        return false;
    }

    public static boolean containsHiddenBreak(List<PsiElement> elements) {
        for (PsiElement element : elements) {
            if (!(element instanceof JSStatement) || !CaseUtil.containsHiddenBreak((JSStatement)element, true)) continue;
            return true;
        }
        return false;
    }

    public static boolean containsHiddenBreak(JSStatement statement) {
        return CaseUtil.containsHiddenBreak(statement, true);
    }

    private static boolean containsHiddenBreak(JSStatement statement, boolean isTopLevel) {
        if (statement instanceof JSBlockStatement) {
            JSStatement[] statements;
            for (JSStatement childStatement : statements = ((JSBlockStatement)statement).getStatements()) {
                if (!CaseUtil.containsHiddenBreak(childStatement, false)) continue;
                return true;
            }
        } else {
            if (statement instanceof JSIfStatement) {
                JSIfStatement ifStatement = (JSIfStatement)statement;
                return CaseUtil.containsHiddenBreak(ifStatement.getThen(), false) || CaseUtil.containsHiddenBreak(ifStatement.getElse(), false);
            }
            if (statement instanceof JSBreakStatement) {
                if (isTopLevel) {
                    return false;
                }
                String identifier = ((JSBreakStatement)statement).getLabel();
                return identifier == null || identifier.length() == 0;
            }
        }
        return false;
    }

    public static boolean isUsedByStatementList(JSVariable var, List<PsiElement> elements) {
        for (PsiElement element : elements) {
            if (!(element instanceof JSElement) || !CaseUtil.isUsedByStatement(var, (JSElement)element)) continue;
            return true;
        }
        return false;
    }

    private static boolean isUsedByStatement(JSVariable var, JSElement statement) {
        LocalVariableUsageVisitor visitor = new LocalVariableUsageVisitor(var);
        statement.accept((PsiElementVisitor)visitor);
        return visitor.isUsed();
    }

    public static String findUniqueLabel(JSStatement statement, String baseName) {
        JSStatement ancestor = statement;
        while (ancestor.getParent() != null && !(ancestor instanceof PsiFile)) {
            ancestor = (JSElement)ancestor.getParent();
        }
        if (!CaseUtil.checkForLabel(baseName, (JSElement)ancestor)) {
            return baseName;
        }
        int val = 1;
        String name;
        while (CaseUtil.checkForLabel(name = baseName + val, (JSElement)ancestor)) {
            ++val;
        }
        return name;
    }

    private static boolean checkForLabel(String name, JSElement ancestor) {
        LabelSearchVisitor visitor = new LabelSearchVisitor(name);
        ancestor.accept((PsiElementVisitor)visitor);
        return visitor.isUsed();
    }

    public static JSExpression getCaseExpression(JSIfStatement statement) {
        JSExpression condition = statement.getCondition();
        List<JSExpression> possibleCaseExpressions = CaseUtil.determinePossibleCaseExpressions(condition);
        if (possibleCaseExpressions != null) {
            for (JSExpression caseExpression : possibleCaseExpressions) {
                if (SideEffectChecker.mayHaveSideEffects(caseExpression)) continue;
                JSIfStatement statementToCheck = statement;
                while (CaseUtil.canBeMadeIntoCase(statementToCheck.getCondition(), caseExpression)) {
                    JSStatement elseBranch = statementToCheck.getElse();
                    if (!(elseBranch instanceof JSIfStatement)) {
                        return caseExpression;
                    }
                    statementToCheck = (JSIfStatement)elseBranch;
                }
            }
        }
        return null;
    }

    private static List<JSExpression> determinePossibleCaseExpressions(JSExpression exp) {
        JSExpression expToCheck = ParenthesesUtils.stripParentheses((JSExpression)exp);
        ArrayList<JSExpression> out = new ArrayList<JSExpression>(10);
        if (expToCheck instanceof JSBinaryExpression) {
            JSBinaryExpression binaryExp = (JSBinaryExpression)expToCheck;
            IElementType operation = binaryExp.getOperationSign();
            JSExpression lhs = binaryExp.getLOperand();
            JSExpression rhs = binaryExp.getROperand();
            if (operation.equals(JSTokenTypes.OROR)) {
                return CaseUtil.determinePossibleCaseExpressions(lhs);
            }
            if (operation.equals(JSTokenTypes.EQEQ)) {
                if (CaseUtil.canBeCaseLabel(lhs) && rhs != null) {
                    out.add(rhs);
                }
                if (CaseUtil.canBeCaseLabel(rhs)) {
                    out.add(lhs);
                }
            }
        }
        return out;
    }

    private static boolean canBeMadeIntoCase(JSExpression exp, JSExpression caseExpression) {
        JSExpression expToCheck = ParenthesesUtils.stripParentheses((JSExpression)exp);
        if (!(expToCheck instanceof JSBinaryExpression)) {
            return false;
        }
        JSBinaryExpression binaryExp = (JSBinaryExpression)expToCheck;
        IElementType operation = binaryExp.getOperationSign();
        JSExpression leftOperand = binaryExp.getLOperand();
        JSExpression rightOperand = binaryExp.getROperand();
        if (operation.equals(JSTokenTypes.OROR)) {
            return CaseUtil.canBeMadeIntoCase(leftOperand, caseExpression) && CaseUtil.canBeMadeIntoCase(rightOperand, caseExpression);
        }
        if (operation.equals(JSTokenTypes.EQEQ)) {
            return CaseUtil.canBeCaseLabel(leftOperand) && EquivalenceChecker.expressionsAreEquivalent((JSExpression)caseExpression, (JSExpression)rightOperand) || CaseUtil.canBeCaseLabel(rightOperand) && EquivalenceChecker.expressionsAreEquivalent((JSExpression)caseExpression, (JSExpression)leftOperand);
        }
        return false;
    }
}

