/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.idea.lang.javascript.psiutil;

import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSNewExpression;
import com.intellij.lang.javascript.psi.JSPostfixExpression;
import com.intellij.lang.javascript.psi.JSPrefixExpression;
import com.intellij.lang.javascript.psi.JSRecursiveElementVisitor;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.tree.IElementType;

public class SideEffectChecker {
    private SideEffectChecker() {
    }

    public static boolean mayHaveSideEffects(JSExpression exp) {
        SideEffectsVisitor visitor = new SideEffectsVisitor();
        exp.accept((PsiElementVisitor)visitor);
        return visitor.mayHaveSideEffects();
    }

    private static class SideEffectsVisitor
    extends JSRecursiveElementVisitor {
        private boolean mayHaveSideEffects;

        private SideEffectsVisitor() {
        }

        public void visitJSElement(JSElement element) {
            if (!this.mayHaveSideEffects) {
                super.visitJSElement(element);
            }
        }

        public void visitJSCallExpression(JSCallExpression expression) {
            this.mayHaveSideEffects = true;
        }

        public void visitJSNewExpression(JSNewExpression expression) {
            this.mayHaveSideEffects = true;
        }

        public void visitJSAssignmentExpression(JSAssignmentExpression expression) {
            this.mayHaveSideEffects = true;
        }

        public void visitJSPrefixExpression(JSPrefixExpression expression) {
            super.visitJSPrefixExpression(expression);
            IElementType sign = expression.getOperationSign();
            if (sign != null && (sign.equals(JSTokenTypes.PLUSPLUS) || sign.equals(JSTokenTypes.MINUSMINUS))) {
                this.mayHaveSideEffects = true;
            }
        }

        public void visitJSPostfixExpression(JSPostfixExpression expression) {
            super.visitJSPostfixExpression(expression);
            IElementType sign = expression.getOperationSign();
            if (sign != null && (sign.equals(JSTokenTypes.PLUSPLUS) || sign.equals(JSTokenTypes.MINUSMINUS))) {
                this.mayHaveSideEffects = true;
            }
        }

        public boolean mayHaveSideEffects() {
            return this.mayHaveSideEffects;
        }
    }
}

