/*
 * Decompiled with CFR 0.152.
 */
package aQute.libg.reporter.slf4j;

import aQute.lib.strings.Strings;
import aQute.libg.reporter.ReporterAdapter;
import aQute.service.reporter.Reporter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Slf4jReporter
extends ReporterAdapter {
    final Logger logger;

    public Slf4jReporter(Class<?> loggingClass) {
        this.logger = LoggerFactory.getLogger(loggingClass);
    }

    public Slf4jReporter() {
        this.logger = LoggerFactory.getLogger((String)"default");
    }

    @Override
    public Reporter.SetLocation error(String format, Object ... args) {
        Reporter.SetLocation location = super.error(format, args);
        if (this.logger.isErrorEnabled()) {
            String msg = Strings.format(format, args);
            this.logger.error(msg);
        }
        return location;
    }

    @Override
    public Reporter.SetLocation warning(String format, Object ... args) {
        Reporter.SetLocation location = super.warning(format, args);
        if (this.logger.isWarnEnabled()) {
            String msg = Strings.format(format, args);
            this.logger.warn(msg);
        }
        return location;
    }

    @Override
    public void trace(String format, Object ... args) {
        super.trace(format, args);
        if (this.logger.isInfoEnabled()) {
            String msg = Strings.format(format, args);
            this.logger.info(msg);
        }
    }

    @Override
    public void progress(float progress, String format, Object ... args) {
        super.progress(progress, format, args);
        if (this.logger.isDebugEnabled()) {
            String msg = Strings.format(format, args);
            this.logger.debug(msg);
        }
    }

    @Override
    public Reporter.SetLocation exception(Throwable t, String format, Object ... args) {
        Reporter.SetLocation location = super.exception(t, format, args);
        if (this.logger.isErrorEnabled()) {
            String msg = Strings.format(format, args);
            this.logger.error(msg, t);
        }
        return location;
    }

    public static Reporter getAlternative(Class<?> class1, Reporter reporter) {
        if (reporter == null) {
            return new Slf4jReporter(class1);
        }
        return reporter;
    }
}

