// Copyright 2000-2017 JetBrains s.r.o. Use of this source code is governed by the Apache 2.0 license that can be found in the LICENSE file.
package com.intellij.spring.contexts.model;

import com.intellij.openapi.util.Key;
import com.intellij.psi.xml.XmlFile;
import com.intellij.spring.facet.beans.CustomSetting;
import com.intellij.spring.model.xml.beans.Beans;
import com.intellij.util.xml.DomFileElement;
import org.jetbrains.annotations.Nullable;

public abstract class LocalXmlModel extends AbstractSimpleLocalModel<XmlFile> {

  /**
   * @since 2017.2
   */
  public static final Key<CustomSetting.BOOLEAN> PROCESS_EXPLICITLY_ANNOTATED = Key.create("process_explicitly_annotated");

  @Nullable
  public abstract DomFileElement<Beans> getRoot();
}