/*
 * Copyright 2000-2017 JetBrains s.r.o. Use of this source code is governed by the Apache 2.0 license that can be found in the LICENSE file.
 */
package com.intellij.spring.gutter.groups;

import com.intellij.codeInsight.daemon.GutterIconNavigationHandler;
import com.intellij.codeInsight.daemon.MergeableLineMarkerInfo;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.util.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import javax.swing.*;
import java.util.List;

import static com.intellij.spring.gutter.groups.SpringGutterIconBuilder.DEFAULT_GUTTER_ICON_ALIGNMENT;

public class SpringGroupMergeableLineMarkerInfo extends MergeableLineMarkerInfo<PsiElement> implements SpringGroupLineMarker {
  public SpringGroupMergeableLineMarkerInfo(@NotNull PsiElement element,
                                            @NotNull TextRange textRange,
                                            Icon icon,
                                            int updatePass,
                                            @Nullable Function<? super PsiElement, String> tooltipProvider,
                                            @Nullable GutterIconNavigationHandler<PsiElement> navHandler) {
    super(element, textRange, icon, updatePass, tooltipProvider, navHandler, DEFAULT_GUTTER_ICON_ALIGNMENT);
  }

  @Override
  public boolean canMergeWith(@NotNull MergeableLineMarkerInfo info) {
    return info instanceof SpringGroupLineMarker;
  }

  @Override
  public Icon getCommonIcon(@NotNull List<MergeableLineMarkerInfo> infos) {
    return getSpringActionGroupIcon();
  }

  public GutterIconRenderer.Alignment getCommonIconAlignment(@NotNull List<MergeableLineMarkerInfo> infos) {
    return DEFAULT_GUTTER_ICON_ALIGNMENT;
  }

  @Override
  public String getElementPresentation(PsiElement element) {
    String tooltip = getLineMarkerTooltip();
    return tooltip != null ? tooltip : super.getElementPresentation(element);
  }
}
