/*
 * Copyright 2000-2017 JetBrains s.r.o. Use of this source code is governed by the Apache 2.0 license that can be found in the LICENSE file.
 */
package com.intellij.spring.gutter.groups;

import com.intellij.codeHighlighting.Pass;
import com.intellij.codeInsight.daemon.GutterIconNavigationHandler;
import com.intellij.codeInsight.daemon.RelatedItemLineMarkerInfo;
import com.intellij.codeInsight.navigation.NavigationGutterIconRenderer;
import com.intellij.navigation.GotoRelatedItem;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.psi.PsiElement;
import com.intellij.util.ConstantFunction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.Collection;

import static com.intellij.spring.gutter.groups.SpringGutterIconBuilder.DEFAULT_GUTTER_ICON_ALIGNMENT;

public class SpringGroupRelatedItemLineMarkerInfo extends RelatedItemLineMarkerInfo<PsiElement>  implements SpringGroupLineMarker{

  public SpringGroupRelatedItemLineMarkerInfo(@NotNull PsiElement element,
                                              NavigationGutterIconRenderer renderer,
                                              @Nullable GutterIconNavigationHandler<PsiElement> navHandler,
                                              @NotNull NotNullLazyValue<Collection<? extends GotoRelatedItem>> targets) {
    super(element, element.getTextRange(), renderer.getIcon(), Pass.LINE_MARKERS,
          renderer.getTooltipText() == null ? null : new ConstantFunction<>(renderer.getTooltipText()),
          navHandler, DEFAULT_GUTTER_ICON_ALIGNMENT,
          targets);
  }
}
