/*
 * Copyright 2000-2014 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.intellij.spring.model;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.psi.PsiType;
import org.jetbrains.annotations.NotNull;

import java.util.Collection;
import java.util.Set;

/**
 * @author Yann C&eacute;bron
 */
public abstract class BeanService {

  public static BeanService getInstance() {
    return ServiceManager.getService(BeanService.class);
  }

  /**
   * @return bean effective types
   *  1. if bean is factory bean: bean type AND product type will be collected
   *  2. if factory product proxies multiple interfaces all multiple values(types) will be collected
   * @see SpringBeanEffectiveTypeProvider
   * @see SpringBeanPointer#getEffectiveBeanTypes()
   */
  @NotNull
  public abstract PsiType[] getEffectiveBeanTypes(@NotNull final CommonSpringBean bean);

  @NotNull
  public abstract SpringBeanPointer createSpringBeanPointer(@NotNull final CommonSpringBean springBean);

  /**
   * @param springBean only {@link com.intellij.spring.model.xml.DomSpringBean}
   * @return target instance
   */
  @NotNull
  public abstract SpringBeanPsiTarget createSpringBeanPsiTarget(@NotNull final CommonSpringBean springBean);

  /**
   * @see SpringBeanPointer#TO_BEAN
   */
  @NotNull
  public abstract Set<SpringBeanPointer> mapSpringBeans(@NotNull Collection<? extends CommonSpringBean> beans);
}
