package com.intellij.psi.css;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.css.descriptor.CssPseudoSelectorDescriptor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.Collection;

/**
 * User: zolotov
 *
 * Common interface for pseudo-classes and pseudo-elements
 */
public interface CssPseudoSelector extends CssSelectorSuffix, CssDescriptorOwner {
  @NotNull
  String getName();

  @Nullable
  PsiElement getNameIdentifier();

  /**
   * @return count of colons before pseudo-selector
   */
  int getColonPrefixLength();
  
  /**
   * @return range of colons inside pseudo-selector
   */
  @NotNull
  TextRange getColonPrefixRange();

  @Nullable
  String getExpressionText();

  @NotNull
  Collection<CssPseudoSelectorDescriptor> getDescriptors();
}
