/*
 * Copyright 2000-2016 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.intellij.database.model;

import com.intellij.openapi.util.Couple;
import com.intellij.util.containers.JBIterable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.Collections;
import java.util.List;
import java.util.Set;

/**
 * @author Leonid Bushuev
 **/
public interface MetaModel {

  @NotNull
  Set<Couple<ObjectKind>> getKindCouples();

  @NotNull
  JBIterable<ObjectKind> getRootNamespaceKinds();

  @NotNull
  Set<ObjectKind> getNamespaces();

  @NotNull
  JBIterable<List<ObjectKind>> getPathsToRoot(ObjectKind kind);

  @Nullable
  ObjectKind findKind(@Nullable String code);

  @NotNull
  ObjectKind unaliased(@NotNull ObjectKind kind);

  MetaModel EMPTY = new MetaModel() {
    @NotNull
    public Set<Couple<ObjectKind>> getKindCouples() { return Collections.emptySet();}

    @NotNull
    public JBIterable<ObjectKind> getRootNamespaceKinds() { return JBIterable.empty();}

    @NotNull
    public Set<ObjectKind> getNamespaces() { return Collections.emptySet(); }

    @NotNull
    public JBIterable<List<ObjectKind>> getPathsToRoot(ObjectKind kind) { return JBIterable.empty(); }

    @Nullable
    public ObjectKind findKind(@Nullable String code) { return null; }

    @NotNull
    public ObjectKind unaliased(@NotNull ObjectKind kind) { return kind; }
  };
}
