// Copyright 2000-2017 JetBrains s.r.o. Use of this source code is governed by the Apache 2.0 license that can be found in the LICENSE file.
package com.intellij.spring.boot.application.metadata;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.Collections;
import java.util.List;

public abstract class SpringBootApplicationMetaConfigKeyManager {

  public static SpringBootApplicationMetaConfigKeyManager getInstance() {
    return ServiceManager.getService(SpringBootApplicationMetaConfigKeyManager.class);
  }

  public List<SpringBootApplicationMetaConfigKey> getAllMetaConfigKeys(@Nullable PsiElement psiElement) {
    if (psiElement == null) {
      return Collections.emptyList();
    }
    return getAllMetaConfigKeys(ModuleUtilCore.findModuleForPsiElement(psiElement));
  }

  public abstract List<SpringBootApplicationMetaConfigKey> getAllMetaConfigKeys(@Nullable Module module);

  @Nullable
  public abstract SpringBootApplicationMetaConfigKey findApplicationMetaConfigKey(@Nullable Module module,
                                                                                  @Nullable String configKey);

  @NotNull
  public abstract List<SpringBootApplicationMetaConfigKey> findAllApplicationMetaConfigKeys(PsiElement psiElement,
                                                                                            @Nullable String configKey);
}
