// Copyright 2000-2017 JetBrains s.r.o. Use of this source code is governed by the Apache 2.0 license that can be found in the LICENSE file.
package com.intellij.spring.boot.model.autoconfigure.conditions;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.extensions.CustomLoadingExtensionPointBean;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.util.KeyedLazyInstance;
import com.intellij.util.xmlb.annotations.Attribute;
import org.jetbrains.annotations.NotNull;

class ConditionalContributorEP extends CustomLoadingExtensionPointBean implements KeyedLazyInstance<ConditionalContributor> {

  /**
   * FQN of library condition class.
   */
  @Attribute("condition")
  public String condition;

  /**
   * IDE implementation of condition class.
   */
  @Attribute("implementation")
  public String implementation;

  private final NotNullLazyValue<ConditionalContributor> myHandler = new NotNullLazyValue<ConditionalContributor>() {
    @Override
    @NotNull
    protected ConditionalContributor compute() {
      try {
        return (ConditionalContributor)instantiateExtension(implementation, ApplicationManager.getApplication().getPicoContainer());
      }
      catch (ClassNotFoundException e) {
        throw new RuntimeException(e);
      }
    }
  };

  @NotNull
  @Override
  public ConditionalContributor getInstance() {
    return myHandler.getValue();
  }

  @Override
  public String getKey() {
    return condition;
  }
}
