// Copyright 2000-2017 JetBrains s.r.o. Use of this source code is governed by the Apache 2.0 license that can be found in the LICENSE file.
package com.intellij.spring.boot.model.autoconfigure.conditions;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.UserDataHolderEx;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.spring.boot.application.metadata.SpringBootApplicationMetaConfigKey;
import com.intellij.spring.boot.application.metadata.SpringBootApplicationMetaConfigKeyManager;
import com.intellij.spring.boot.model.SpringBootModelConfigFileContributor;
import com.intellij.spring.boot.model.autoconfigure.conditions.jam.ConditionalOnJamElement;
import com.intellij.util.PairProcessor;
import com.intellij.util.Processor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.List;
import java.util.Set;

/**
 * Simulates run-time context for evaluating conditions.
 *
 * @see ConditionalContributor
 * @see ConditionalOnJamElement
 */
public interface ConditionalOnEvaluationContext extends UserDataHolderEx {

  @NotNull
  PsiClass getAutoConfigClass();

  @NotNull
  Module getModule();

  @Nullable
  Set<String> getActiveProfiles();

  boolean processConfigurationFiles(PairProcessor<SpringBootModelConfigFileContributor, List<VirtualFile>> processor);

  default boolean processConfigurationValues(Processor<List<SpringBootModelConfigFileContributor.ConfigurationValueResult>> processor,
                                             boolean checkRelaxedNames,
                                             @NotNull String configKey) {
    final SpringBootApplicationMetaConfigKey key =
      SpringBootApplicationMetaConfigKeyManager.getInstance().findApplicationMetaConfigKey(getModule(), configKey);
    if (key == null) return true;

    return processConfigurationValues(processor, checkRelaxedNames, key);
  }

  boolean processConfigurationValues(Processor<List<SpringBootModelConfigFileContributor.ConfigurationValueResult>> processor,
                                     boolean checkRelaxedNames,
                                     @NotNull SpringBootApplicationMetaConfigKey... configKeys);
}
