// Copyright 2000-2017 JetBrains s.r.o. Use of this source code is governed by the Apache 2.0 license that can be found in the LICENSE file.
package com.intellij.spring.boot.model.autoconfigure.conditions.jam;

import com.intellij.jam.JamElement;
import com.intellij.jam.JamService;
import com.intellij.jam.reflect.JamMemberMeta;
import com.intellij.openapi.util.Condition;
import com.intellij.semantic.SemKey;
import com.intellij.spring.boot.model.autoconfigure.conditions.ConditionalOnEvaluationContext;

/**
 * All condition JAM elements must implement this interface to be evaluated.
 * <p>
 * Registration via {@link #CONDITIONAL_JAM_ELEMENT_KEY} subKey is required.
 */
public interface ConditionalOnJamElement extends Condition<ConditionalOnEvaluationContext>, JamElement {

  SemKey<ConditionalOnJamElement> CONDITIONAL_JAM_ELEMENT_KEY =
    JamService.JAM_ELEMENT_KEY.subKey("ConditionalOnJamElement");

  SemKey<JamMemberMeta> MEMBER_META_KEY = JamService.getMetaKey(CONDITIONAL_JAM_ELEMENT_KEY);

  interface NonStrict extends ConditionalOnJamElement {
  }
}
