// Copyright 2000-2017 JetBrains s.r.o. Use of this source code is governed by the Apache 2.0 license that can be found in the LICENSE file.
package com.intellij.spring.boot.model.autoconfigure.jam;

import com.intellij.jam.reflect.JamAnnotationMeta;
import com.intellij.jam.reflect.JamClassMeta;
import com.intellij.spring.boot.model.autoconfigure.SpringBootAutoconfigureClassesConstants;

public abstract class AutoConfigureAfter extends AutoConfigureByClassesOrderBase {

  private static final JamAnnotationMeta ANNOTATION_META =
    new JamAnnotationMeta(SpringBootAutoconfigureClassesConstants.AUTO_CONFIGURE_AFTER, ARCHETYPE);

  public static final JamClassMeta<AutoConfigureAfter> META =
    new JamClassMeta<>(AutoConfigureAfter.class)
      .addAnnotation(ANNOTATION_META);

  @Override
  protected JamAnnotationMeta getAnnotationMeta() {
    return ANNOTATION_META;
  }
}
