// Copyright 2000-2017 JetBrains s.r.o. Use of this source code is governed by the Apache 2.0 license that can be found in the LICENSE file.
package com.intellij.spring.boot.model.autoconfigure.jam;

import com.intellij.jam.JamClassAttributeElement;
import com.intellij.jam.JamElement;
import com.intellij.jam.JamStringAttributeElement;
import com.intellij.jam.annotations.JamPsiConnector;
import com.intellij.jam.reflect.*;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElementRef;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.spring.boot.model.jam.StringLiteralPsiClassConverter;
import com.intellij.util.containers.ContainerUtil;
import org.jetbrains.annotations.NotNull;

import java.util.List;

abstract class AutoConfigureByClassesOrderBase implements JamElement {

  private static final JamStringAttributeMeta.Collection<PsiClass> NAME_ATTRIBUTE =
    JamAttributeMeta.collectionString("name", new StringLiteralPsiClassConverter());

  private static final JamClassAttributeMeta.Collection VALUE_ATTRIBUTE =
    JamAttributeMeta.classCollection("value");

  protected static final JamAnnotationArchetype ARCHETYPE =
    new JamAnnotationArchetype()
      .addAttribute(NAME_ATTRIBUTE)
      .addAttribute(VALUE_ATTRIBUTE);

  @NotNull
  @JamPsiConnector
  public abstract PsiModifierListOwner getPsiElement();

  protected abstract JamAnnotationMeta getAnnotationMeta();

  public List<PsiClass> getClasses() {
    final PsiElementRef<PsiAnnotation> annotationRef = getAnnotationMeta().getAnnotationRef(getPsiElement());

    final List<JamClassAttributeElement> valueElements = VALUE_ATTRIBUTE.getJam(annotationRef);
    if (!valueElements.isEmpty()) {
      return ContainerUtil.mapNotNull(valueElements, JamClassAttributeElement::getValue);
    }

    final List<JamStringAttributeElement<PsiClass>> nameElements = NAME_ATTRIBUTE.getJam(annotationRef);
    return ContainerUtil.mapNotNull(nameElements, JamStringAttributeElement::getValue);
  }
}