// Copyright 2000-2017 JetBrains s.r.o. Use of this source code is governed by the Apache 2.0 license that can be found in the LICENSE file.
package com.intellij.spring.boot.model.autoconfigure.jam;

import com.intellij.jam.JamElement;
import com.intellij.jam.JamNumberAttributeElement;
import com.intellij.jam.annotations.JamPsiConnector;
import com.intellij.jam.model.util.JamCommonUtil;
import com.intellij.jam.reflect.*;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.spring.boot.model.autoconfigure.SpringBootAutoconfigureClassesConstants;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/**
 * @since 2017.1
 */
public abstract class AutoConfigureOrder implements JamElement {

  public static final String ORDER_ATTRIBUTE_NAME = PsiAnnotation.DEFAULT_REFERENCED_METHOD_NAME;

  private static final JamNumberAttributeMeta.Single<Integer> VALUE_ATTR_META =
    JamAttributeMeta.singleInteger(ORDER_ATTRIBUTE_NAME);

  private static final JamAnnotationMeta ANNO_META =
    new JamAnnotationMeta(SpringBootAutoconfigureClassesConstants.AUTO_CONFIGURE_ORDER).
      addAttribute(VALUE_ATTR_META);

  private static final JamMemberArchetype<PsiModifierListOwner, AutoConfigureOrder> ARCHETYPE =
    new JamMemberArchetype<PsiModifierListOwner, AutoConfigureOrder>()
      .addAnnotation(ANNO_META);

  public static final JamClassMeta<AutoConfigureOrder> CLASS_META =
    new JamClassMeta<>(ARCHETYPE, AutoConfigureOrder.class);
  public static final JamFieldMeta<AutoConfigureOrder> FIELD_META =
    new JamFieldMeta<>(ARCHETYPE, AutoConfigureOrder.class);
  public static final JamMethodMeta<AutoConfigureOrder> METHOD_META =
    new JamMethodMeta<>(ARCHETYPE, AutoConfigureOrder.class);

  @NotNull
  @JamPsiConnector
  public abstract PsiModifierListOwner getPsiElement();

  @Nullable
  public Integer getValue() {
    final JamNumberAttributeElement<Integer> jam = VALUE_ATTR_META.getJam(ANNO_META.getAnnotationRef(getPsiElement()));
    if (jam.getPsiElement() != null) {
      return jam.getValue();
    }

    final PsiAnnotation autoConfigureAnnotation = jam.getParentAnnotationElement().getPsiElement();
    if (autoConfigureAnnotation == null) {
      return null;
    }

    final PsiAnnotationMemberValue annotationAttributeValue = autoConfigureAnnotation.findAttributeValue(ORDER_ATTRIBUTE_NAME);
    return JamCommonUtil.getObjectValue(annotationAttributeValue, Integer.class);
  }
}
