// Copyright 2000-2017 JetBrains s.r.o. Use of this source code is governed by the Apache 2.0 license that can be found in the LICENSE file.
package com.intellij.spring.boot.model.autoconfigure.jam;

import com.intellij.jam.JamElement;
import com.intellij.jam.annotations.JamPsiConnector;
import com.intellij.jam.reflect.JamAnnotationMeta;
import com.intellij.jam.reflect.JamClassMeta;
import com.intellij.psi.PsiClass;
import com.intellij.spring.boot.model.autoconfigure.SpringBootAutoconfigureClassesConstants;
import org.jetbrains.annotations.NotNull;

public abstract class SpringBootApplication implements JamElement {

  private static final JamAnnotationMeta ANNOTATION_META =
    new JamAnnotationMeta(SpringBootAutoconfigureClassesConstants.SPRING_BOOT_APPLICATION,
                          EnableAutoConfiguration.EXCLUDE_ARCHETYPE);

  public static final JamClassMeta<SpringBootApplication> META =
    new JamClassMeta<>(SpringBootApplication.class)
      .addAnnotation(ANNOTATION_META);

  @NotNull
  @JamPsiConnector
  public abstract PsiClass getPsiElement();
}
