// Copyright 2000-2017 JetBrains s.r.o. Use of this source code is governed by the Apache 2.0 license that can be found in the LICENSE file.
package com.intellij.spring.boot.model.jam;

import com.intellij.jam.JamConverter;
import com.intellij.jam.JamStringAttributeElement;
import com.intellij.openapi.util.Conditions;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiLiteral;
import com.intellij.psi.PsiReference;
import com.intellij.spring.model.utils.resources.SpringResourcesBuilder;
import com.intellij.spring.model.utils.resources.SpringResourcesUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.Collection;

public class ResourceItemsConverter extends JamConverter<Collection<PsiFileSystemItem>> {

  @Nullable
  @Override
  public Collection<PsiFileSystemItem> fromString(@Nullable String s,
                                                  JamStringAttributeElement<Collection<PsiFileSystemItem>> context) {
    return SpringResourcesUtil.getInstance().getResourceItems(createReferences(context), Conditions.alwaysTrue());
  }

  @NotNull
  @Override
  public PsiReference[] createReferences(JamStringAttributeElement<Collection<PsiFileSystemItem>> context) {
    final PsiLiteral literal = context.getPsiLiteral();
    if (literal == null) return PsiReference.EMPTY_ARRAY;

    String s = context.getStringValue();
    if (s == null) return PsiReference.EMPTY_ARRAY;

    final SpringResourcesBuilder resourcesBuilder =
      SpringResourcesBuilder.create(literal, s).fromRoot(s.startsWith("/")).soft(true);
    return SpringResourcesUtil.getInstance().getReferences(resourcesBuilder);
  }
}
