// Copyright 2000-2017 JetBrains s.r.o. Use of this source code is governed by the Apache 2.0 license that can be found in the LICENSE file.
package com.intellij.spring.boot.model.properties.jam;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.jam.JamClassAttributeElement;
import com.intellij.jam.JamElement;
import com.intellij.jam.annotations.JamPsiConnector;
import com.intellij.jam.reflect.JamAnnotationMeta;
import com.intellij.jam.reflect.JamAttributeMeta;
import com.intellij.jam.reflect.JamClassAttributeMeta;
import com.intellij.jam.reflect.JamClassMeta;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.spring.boot.SpringBootClassesConstants;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import org.jetbrains.annotations.NotNull;

import java.util.List;

public abstract class EnableConfigurationProperties implements JamElement {

  private static final JamClassAttributeMeta.Collection VALUE_META =
    JamAttributeMeta.classCollection("value");

  private static final JamAnnotationMeta ANNOTATION_META =
    new JamAnnotationMeta(SpringBootClassesConstants.ENABLE_CONFIGURATION_PROPERTIES)
      .addAttribute(VALUE_META);

  public static final JamClassMeta<EnableConfigurationProperties> CLASS_META =
    new JamClassMeta<>(EnableConfigurationProperties.class)
      .addAnnotation(ANNOTATION_META);

  @NotNull
  @JamPsiConnector
  public abstract PsiClass getPsiElement();

  public PsiAnnotation getAnnotation() {
    return AnnotationUtil.findAnnotation(getPsiElement(), true, ANNOTATION_META.getAnnoName());
  }

  public List<PsiClass> getValue() {
    final List<JamClassAttributeElement> valueAttributeElements = ANNOTATION_META.getAttribute(getPsiElement(), VALUE_META);

    List<PsiClass> value = new SmartList<>();
    for (JamClassAttributeElement element : valueAttributeElements) {
      ContainerUtil.addIfNotNull(value, element.getValue());
    }
    return value;
  }
}