// Copyright 2000-2017 JetBrains s.r.o. Use of this source code is governed by the Apache 2.0 license that can be found in the LICENSE file.
package com.intellij.spring.boot.model.properties.jam;

import com.intellij.jam.JamElement;
import com.intellij.jam.annotations.JamPsiConnector;
import com.intellij.jam.reflect.JamAnnotationMeta;
import com.intellij.jam.reflect.JamFieldMeta;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiField;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.spring.boot.SpringBootClassesConstants;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class NestedConfigurationProperty implements JamElement {

  private static final JamAnnotationMeta ANNOTATION_META =
    new JamAnnotationMeta(SpringBootClassesConstants.NESTED_CONFIGURATION_PROPERTY);

  public static final JamFieldMeta<NestedConfigurationProperty> FIELD_META =
    new JamFieldMeta<>(NestedConfigurationProperty.class)
      .addAnnotation(ANNOTATION_META);

  @NotNull
  @JamPsiConnector
  protected abstract PsiField getPsiField();

  public boolean typeMatches(@NotNull PsiClass psiClass) {
    final PsiField field = getPsiField();
    final PsiClass fieldClass = PsiTypesUtil.getPsiClass(field.getType());

    return psiClass.isEquivalentTo(fieldClass);
  }

  @Nullable
  public ConfigurationProperties getEnclosingConfigurationProperties() {
    final PsiClass containingClass = getPsiField().getContainingClass();
    if (containingClass == null) return null;

    return ConfigurationProperties.CLASS_META.getJamElement(containingClass);
  }
}
